/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui.orders;

import com.google.inject.Key;
import com.google.inject.name.Names;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.overlord.domain.client.OrdersGuiFactory;
import dev.the_fireplace.overlord.domain.client.ScreenOpener;
import dev.the_fireplace.overlord.domain.data.Squads;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.aiconfig.AISettings;
import dev.the_fireplace.overlord.item.OrdersWandItem;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import dev.the_fireplace.overlord.network.client.builder.IssueLocalOrdersBufferBuilder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class LocalOrdersScreen
extends class_437 {
    private final int orderDistance;
    private final ScreenOpener screenOpener;
    private final OrdersGuiFactory ordersGuiFactory;
    private final Squads squads;
    private long lastEntityScanTimestamp = 0L;
    private int matchingArmyMemberCount = 0;

    public LocalOrdersScreen(int orderDistance) {
        super((class_2561)new class_2588("gui.overlord.local_orders.name"));
        this.orderDistance = orderDistance;
        this.screenOpener = (ScreenOpener)DIContainer.get().getInstance(ScreenOpener.class);
        this.ordersGuiFactory = (OrdersGuiFactory)DIContainer.get().getInstance(OrdersGuiFactory.class);
        this.squads = (Squads)DIContainer.get().getInstance(Key.get(Squads.class, (Annotation)Names.named((String)"client")));
    }

    protected void method_25426() {
        super.method_25426();
        Objects.requireNonNull(this.field_22787);
        Objects.requireNonNull(this.field_22787.field_1724);
        class_4185.class_4241 openOrdersScreen = b -> {
            class_1799 wandStack = OrdersWandItem.getActiveWand((class_1657)this.field_22787.field_1724);
            if (!wandStack.method_7960()) {
                AISettings settings = new AISettings();
                if (wandStack.method_7985() && wandStack.method_7969().method_10545("ai")) {
                    settings.readTag(wandStack.method_7969().method_10562("ai"));
                }
                this.field_22787.method_1507(this.ordersGuiFactory.build((class_437)this, settings));
            }
        };
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 50, this.field_22790 / 2, 100, 20, (class_2561)new class_2588("gui.overlord.orders"), openOrdersScreen));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 50, this.field_22790 / 2 + 22, 100, 20, (class_2561)new class_2588("gui.overlord.select_squad"), b -> this.screenOpener.openSquadSelectorGUI(null)));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 102, this.field_22790 / 2 + 44, 100, 20, (class_2561)new class_2588("gui.overlord.local_orders.issue_orders"), this::issueOrders));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 2, this.field_22790 / 2 + 44, 100, 20, (class_2561)new class_2588("gui.done"), b -> this.closeScreen()));
    }

    private void closeScreen() {
        class_310.method_1551().method_1507(null);
    }

    private void issueOrders(class_4185 unused) {
        ClientPlayNetworking.send((class_2960)ClientToServerPacketIDs.ISSUE_LOCAL_ORDERS, (class_2540)IssueLocalOrdersBufferBuilder.build());
        this.closeScreen();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (System.currentTimeMillis() - this.lastEntityScanTimestamp > 2000L) {
            this.lastEntityScanTimestamp = System.currentTimeMillis();
            this.countMatchingEntities();
        }
        Objects.requireNonNull(this.field_22787);
        Objects.requireNonNull(this.field_22787.field_1724);
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        class_2588 currentlyOrderingText = new class_2588("gui.overlord.local_orders.currently_ordering.any", new Object[]{this.orderDistance});
        class_1799 wandStack = OrdersWandItem.getActiveWand((class_1657)this.field_22787.field_1724);
        if (!wandStack.method_7960() && wandStack.method_7985() && wandStack.method_7969().method_10545("squad")) {
            UUID squadId = wandStack.method_7969().method_25926("squad");
            Squad squad = this.squads.getSquad(this.field_22787.field_1724.method_5667(), squadId);
            if (squad != null) {
                currentlyOrderingText = new class_2588("gui.overlord.local_orders.currently_ordering.squad", new Object[]{squad.getName(), this.orderDistance});
            }
        }
        this.field_22793.method_30883(matrices, (class_2561)currentlyOrderingText, (float)this.field_22789 / 2.0f - (float)this.field_22793.method_27525((class_5348)currentlyOrderingText) / 2.0f, (float)this.field_22790 / 2.0f - 20.0f, 0xFFFFFF);
        class_2588 matchingCountText = new class_2588("gui.overlord.local_orders.matching_count", new Object[]{this.matchingArmyMemberCount});
        this.field_22793.method_30883(matrices, (class_2561)matchingCountText, (float)this.field_22789 / 2.0f - (float)this.field_22793.method_27525((class_5348)matchingCountText) / 2.0f, (float)this.field_22790 / 2.0f - 10.0f, 0xFFFFFF);
    }

    private void countMatchingEntities() {
        Objects.requireNonNull(this.field_22787);
        Objects.requireNonNull(this.field_22787.field_1724);
        class_1799 wandStack = OrdersWandItem.getActiveWand((class_1657)this.field_22787.field_1724);
        if (wandStack.method_7960()) {
            this.matchingArmyMemberCount = 0;
            return;
        }
        UUID squadId = wandStack.method_7985() && wandStack.method_7969().method_10545("squad") ? wandStack.method_7969().method_25926("squad") : null;
        List nearbyArmyMembers = this.field_22787.field_1724.field_6002.method_8390(ArmyEntity.class, this.field_22787.field_1724.method_5829().method_1014((double)this.orderDistance), entity -> this.field_22787.field_1724.method_5667().equals(entity.method_6139()) && (squadId == null || entity.getSquad().equals(squadId)));
        this.matchingArmyMemberCount = nearbyArmyMembers.size();
    }
}

