/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui.squad;

import com.google.inject.Key;
import com.google.inject.name.Names;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.lib.api.chat.injectables.TextStyles;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.client.gui.PartialScreen;
import dev.the_fireplace.overlord.client.gui.squad.ItemSelectionScreenPart;
import dev.the_fireplace.overlord.client.gui.squad.PatternSelectionScreenPart;
import dev.the_fireplace.overlord.client.gui.squad.SelectorScreen;
import dev.the_fireplace.overlord.domain.data.SquadPatterns;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import dev.the_fireplace.overlord.network.client.builder.UpdateSquadBufferBuilder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class EditScreen
extends class_437 {
    private static final class_2588 SQUAD_NAME_FIELD_TITLE = new class_2588("gui.overlord.create_squad.squad_name");
    private final EmptyUUID emptyUUID;
    private final SquadPatterns squadPatterns;
    private final TextStyles textStyles;
    private final SelectorScreen parent;
    private final Collection<class_1799> stacks;
    private final UUID squadId;
    private final PatternSelectionScreenPart.State patternState;
    private final ItemSelectionScreenPart.State itemState;
    private String squadName = "";
    private class_4185 confirmButton;
    private boolean saving = false;
    private List<class_2561> errors = Collections.emptyList();

    protected EditScreen(SelectorScreen parent, Collection<class_1799> squadItems, @Nullable Squad currentSquad) {
        super((class_2561)new class_2588("gui.overlord.create_squad.name"));
        this.emptyUUID = (EmptyUUID)DIContainer.get().getInstance(EmptyUUID.class);
        this.squadPatterns = (SquadPatterns)DIContainer.get().getInstance(Key.get(SquadPatterns.class, (Annotation)Names.named((String)"client")));
        this.textStyles = (TextStyles)DIContainer.get().getInstance(TextStyles.class);
        this.parent = parent;
        this.stacks = squadItems;
        String pattern = "";
        class_1799 stack = class_1799.field_8037;
        if (currentSquad != null) {
            this.squadName = currentSquad.getName();
            pattern = currentSquad.getPattern();
            stack = currentSquad.getItem();
            this.squadId = currentSquad.getSquadId();
        } else {
            this.squadId = this.emptyUUID.get();
        }
        this.patternState = new PatternSelectionScreenPart.State(new class_2960("overlord", pattern), identifier -> this.updateConfirmButtonEnabled());
        this.itemState = new ItemSelectionScreenPart.State(stack, updatedStack -> this.updateConfirmButtonEnabled());
    }

    protected void method_25426() {
        PatternSelectionScreenPart patternSelectionScreenPart = new PatternSelectionScreenPart(4, 4, this.field_22789 / 2 - 4, this.field_22790 - 4 - 30, this.patternState);
        ItemSelectionScreenPart itemSelectionScreenPart = new ItemSelectionScreenPart(this.field_22789 / 2, 44, this.field_22789 / 2 - 4, this.field_22790 - 30 - 4 - 44, this.stacks, this.itemState);
        this.addPartialScreenChildren(patternSelectionScreenPart);
        this.addPartialScreenChildren(itemSelectionScreenPart);
        class_342 squadNameField = new class_342(this.field_22793, this.field_22789 * 3 / 4 - 100, 20, 200, 20, (class_2561)SQUAD_NAME_FIELD_TITLE);
        squadNameField.method_1852(this.squadName);
        squadNameField.method_1863(newSquadName -> {
            this.squadName = newSquadName;
            this.updateConfirmButtonEnabled();
        });
        this.method_37063((class_364)squadNameField);
        class_4185.class_4241 confirmAction = button -> {
            ClientPlayNetworking.send((class_2960)ClientToServerPacketIDs.UPDATE_SQUAD, (class_2540)UpdateSquadBufferBuilder.build(this.squadId, this.squadName, this.patternState.getPatternId().method_12832(), this.itemState.getStack(), this.parent.getEntityId()));
            this.saving = true;
            this.updateConfirmButtonEnabled();
        };
        class_4185.class_5316 confirmTooltipSupplier = (buttonWidget, matrixStack, i, j) -> this.method_30901(matrixStack, this.errors, i, j);
        this.confirmButton = new class_4185(this.field_22789 / 2 - 202, this.field_22790 - 30, 200, 20, (class_2561)new class_2588("gui.overlord.confirm_exit"), confirmAction, confirmTooltipSupplier);
        this.method_37063((class_364)this.confirmButton);
        this.updateConfirmButtonEnabled();
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 2, this.field_22790 - 30, 200, 20, (class_2561)new class_2588("gui.cancel"), button -> this.closeScreen()));
    }

    private <T extends class_364 & class_4068> void addPartialScreenChildren(PartialScreen widget) {
        for (class_364 child : widget.getChildren()) {
            this.method_37063(child);
        }
    }

    private void closeScreen() {
        class_310.method_1551().method_1507((class_437)this.parent);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.field_22793.method_30883(matrices, (class_2561)SQUAD_NAME_FIELD_TITLE, (float)this.field_22789 * 3.0f / 4.0f - (float)this.field_22793.method_27525((class_5348)SQUAD_NAME_FIELD_TITLE) / 2.0f, 4.0f, 0xFFFFFF);
    }

    public void onSuccessfulCreation(Squad createdSquad) {
        this.parent.displaySquad(createdSquad);
        this.closeScreen();
    }

    public void onFailedCreation(List<class_2561> reasons) {
        this.errors = reasons;
        this.confirmButton.field_22763 = false;
        this.saving = false;
    }

    private void updateConfirmButtonEnabled() {
        if (this.saving) {
            this.errors = List.of(this.createStyledError("gui.overlord.create_squad.saving"));
            this.confirmButton.field_22763 = false;
        } else {
            this.calculateErrors();
            this.confirmButton.field_22763 = this.errors.isEmpty();
        }
    }

    private void calculateErrors() {
        class_1799 stack;
        String pattern;
        ArrayList<class_2561> errors = new ArrayList<class_2561>();
        boolean hasLookupPreventingErrors = false;
        if (this.squadName.isBlank()) {
            errors.add(this.createStyledError("gui.overlord.create_squad.name_required"));
        }
        if ((pattern = this.patternState.getPatternId().method_12832()).isEmpty()) {
            hasLookupPreventingErrors = true;
            errors.add(this.createStyledError("gui.overlord.create_squad.pattern_required"));
        }
        if ((stack = this.itemState.getStack()).method_7960()) {
            hasLookupPreventingErrors = true;
            errors.add(this.createStyledError("gui.overlord.create_squad.item_required"));
        }
        if (hasLookupPreventingErrors) {
            this.errors = errors;
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        Objects.requireNonNull(player, "Client player cannot be null when creating squads!");
        if (!this.squadPatterns.canUsePattern(player.method_5667(), pattern)) {
            Overlord.getLogger().error("Locked pattern warning produced on client, this should not be allowed!");
            errors.add(this.createStyledError("gui.overlord.create_squad.locked_pattern"));
        }
        if (!this.emptyUUID.is(this.squadId)) {
            if (!this.squadPatterns.isPatternUnusedByOtherSquads(pattern, stack, player.method_5667(), this.squadId)) {
                errors.add(this.createStyledError("gui.overlord.create_squad.pattern_taken"));
            }
        } else if (!this.squadPatterns.isPatternUnused(pattern, stack)) {
            errors.add(this.createStyledError("gui.overlord.create_squad.pattern_taken"));
        }
        this.errors = errors;
    }

    private class_2561 createStyledError(String s) {
        return new class_2588(s).method_10862(this.textStyles.red());
    }
}

