/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui.squad;

import dev.the_fireplace.overlord.client.gui.PartialScreen;
import dev.the_fireplace.overlord.client.gui.squad.ItemButtonWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public class ItemSelectionScreenPart
implements PartialScreen {
    private static final int DISTANCE_BETWEEN_ITEMS = 2;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final Collection<class_1799> items;
    private final State state;
    private final List<ItemButtonWidget> itemWidgets = new ArrayList<ItemButtonWidget>();
    private class_4185 previousButton;
    private class_4185 nextButton;

    public ItemSelectionScreenPart(int x, int y, int width, int height, Collection<class_1799> items, State state) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.items = items;
        this.state = state;
        this.createWidgets();
    }

    @Override
    public <T extends class_364 & class_4068> List<T> getChildren() {
        ArrayList<class_4185> children = new ArrayList<class_4185>(this.itemWidgets.size() + 2);
        children.addAll(this.itemWidgets);
        children.add(this.nextButton);
        children.add(this.previousButton);
        return children;
    }

    private void createWidgets() {
        this.createItemWidgets();
        this.calculateStartingPage();
        this.updateItemVisibility();
        this.createPageChangeButtons();
    }

    private void createItemWidgets() {
        this.itemWidgets.clear();
        int columnIndex = 0;
        int rowIndex = 0;
        int widgetSize = this.getItemWidgetSize();
        int displayedColumnCount = this.getColumnCount();
        int displayedRowCount = this.getRowCount();
        for (class_1799 item : this.items) {
            int column = columnIndex % displayedColumnCount;
            int row = rowIndex % displayedRowCount;
            int widgetX = this.x + column * (widgetSize + 2);
            int widgetY = this.y + 24 + row * (widgetSize + 2);
            ItemButtonWidget itemButtonWidget = new ItemButtonWidget(widgetX, widgetY, widgetSize, widgetSize, item, itemWidget -> {
                this.state.setSelectedStack(item);
                this.notifyChildrenOfItem();
            });
            this.itemWidgets.add(itemButtonWidget);
            if (++columnIndex % displayedColumnCount != 0) continue;
            ++rowIndex;
        }
        this.notifyChildrenOfItem();
    }

    private int getItemAreaHeight() {
        return this.height - 24;
    }

    private int getItemAreaWidth() {
        return this.width;
    }

    private int getItemWidgetSize() {
        return 20;
    }

    private int getColumnCount() {
        return Math.max(1, this.getItemAreaWidth() / (this.getItemWidgetSize() + 2));
    }

    private int getRowCount() {
        return Math.max(1, this.getItemAreaHeight() / (this.getItemWidgetSize() + 2));
    }

    private int getItemsPerPage() {
        return this.getColumnCount() * this.getRowCount();
    }

    private void updateItemVisibility() {
        for (int index = 0; index < this.itemWidgets.size(); ++index) {
            int itemPage = index / this.getItemsPerPage();
            this.itemWidgets.get((int)index).field_22764 = itemPage == this.state.currentPage;
        }
    }

    private int getPageCount() {
        int itemCount = this.itemWidgets.size();
        int itemsPerPage = this.getItemsPerPage();
        return itemCount / itemsPerPage + (itemCount % itemsPerPage == 0 ? 0 : 1);
    }

    private void calculateStartingPage() {
        if (this.state.selectedStack.method_7960()) {
            this.state.currentPage = 0;
            return;
        }
        int widgetIndex = 0;
        for (ItemButtonWidget itemWidget : this.itemWidgets) {
            if (class_1799.method_7973((class_1799)itemWidget.stack, (class_1799)this.state.selectedStack)) {
                this.state.currentPage = (byte)(widgetIndex / this.getItemsPerPage());
                return;
            }
            ++widgetIndex;
        }
        this.state.currentPage = 0;
    }

    private void createPageChangeButtons() {
        this.previousButton = new class_4185(this.x, this.y, this.width / 2 - 2, 20, (class_2561)new class_2588("gui.overlord.create_squad.previous"), buttonWidget -> {
            this.state.currentPage = (byte)(this.state.currentPage - 1);
            this.updatePageChangeButtonUsability();
            this.updateItemVisibility();
        });
        this.nextButton = new class_4185(this.x + this.width / 2 + 4, this.y, this.width / 2 - 6, 20, (class_2561)new class_2588("gui.overlord.create_squad.next"), buttonWidget -> {
            this.state.currentPage = (byte)(this.state.currentPage + 1);
            this.updatePageChangeButtonUsability();
            this.updateItemVisibility();
        });
        this.updatePageChangeButtonUsability();
    }

    private void updatePageChangeButtonUsability() {
        this.previousButton.field_22763 = this.state.currentPage > 0;
        this.nextButton.field_22763 = this.state.currentPage < this.getPageCount() - 1;
    }

    private void notifyChildrenOfItem() {
        for (ItemButtonWidget itemWidget : this.itemWidgets) {
            itemWidget.notifyOfActiveStack(this.state.selectedStack);
        }
    }

    static class State {
        private final Consumer<class_1799> onChanged;
        private byte currentPage = 0;
        private class_1799 selectedStack;

        public State(class_1799 selectedStack, Consumer<class_1799> onChanged) {
            this.selectedStack = selectedStack;
            this.onChanged = onChanged;
        }

        public void setSelectedStack(class_1799 selectedStack) {
            this.selectedStack = selectedStack;
            this.onChanged.accept(selectedStack);
        }

        public class_1799 getStack() {
            return this.selectedStack;
        }
    }
}

