/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui.squad;

import dev.the_fireplace.overlord.client.gui.PartialScreen;
import dev.the_fireplace.overlord.client.gui.squad.PatternButtonWidget;
import dev.the_fireplace.overlord.util.SquadPatterns;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public class PatternSelectionScreenPart
implements PartialScreen {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final State state;
    private final List<PatternButtonWidget> patternWidgets = new ArrayList<PatternButtonWidget>();
    private class_4185 previousButton;
    private class_4185 nextButton;

    public PatternSelectionScreenPart(int x, int y, int width, int height, State state) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.state = state;
        this.createWidgets();
    }

    @Override
    public <T extends class_364 & class_4068> List<T> getChildren() {
        ArrayList<class_4185> children = new ArrayList<class_4185>(this.patternWidgets.size() + 2);
        children.addAll(this.patternWidgets);
        children.add(this.nextButton);
        children.add(this.previousButton);
        return children;
    }

    private void createWidgets() {
        this.createPatternWidgets();
        this.calculateStartingPage();
        this.updatePatternVisibility();
        this.createPageChangeButtons();
    }

    private void createPatternWidgets() {
        this.patternWidgets.clear();
        int columnIndex = 0;
        int rowIndex = 0;
        int widgetWidth = this.getPatternWidgetWidth();
        int widgetHeight = this.getPatternWidgetHeight();
        int displayedColumnCount = this.getColumnCount();
        int displayedRowCount = this.getRowCount();
        for (String pattern : SquadPatterns.getPatterns()) {
            int column = columnIndex % displayedColumnCount;
            int row = rowIndex % displayedRowCount;
            int widgetX = this.x + column * (widgetWidth + 4);
            int widgetY = this.y + 24 + row * (widgetHeight + 4);
            class_2588 widgetName = new class_2588("squad.overlord.pattern." + pattern + ".name");
            class_2960 patternId = new class_2960("overlord", pattern);
            PatternButtonWidget patternButtonWidget = new PatternButtonWidget(widgetX, widgetY, widgetWidth, widgetHeight, (class_2561)widgetName, patternId, patternWidget -> {
                this.state.setPatternId(patternId);
                this.notifyChildrenOfPattern();
            });
            this.patternWidgets.add(patternButtonWidget);
            if (++columnIndex % displayedColumnCount != 0) continue;
            ++rowIndex;
        }
        this.notifyChildrenOfPattern();
    }

    private int getPatternAreaHeight() {
        return this.height - 24;
    }

    private int getPatternAreaWidth() {
        return this.width;
    }

    private int getPatternWidgetHeight() {
        return this.getPatternAreaHeight() / this.getRowCount() - 4;
    }

    private int getPatternWidgetWidth() {
        return this.getPatternAreaWidth() / this.getColumnCount() - 4;
    }

    private int getColumnCount() {
        int minimumPatternWidth = 70;
        return Math.max(1, this.getPatternAreaWidth() / minimumPatternWidth);
    }

    private int getRowCount() {
        int minimumPatternHeight = 70;
        return Math.max(1, this.getPatternAreaHeight() / minimumPatternHeight);
    }

    private int getPatternsPerPage() {
        return this.getColumnCount() * this.getRowCount();
    }

    private void updatePatternVisibility() {
        for (int index = 0; index < this.patternWidgets.size(); ++index) {
            int patternPage = index / this.getPatternsPerPage();
            this.patternWidgets.get((int)index).field_22764 = patternPage == this.state.currentPage;
        }
    }

    private int getPageCount() {
        int patternCount = this.patternWidgets.size();
        int patternsPerPage = this.getPatternsPerPage();
        return patternCount / patternsPerPage + (patternCount % patternsPerPage == 0 ? 0 : 1);
    }

    private void calculateStartingPage() {
        if (this.state.patternId.method_12832().isEmpty()) {
            this.state.currentPage = 0;
            return;
        }
        int widgetIndex = 0;
        for (PatternButtonWidget patternWidget : this.patternWidgets) {
            if (patternWidget.pattern.equals((Object)this.state.patternId)) {
                this.state.currentPage = (byte)(widgetIndex / this.getPatternsPerPage());
                return;
            }
            ++widgetIndex;
        }
        this.state.currentPage = 0;
    }

    private void createPageChangeButtons() {
        this.previousButton = new class_4185(this.x, this.y, this.width / 2 - 2, 20, (class_2561)new class_2588("gui.overlord.create_squad.previous"), buttonWidget -> {
            this.state.currentPage = (byte)(this.state.currentPage - 1);
            this.updatePageChangeButtonUsability();
            this.updatePatternVisibility();
        });
        this.nextButton = new class_4185(this.x + this.width / 2 + 4, this.y, this.width / 2 - 6, 20, (class_2561)new class_2588("gui.overlord.create_squad.next"), buttonWidget -> {
            this.state.currentPage = (byte)(this.state.currentPage + 1);
            this.updatePageChangeButtonUsability();
            this.updatePatternVisibility();
        });
        this.updatePageChangeButtonUsability();
    }

    private void updatePageChangeButtonUsability() {
        this.previousButton.field_22763 = this.state.currentPage > 0;
        this.nextButton.field_22763 = this.state.currentPage < this.getPageCount() - 1;
    }

    private void notifyChildrenOfPattern() {
        for (PatternButtonWidget patternWidget : this.patternWidgets) {
            patternWidget.notifyOfActivePattern(this.state.patternId);
        }
    }

    static class State {
        private final Consumer<class_2960> onChanged;
        private byte currentPage = 0;
        private class_2960 patternId;

        public State(class_2960 patternId, Consumer<class_2960> onChanged) {
            this.patternId = patternId;
            this.onChanged = onChanged;
        }

        private void setPatternId(class_2960 patternId) {
            this.patternId = patternId;
            this.onChanged.accept(patternId);
        }

        public class_2960 getPatternId() {
            return this.patternId;
        }
    }
}

