/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui.squad;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.the_fireplace.overlord.client.gui.rendertools.BoxRenderer;
import dev.the_fireplace.overlord.client.gui.rendertools.PatternRenderer;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class SelectorEntry
extends class_4280.class_4281<SelectorEntry> {
    protected final class_310 client = class_310.method_1551();
    protected final Squad squad;
    protected boolean selected = false;

    SelectorEntry(Squad squad) {
        this.squad = squad;
    }

    public void method_25343(class_4587 matrixStack, int index, int entryTop, int entryLeft, int width, int height, int mouseX, int mouseY, boolean hovering, float delta) {
        int iconWidth = (int)((float)height * 3.0f / 5.0f);
        this.drawIcon(matrixStack, entryTop, entryLeft, height, iconWidth);
        this.drawName(matrixStack, entryTop, entryLeft, width, height, iconWidth);
        this.drawBorder(matrixStack, entryTop, entryLeft, width, height, hovering);
    }

    private void drawIcon(class_4587 matrixStack, int entryTop, int entryLeft, int iconHeight, int iconWidth) {
        if (this.squad.getPattern().isBlank() || this.squad.getItem().method_7960()) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        PatternRenderer.drawPattern(matrixStack, new class_2960("overlord", this.squad.getPattern()), entryLeft, entryTop, iconWidth, iconHeight, 1.0f);
        class_310 minecraftClient = class_310.method_1551();
        class_918 itemRenderer = minecraftClient.method_1480();
        matrixStack.method_22903();
        matrixStack.method_22905(0.5f, 0.5f, 0.5f);
        itemRenderer.method_27953(this.squad.getItem(), entryLeft, (int)((float)entryTop + (float)iconHeight / 5.0f));
        matrixStack.method_22909();
        RenderSystem.disableBlend();
    }

    private void drawName(class_4587 matrixStack, int entryTop, int entryLeft, int width, int height, int iconWidth) {
        String name = this.squad.getName();
        Object trimmedName = name.trim();
        int maxNameWidth = width - iconWidth - 3;
        class_327 font = this.client.field_1772;
        if (font.method_1727((String)trimmedName) > maxNameWidth) {
            trimmedName = font.method_27523((String)trimmedName, maxNameWidth - font.method_1727("...")) + "...";
        }
        font.method_1729(matrixStack, (String)trimmedName, (float)(entryLeft + iconWidth + 3), (float)entryTop + (float)height / 2.0f - 4.5f, 0xFFFFFF);
    }

    private void drawBorder(class_4587 matrixStack, int entryTop, int entryLeft, int width, int height, boolean hovering) {
        int color = hovering ? -288060993 : -65;
        BoxRenderer.drawBox(matrixStack, entryLeft, entryTop, width, height, 0, color);
        if (this.selected) {
            BoxRenderer.drawBox(matrixStack, entryLeft, entryTop, width, height, 1, color);
        }
    }

    public class_2561 method_37006() {
        return class_2561.method_30163((String)this.squad.getName());
    }

    public boolean hasId(UUID squadId) {
        return this.squad.getSquadId().equals(squadId);
    }

    public UUID getSquadId() {
        return this.squad.getSquadId();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return true;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

