/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui.squad;

import com.google.common.collect.Lists;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.overlord.client.gui.rendertools.DrawEntity;
import dev.the_fireplace.overlord.client.gui.rendertools.OverlayButtonWidget;
import dev.the_fireplace.overlord.client.gui.squad.EditScreen;
import dev.the_fireplace.overlord.client.gui.squad.SelectorWidget;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import dev.the_fireplace.overlord.domain.rule.SquadEligibleItems;
import dev.the_fireplace.overlord.entity.OwnedSkeletonEntity;
import dev.the_fireplace.overlord.item.OrdersWandItem;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import dev.the_fireplace.overlord.network.client.builder.DeleteSquadBufferBuilder;
import dev.the_fireplace.overlord.network.client.builder.SetSquadBufferBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class SelectorScreen
extends class_437 {
    private final EmptyUUID emptyUUID = (EmptyUUID)DIContainer.get().getInstance(EmptyUUID.class);
    private final SquadEligibleItems squadEligibleItems = (SquadEligibleItems)DIContainer.get().getInstance(SquadEligibleItems.class);
    private final class_437 parent;
    private final Collection<Squad> ownedSquads;
    @Nullable
    private final Integer entityId;
    private SelectorWidget selectorWidget;
    private class_4185 editButton;
    private class_4185 deleteButton;
    private UUID selectedSquad;
    private OwnedSkeletonEntity renderedSkeleton;
    private long openTime;

    public SelectorScreen(class_2561 title, class_437 parent, Collection<? extends Squad> ownedSquads, @Nullable Integer entityId, UUID currentSquad) {
        super(title);
        this.parent = parent;
        this.entityId = entityId;
        this.ownedSquads = Lists.newArrayList(ownedSquads);
        this.selectedSquad = currentSquad;
    }

    protected void method_25426() {
        this.selectorWidget = this.createSquadSelector();
        this.method_37063((class_364)this.selectorWidget);
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 202, this.field_22790 - 30, 200, 20, (class_2561)new class_2588("gui.overlord.confirm_exit"), button -> {
            if (this.entityId != null) {
                ClientPlayNetworking.send((class_2960)ClientToServerPacketIDs.SET_SQUAD, (class_2540)SetSquadBufferBuilder.buildForEntity(this.selectedSquad, this.entityId));
            } else {
                ClientPlayNetworking.send((class_2960)ClientToServerPacketIDs.SET_SQUAD, (class_2540)SetSquadBufferBuilder.buildForWand(this.selectedSquad));
                Objects.requireNonNull(this.field_22787);
                Objects.requireNonNull(this.field_22787.field_1724);
                OrdersWandItem.getActiveWand((class_1657)this.field_22787.field_1724).method_7948().method_25927("squad", this.selectedSquad);
            }
            this.closeScreen();
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 2, this.field_22790 - 30, 200, 20, (class_2561)new class_2588("gui.cancel"), button -> this.closeScreen()));
        this.editButton = new OverlayButtonWidget(0, this.field_22790 - 54, this.field_22789 / 3, 20, class_2561.method_30163((String)""), button -> {
            Collection<class_1799> squadItems = this.getSquadItems();
            Squad currentSquad = this.ownedSquads.stream().filter(squad -> squad.getSquadId().equals(this.selectedSquad)).findFirst().orElse(null);
            this.field_22787.method_1507((class_437)new EditScreen(this, squadItems, currentSquad));
        });
        this.method_37063((class_364)this.editButton);
        this.deleteButton = new class_4185(this.field_22789 - 102, 2, 100, 20, (class_2561)new class_2588("gui.overlord.squad_manager.delete_squad"), button -> {
            ClientPlayNetworking.send((class_2960)ClientToServerPacketIDs.DELETE_SQUAD, (class_2540)DeleteSquadBufferBuilder.build(this.selectedSquad));
            Optional<Squad> selectedSquad = this.findSquadById(this.selectedSquad);
            if (selectedSquad.isPresent()) {
                this.ownedSquads.remove(selectedSquad.get());
                this.selectorWidget.removeSquad(selectedSquad.get());
            }
            this.selectorWidget.selectSquad(this.emptyUUID.get());
            this.renderedSkeleton.setSquad(this.emptyUUID.get());
        });
        this.method_37063((class_364)this.deleteButton);
        this.updateButtons();
        this.openTime = System.currentTimeMillis();
        if (this.field_22787 != null && this.field_22787.field_1687 != null && this.renderedSkeleton == null) {
            class_1297 entity;
            this.renderedSkeleton = OwnedSkeletonEntity.create((class_1937)this.field_22787.field_1687, null);
            if (this.entityId != null && (entity = this.field_22787.field_1687.method_8469(this.entityId.intValue())) instanceof OwnedSkeletonEntity) {
                this.renderedSkeleton.method_5878(entity);
            }
            this.renderedSkeleton.method_23327(0.0, 0.0, 0.0);
        }
    }

    private void updateButtons() {
        if (this.editButton != null) {
            this.editButton.method_25355((class_2561)(!this.emptyUUID.is(this.selectedSquad) ? new class_2588("gui.overlord.squad_manager.edit_squad") : new class_2588("gui.overlord.squad_manager.create_squad")));
        }
        if (this.deleteButton != null) {
            this.deleteButton.field_22763 = !this.emptyUUID.is(this.selectedSquad);
        }
    }

    private Collection<class_1799> getSquadItems() {
        Objects.requireNonNull(this.field_22787);
        class_1297 entity = this.entityId != null && this.field_22787.field_1687 != null ? this.field_22787.field_1687.method_8469(this.entityId.intValue()) : null;
        class_746 player = this.field_22787.field_1724;
        return this.squadEligibleItems.getEligibleItems(this.ownedSquads, (class_1657)player, entity);
    }

    private SelectorWidget createSquadSelector() {
        SelectorWidget selectorWidget = new SelectorWidget(this.field_22787, this.field_22789 / 3, this.field_22790 - 52, 0, this.field_22790 - 54, 30, newSquadId -> {
            this.selectedSquad = newSquadId;
            if (this.renderedSkeleton != null) {
                this.renderedSkeleton.setSquad((UUID)newSquadId);
            }
            this.updateButtons();
        });
        selectorWidget.addSquads(this.ownedSquads);
        selectorWidget.selectSquad(this.selectedSquad);
        return selectorWidget;
    }

    private void closeScreen() {
        class_310.method_1551().method_1507(this.parent);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        this.method_25420(matrixStack);
        DrawEntity.drawEntityFacingAway(this.field_22789 / 2, this.field_22790 / 2 + 50, 75, this.openTime, System.currentTimeMillis(), (class_1309)this.renderedSkeleton);
        super.method_25394(matrixStack, mouseX, mouseY, delta);
    }

    public void displaySquad(Squad squad) {
        Optional<Squad> existingSquad = this.findSquadById(squad.getSquadId());
        if (existingSquad.isPresent()) {
            this.ownedSquads.remove(existingSquad.get());
            this.selectorWidget.removeSquad(existingSquad.get());
        }
        this.ownedSquads.add(squad);
        this.selectorWidget.addSquads(Set.of(squad));
        this.selectedSquad = squad.getSquadId();
        this.selectorWidget.selectSquad(squad.getSquadId());
        if (this.renderedSkeleton != null) {
            this.renderedSkeleton.setSquad(squad.getSquadId());
        }
        this.updateButtons();
    }

    private Optional<Squad> findSquadById(UUID squadId) {
        return this.ownedSquads.stream().filter(ownedSquad -> ownedSquad.getSquadId().equals(squadId)).findFirst();
    }

    @Nullable
    public Integer getEntityId() {
        return this.entityId;
    }
}

