/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.gui.squad;

import com.google.common.collect.Lists;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.overlord.client.gui.squad.SelectorEntry;
import dev.the_fireplace.overlord.client.util.ClientSquad;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SelectorWidget
extends class_4280<SelectorEntry> {
    private final EmptyUUID emptyUUID;
    private final Squad noneSquad;
    private final SelectorEntry noneEntry;
    private final Consumer<UUID> onSquadUpdated;
    private boolean scrolling;

    public SelectorWidget(class_310 minecraftClient, int width, int height, int top, int bottom, int itemHeight, Consumer<UUID> onSquadUpdated) {
        super(minecraftClient, width, height, top, bottom, itemHeight);
        this.onSquadUpdated = onSquadUpdated;
        this.method_31322(false);
        TranslatorFactory translatorFactory = (TranslatorFactory)DIContainer.get().getInstance(TranslatorFactory.class);
        Translator translator = translatorFactory.getTranslator("overlord");
        this.emptyUUID = (EmptyUUID)DIContainer.get().getInstance(EmptyUUID.class);
        this.noneSquad = new ClientSquad(this.emptyUUID.get(), this.emptyUUID.get(), "", class_1799.field_8037, translator.getTranslatedString("gui.overlord.squad_manager.none", new Object[0]));
        this.noneEntry = new SelectorEntry(this.noneSquad);
        this.method_25321((class_350.class_351)this.noneEntry);
    }

    public void addSquads(Collection<? extends Squad> squads) {
        for (Squad squad : squads) {
            this.method_25321((class_350.class_351)new SelectorEntry(squad));
        }
    }

    public void removeSquad(Squad squad) {
        HashSet removeEntries = new HashSet();
        this.method_25396().stream().filter(selectorEntry -> selectorEntry.squad.getSquadId().equals(squad.getSquadId())).forEach(removeEntries::add);
        ArrayList childrenToKeep = Lists.newArrayList((Iterable)this.method_25396());
        childrenToKeep.removeAll(removeEntries);
        this.method_25314(childrenToKeep);
    }

    public void selectSquad(UUID squadId) {
        Optional<SelectorEntry> firstMatchingSquad = this.method_25396().stream().filter(entry -> entry.hasId(squadId)).findFirst();
        this.setSelected(firstMatchingSquad.orElse(this.noneEntry));
    }

    protected void method_25311(class_4587 matrices, int x, int y, int mouseX, int mouseY, float delta) {
        int itemCount = this.method_25340();
        for (int index = 0; index < itemCount; ++index) {
            int entryTop = this.method_25337(index) + 2;
            int entryBottom = this.method_25337(index) + this.field_22741;
            if (entryBottom < this.field_19085 || entryBottom > this.field_19086 + 20) continue;
            int entryHeight = this.field_22741 - 4;
            SelectorEntry entry = (SelectorEntry)this.method_25326(index);
            int rowWidth = this.method_25322();
            int entryLeft = this.method_25342();
            boolean hovering = this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry);
            entry.method_25343(matrices, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovering, delta);
        }
    }

    protected void method_25318(double mouseX, double mouseY, int button) {
        super.method_25318(mouseX, mouseY, button);
        this.scrolling = button == 0 && mouseX >= (double)this.method_25329() && mouseX < (double)(this.method_25329() + 6);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.method_25318(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        SelectorEntry entry = this.getEntryAtPos(mouseX, mouseY);
        if (entry != null) {
            if (entry.method_25402(mouseX, mouseY, button)) {
                this.method_25395((class_364)entry);
                this.method_25398(true);
                this.setSelected(entry);
                return true;
            }
        } else if (button == 0) {
            this.method_25310((int)(mouseX - (double)(this.field_19088 + this.field_22742 / 2 - this.method_25322() / 2)), (int)(mouseY - (double)this.field_19085) + (int)this.method_25341() - 4);
            return true;
        }
        return this.scrolling;
    }

    public final SelectorEntry getEntryAtPos(double x, double y) {
        int int_5 = class_3532.method_15357((double)(y - (double)this.field_19085)) - this.field_22748 + (int)this.method_25341() - 4;
        int index = int_5 / this.field_22741;
        return x < (double)this.method_25329() && x >= (double)this.method_25342() && x <= (double)(this.method_25342() + this.method_25322()) && index >= 0 && int_5 >= 0 && index < this.method_25340() ? (SelectorEntry)((Object)this.method_25396().get(index)) : null;
    }

    protected int method_25329() {
        return this.field_22742 - 6;
    }

    public int method_25322() {
        return this.field_22742 - (Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.field_19088 + 6;
    }

    public int getWidth() {
        return this.field_22742;
    }

    public int getTop() {
        return this.field_19085;
    }

    protected int method_25317() {
        return super.method_25317() + 4;
    }

    public void setSelected(@Nullable SelectorEntry entry) {
        super.method_25313((class_350.class_351)entry);
        boolean foundSelection = false;
        for (SelectorEntry checkEntry : this.method_25396()) {
            if (!((Object)((Object)checkEntry)).equals((Object)entry)) {
                checkEntry.setSelected(false);
                continue;
            }
            foundSelection = true;
            checkEntry.setSelected(true);
            this.onSquadUpdated.accept(checkEntry.getSquadId());
        }
        if (!foundSelection) {
            this.noneEntry.setSelected(true);
            this.onSquadUpdated.accept(this.noneEntry.getSquadId());
        }
    }
}

