/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.impl.data;

import com.google.common.collect.ImmutableSet;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.overlord.domain.data.Squads;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.inject.Singleton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

@Singleton
@Environment(value=EnvType.CLIENT)
@Implementation(name="client")
public final class ClientSquads
implements Squads {
    private static final Function<UUID, ConcurrentMap<UUID, Squad>> NEW_CONCURRENT_MAP = unused -> new ConcurrentHashMap();
    private final ConcurrentMap<UUID, ConcurrentMap<UUID, Squad>> squadCache = new ConcurrentHashMap<UUID, ConcurrentMap<UUID, Squad>>();

    @Override
    @Nullable
    public Squad getSquad(UUID owner, UUID squadId) {
        return (Squad)this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).get(squadId);
    }

    @Override
    public Squad createNewSquad(UUID owner, String pattern, class_1799 stack, String name) {
        throw new UnsupportedOperationException("Do not call this from the client!");
    }

    @Override
    public boolean removeSquad(UUID owner, UUID squadId) {
        throw new UnsupportedOperationException("Do not call this from the client!");
    }

    @Override
    public Collection<? extends Squad> getSquadsWithOwner(UUID owner) {
        return ImmutableSet.copyOf(this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).values());
    }

    @Override
    public Collection<? extends Squad> getSquads() {
        ArrayList squads = new ArrayList();
        this.squadCache.values().forEach(entry -> squads.addAll(entry.values()));
        return squads;
    }

    public void setSquads(Collection<? extends Squad> squads) {
        this.squadCache.clear();
        for (Squad squad : squads) {
            this.squadCache.computeIfAbsent(squad.getOwner(), NEW_CONCURRENT_MAP).put(squad.getSquadId(), squad);
        }
    }

    public void setSquadsFromOwner(UUID owner, Collection<? extends Squad> squads) {
        this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).clear();
        for (Squad squad : squads) {
            this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).put(squad.getSquadId(), squad);
        }
    }
}

