/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.client.renderer;

import com.mojang.authlib.GameProfile;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.overlord.client.model.OverlordModelLayers;
import dev.the_fireplace.overlord.client.model.OwnedSkeletonModel;
import dev.the_fireplace.overlord.client.renderer.feature.AugmentHeadFeatureRenderer;
import dev.the_fireplace.overlord.client.renderer.feature.SquadCapeFeatureRenderer;
import dev.the_fireplace.overlord.entity.OwnedSkeletonEntity;
import dev.the_fireplace.overlord.entity.SkeletonGrowthPhase;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1934;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4506;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_909;
import net.minecraft.class_922;
import net.minecraft.class_970;
import net.minecraft.class_973;

@Environment(value=EnvType.CLIENT)
public class OwnedSkeletonRenderer
extends class_909<OwnedSkeletonEntity, OwnedSkeletonModel> {
    private final EmptyUUID emptyUUID = (EmptyUUID)DIContainer.get().getInstance(EmptyUUID.class);
    private final Map<UUID, class_640> skinCache;
    private final OwnedSkeletonModel thinSkinMuscleModel;
    private final OwnedSkeletonModel muscleModel;
    private final OwnedSkeletonModel thinSkinModel;
    private final OwnedSkeletonModel standardModel;
    private final class_970<OwnedSkeletonEntity, OwnedSkeletonModel, class_572<OwnedSkeletonEntity>> standardArmorRenderer;
    private final class_970<OwnedSkeletonEntity, OwnedSkeletonModel, class_572<OwnedSkeletonEntity>> muscleArmorRenderer;
    private class_970<OwnedSkeletonEntity, OwnedSkeletonModel, class_572<OwnedSkeletonEntity>> currentArmorRenderer;
    private class_970<OwnedSkeletonEntity, OwnedSkeletonModel, class_572<OwnedSkeletonEntity>> previousArmorRenderer;

    public OwnedSkeletonRenderer(class_5617.class_5618 context) {
        super(context, (class_572)new OwnedSkeletonModel(context.method_32167(OverlordModelLayers.OWNED_SKELETON_MODEL)), 0.5f);
        this.standardModel = new OwnedSkeletonModel(context.method_32167(OverlordModelLayers.OWNED_SKELETON_MODEL));
        this.muscleModel = new OwnedSkeletonModel(context.method_32167(OverlordModelLayers.MUSCLE_OWNED_SKELETON_MODEL));
        this.thinSkinModel = new OwnedSkeletonModel(context.method_32167(OverlordModelLayers.SLIM_OWNED_SKELETON_MODEL));
        this.thinSkinMuscleModel = new OwnedSkeletonModel(context.method_32167(OverlordModelLayers.SLIM_MUSCLE_OWNED_SKELETON_MODEL));
        class_572 bodyModel = new class_572(context.method_32167(class_5602.field_27579));
        OwnedSkeletonModel standardLeggingsModel = new OwnedSkeletonModel(context.method_32167(OverlordModelLayers.OWNED_SKELETON_LEGGINGS_MODEL));
        this.standardArmorRenderer = new class_970((class_3883)this, (class_572)standardLeggingsModel, bodyModel);
        OwnedSkeletonModel muscleLeggingsModel = new OwnedSkeletonModel(context.method_32167(OverlordModelLayers.MUSCLE_OWNED_SKELETON_LEGGINGS_MODEL));
        this.muscleArmorRenderer = new class_970((class_3883)this, (class_572)muscleLeggingsModel, bodyModel);
        this.method_4046((class_3887)this.standardArmorRenderer);
        this.method_4046(new AugmentHeadFeatureRenderer(this, context.method_32170()));
        this.method_4046(new SquadCapeFeatureRenderer(this));
        this.method_4046((class_3887)new class_973(context, (class_922)this));
        this.method_4046((class_3887)new class_4506((class_922)this));
        this.skinCache = new HashMap<UUID, class_640>();
        this.currentArmorRenderer = this.standardArmorRenderer;
        this.previousArmorRenderer = this.standardArmorRenderer;
    }

    public class_2960 getTexture(OwnedSkeletonEntity entity) {
        this.field_4673 = 0.25f * (float)entity.getGrowthPhase().ordinal() / 4.0f + 0.25f;
        if (!entity.hasSkin() && !entity.hasMuscles()) {
            return new class_2960("overlord", "textures/entity/owned_skeleton/owned_skeleton.png");
        }
        UUID skinsuit = entity.getSkinsuit();
        if (entity.getGrowthPhase() == SkeletonGrowthPhase.ADULT && entity.hasSkin() && !this.emptyUUID.is(skinsuit)) {
            this.cacheSkinsuitTexture(entity);
            if (this.skinCache.containsKey(skinsuit)) {
                return this.skinCache.get(skinsuit).method_2968();
            }
        }
        if (entity.hasSkin() && !entity.hasMuscles()) {
            return new class_2960("overlord", String.format("textures/entity/owned_skeleton/owned_skeleton_skin_%s.png", entity.getGrowthPhase().ordinal()));
        }
        if (!entity.hasSkin() && entity.hasMuscles()) {
            return new class_2960("overlord", String.format("textures/entity/owned_skeleton/owned_skeleton_muscles_%s.png", entity.getGrowthPhase().ordinal()));
        }
        return new class_2960("overlord", String.format("textures/entity/owned_skeleton/owned_skeleton_skin_muscles_%s.png", entity.getGrowthPhase().ordinal()));
    }

    private void cacheSkinsuitTexture(OwnedSkeletonEntity entity) {
        UUID skinsuit = entity.getSkinsuit();
        if (!this.skinCache.containsKey(skinsuit)) {
            class_634 networkHandler = class_310.method_1551().method_1562();
            if (networkHandler == null) {
                return;
            }
            GameProfile gameProfile = new GameProfile(skinsuit, null);
            this.skinCache.put(skinsuit, new class_640(new class_2703.class_2705(gameProfile, 0, class_1934.field_9215, null)));
        }
    }

    protected void scale(OwnedSkeletonEntity entity, class_4587 matrices, float tickDelta) {
        float shrinkMultiplier = (float)(entity.getGrowthPhase().ordinal() + 1) * 0.1f + 0.5f;
        matrices.method_22905(shrinkMultiplier, shrinkMultiplier, shrinkMultiplier);
    }

    public void render(OwnedSkeletonEntity livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        this.setModel(livingEntity);
        this.setModelPose(livingEntity);
        class_1799 augment = livingEntity.getAugmentBlockStack();
        ((OwnedSkeletonModel)this.method_4038()).field_3398.field_3665 = augment.method_7960();
        super.method_4072((class_1308)livingEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    private void setModel(OwnedSkeletonEntity entity) {
        boolean hasThickLimbs;
        boolean hasThinArmTexture = this.skinCache.containsKey(entity.getSkinsuit()) && this.skinCache.get(entity.getSkinsuit()).method_2977().equals("slim");
        boolean bl = hasThickLimbs = entity.getGrowthPhase() == SkeletonGrowthPhase.ADULT && entity.hasMuscles();
        if (hasThinArmTexture && hasThickLimbs) {
            this.field_4737 = this.thinSkinMuscleModel;
            this.currentArmorRenderer = this.muscleArmorRenderer;
        } else if (hasThinArmTexture) {
            this.field_4737 = this.thinSkinModel;
            this.currentArmorRenderer = this.standardArmorRenderer;
        } else if (hasThickLimbs) {
            this.field_4737 = this.muscleModel;
            this.currentArmorRenderer = this.muscleArmorRenderer;
        } else {
            this.field_4737 = this.standardModel;
            this.currentArmorRenderer = this.standardArmorRenderer;
        }
        if (this.previousArmorRenderer != this.currentArmorRenderer) {
            this.field_4738.remove(this.previousArmorRenderer);
            this.method_4046((class_3887)this.currentArmorRenderer);
            this.previousArmorRenderer = this.currentArmorRenderer;
        }
    }

    private void setModelPose(OwnedSkeletonEntity entity) {
        OwnedSkeletonModel skeletonEntityModel = (OwnedSkeletonModel)this.method_4038();
        class_1799 mainStack = entity.method_6047();
        class_1799 offStack = entity.method_6079();
        skeletonEntityModel.method_2805(true);
        class_572.class_573 armPose = this.getArmPose(entity, mainStack, offStack, class_1268.field_5808);
        class_572.class_573 armPose2 = this.getArmPose(entity, mainStack, offStack, class_1268.field_5810);
        if (entity.method_6068() == class_1306.field_6183) {
            skeletonEntityModel.field_3395 = armPose;
            skeletonEntityModel.field_3399 = armPose2;
        } else {
            skeletonEntityModel.field_3395 = armPose2;
            skeletonEntityModel.field_3399 = armPose;
        }
    }

    private class_572.class_573 getArmPose(OwnedSkeletonEntity entity, class_1799 mainHandStack, class_1799 offHandStack, class_1268 hand) {
        class_1799 handStack;
        class_572.class_573 armPose = class_572.class_573.field_3409;
        class_1799 class_17992 = handStack = hand == class_1268.field_5808 ? mainHandStack : offHandStack;
        if (!handStack.method_7960()) {
            armPose = class_572.class_573.field_3410;
            if (entity.method_6014() > 0) {
                class_1839 useAction = handStack.method_7976();
                if (useAction == class_1839.field_8949) {
                    armPose = class_572.class_573.field_3406;
                } else if (useAction == class_1839.field_8953) {
                    armPose = class_572.class_573.field_3403;
                } else if (useAction == class_1839.field_8951) {
                    armPose = class_572.class_573.field_3407;
                } else if (useAction == class_1839.field_8947 && hand == entity.method_6058()) {
                    armPose = class_572.class_573.field_3405;
                }
            } else {
                boolean mainHandCrossbow = mainHandStack.method_7909() == class_1802.field_8399;
                boolean isMainCrossbowCharged = class_1764.method_7781((class_1799)mainHandStack);
                boolean offHandCrossbow = offHandStack.method_7909() == class_1802.field_8399;
                boolean isOffHandCrossbowCharged = class_1764.method_7781((class_1799)offHandStack);
                if (mainHandCrossbow && isMainCrossbowCharged) {
                    armPose = class_572.class_573.field_3408;
                }
                if (offHandCrossbow && isOffHandCrossbowCharged && mainHandStack.method_7909().method_7853(mainHandStack) == class_1839.field_8952) {
                    armPose = class_572.class_573.field_3408;
                }
            }
        }
        return armPose;
    }
}

