/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.config;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageWriteBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.overlord.domain.config.ConfigValues;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Implementation(value={"dev.the_fireplace.overlord.domain.config.ConfigValues"})
public final class OverlordConfig
implements Config,
ConfigValues {
    private final ConfigValues defaultConfig;
    private int quarterMilkCount;
    private int halfMilkCount;
    private int threeQuartersMilkCount;
    private int fullyGrownMilkCount;
    private int localOrdersDistance;

    @Inject
    public OverlordConfig(ConfigStateManager configStateManager, @Named(value="default") ConfigValues defaultConfig) {
        this.defaultConfig = defaultConfig;
        configStateManager.initialize((Config)this);
    }

    public String getId() {
        return "overlord";
    }

    public void readFrom(StorageReadBuffer buffer) {
        this.quarterMilkCount = buffer.readInt("quarterMilkCount", this.defaultConfig.getQuarterGrownMilkCount());
        this.halfMilkCount = buffer.readInt("halfMilkCount", this.defaultConfig.getHalfGrownMilkCount());
        this.threeQuartersMilkCount = buffer.readInt("threeQuartersMilkCount", this.defaultConfig.getThreeQuartersGrownMilkCount());
        this.fullyGrownMilkCount = buffer.readInt("fullyGrownMilkCount", this.defaultConfig.getFullyGrownMilkCount());
        this.localOrdersDistance = buffer.readInt("localOrdersDistance", this.defaultConfig.getLocalOrdersDistance());
    }

    public void writeTo(StorageWriteBuffer buffer) {
        buffer.writeInt("quarterMilkCount", this.quarterMilkCount);
        buffer.writeInt("halfMilkCount", this.halfMilkCount);
        buffer.writeInt("threeQuartersMilkCount", this.threeQuartersMilkCount);
        buffer.writeInt("fullyGrownMilkCount", this.fullyGrownMilkCount);
        buffer.writeInt("localOrdersDistance", this.localOrdersDistance);
    }

    @Override
    public int getQuarterGrownMilkCount() {
        return this.quarterMilkCount;
    }

    public void setQuarterMilkCount(int quarterMilkCount) {
        this.quarterMilkCount = quarterMilkCount;
    }

    @Override
    public int getHalfGrownMilkCount() {
        return this.halfMilkCount;
    }

    public void setHalfMilkCount(int halfMilkCount) {
        this.halfMilkCount = halfMilkCount;
    }

    @Override
    public int getThreeQuartersGrownMilkCount() {
        return this.threeQuartersMilkCount;
    }

    public void setThreeQuartersMilkCount(int threeQuartersMilkCount) {
        this.threeQuartersMilkCount = threeQuartersMilkCount;
    }

    @Override
    public int getFullyGrownMilkCount() {
        return this.fullyGrownMilkCount;
    }

    public void setFullyGrownMilkCount(int fullyGrownMilkCount) {
        this.fullyGrownMilkCount = fullyGrownMilkCount;
    }

    @Override
    public int getLocalOrdersDistance() {
        return this.localOrdersDistance;
    }

    public void setLocalOrdersDistance(int localOrdersDistance) {
        this.localOrdersDistance = localOrdersDistance;
    }
}

