/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.config;

import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.injectables.ConfigScreenBuilderFactory;
import dev.the_fireplace.lib.api.client.interfaces.ConfigScreenBuilder;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.overlord.config.OverlordConfig;
import dev.the_fireplace.overlord.domain.config.ConfigValues;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_437;

@Singleton
@Environment(value=EnvType.CLIENT)
public final class OverlordConfigScreenFactory {
    private static final String TRANSLATION_BASE = "text.config.overlord.";
    private static final String OPTION_TRANSLATION_BASE = "text.config.overlord.option.";
    private final Translator translator;
    private final ConfigStateManager configStateManager;
    private final OverlordConfig config;
    private final ConfigValues defaultConfigValues;
    private final ConfigScreenBuilderFactory configScreenBuilderFactory;
    private ConfigScreenBuilder configScreenBuilder;

    @Inject
    public OverlordConfigScreenFactory(TranslatorFactory translatorFactory, ConfigStateManager configStateManager, OverlordConfig config, @Named(value="default") ConfigValues defaultConfigValues, ConfigScreenBuilderFactory configScreenBuilderFactory) {
        this.translator = translatorFactory.getTranslator("overlord");
        this.configStateManager = configStateManager;
        this.config = config;
        this.defaultConfigValues = defaultConfigValues;
        this.configScreenBuilderFactory = configScreenBuilderFactory;
    }

    public class_437 getConfigScreen(class_437 parent) {
        this.configScreenBuilder = this.configScreenBuilderFactory.create(this.translator, "text.config.overlord.title", "text.config.overlord.global", parent, () -> this.configStateManager.save((Config)this.config));
        this.addGlobalCategoryEntries();
        return this.configScreenBuilder.build();
    }

    private void addGlobalCategoryEntries() {
        this.configScreenBuilder.startSubCategory("text.config.overlord.milkAmounts", new Object[0]);
        this.configScreenBuilder.addIntField("text.config.overlord.option.quarterGrownMilkCount", this.config.getQuarterGrownMilkCount(), this.defaultConfigValues.getQuarterGrownMilkCount(), this.config::setQuarterMilkCount).setMinimum((Object)1).setDescriptionRowCount((byte)0);
        this.configScreenBuilder.addIntField("text.config.overlord.option.halfGrownMilkCount", this.config.getHalfGrownMilkCount(), this.defaultConfigValues.getHalfGrownMilkCount(), this.config::setHalfMilkCount).setMinimum((Object)1).setDescriptionRowCount((byte)0);
        this.configScreenBuilder.addIntField("text.config.overlord.option.threeQuartersGrownMilkCount", this.config.getThreeQuartersGrownMilkCount(), this.defaultConfigValues.getThreeQuartersGrownMilkCount(), this.config::setThreeQuartersMilkCount).setMinimum((Object)1).setDescriptionRowCount((byte)0);
        this.configScreenBuilder.addIntField("text.config.overlord.option.fullyGrownMilkCount", this.config.getFullyGrownMilkCount(), this.defaultConfigValues.getFullyGrownMilkCount(), this.config::setFullyGrownMilkCount).setMinimum((Object)1).setDescriptionRowCount((byte)0);
        this.configScreenBuilder.endSubCategory();
        this.configScreenBuilder.addIntField("text.config.overlord.option.localOrdersDistance", this.config.getLocalOrdersDistance(), this.defaultConfigValues.getLocalOrdersDistance(), this.config::setLocalOrdersDistance).setMinimum((Object)1);
    }
}

