/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.datagen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.block.OverlordBlocks;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_192;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_212;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class BlockLootTableGenerator
implements Consumer<BiConsumer<class_2960, class_52.class_53>> {
    private static final Set<class_1792> EXPLOSION_IMMUNE = (Set)Stream.of(class_2246.field_10081, class_2246.field_10327, class_2246.field_10502, class_2246.field_10481, class_2246.field_10177, class_2246.field_10432, class_2246.field_10241, class_2246.field_10042, class_2246.field_10337, class_2246.field_10603, class_2246.field_10371, class_2246.field_10605, class_2246.field_10373, class_2246.field_10532, class_2246.field_10140, class_2246.field_10055, class_2246.field_10203, class_2246.field_10320, class_2246.field_10275, class_2246.field_10063, class_2246.field_10407, class_2246.field_10051, class_2246.field_10268, class_2246.field_10068, class_2246.field_10199, class_2246.field_10600).map(class_1935::method_8389).collect(ImmutableSet.toImmutableSet());
    private final Map<class_2960, class_52.class_53> lootTables = Maps.newHashMap();

    @Override
    public void accept(BiConsumer<class_2960, class_52.class_53> identifierBuilderBiConsumer) {
        this.registerForSelfDrop(OverlordBlocks.BLOOD_SOAKED_SOIL);
        this.registerForSelfDrop(OverlordBlocks.OAK_GRAVE_MARKER);
        this.registerForSelfDrop(OverlordBlocks.BIRCH_GRAVE_MARKER);
        this.registerForSelfDrop(OverlordBlocks.JUNGLE_GRAVE_MARKER);
        this.registerForSelfDrop(OverlordBlocks.SPRUCE_GRAVE_MARKER);
        this.registerForSelfDrop(OverlordBlocks.ACACIA_GRAVE_MARKER);
        this.registerForSelfDrop(OverlordBlocks.DARK_OAK_GRAVE_MARKER);
        this.registerForSelfDrop(OverlordBlocks.WARPED_GRAVE_MARKER);
        this.registerForSelfDrop(OverlordBlocks.CRIMSON_GRAVE_MARKER);
        this.registerMultiblock(OverlordBlocks.OAK_CASKET, (class_2769)class_2741.field_12483, (Comparable<T> & class_3542)class_2742.field_12560);
        this.registerMultiblock(OverlordBlocks.BIRCH_CASKET, (class_2769)class_2741.field_12483, (Comparable<T> & class_3542)class_2742.field_12560);
        this.registerMultiblock(OverlordBlocks.JUNGLE_CASKET, (class_2769)class_2741.field_12483, (Comparable<T> & class_3542)class_2742.field_12560);
        this.registerMultiblock(OverlordBlocks.SPRUCE_CASKET, (class_2769)class_2741.field_12483, (Comparable<T> & class_3542)class_2742.field_12560);
        this.registerMultiblock(OverlordBlocks.ACACIA_CASKET, (class_2769)class_2741.field_12483, (Comparable<T> & class_3542)class_2742.field_12560);
        this.registerMultiblock(OverlordBlocks.DARK_OAK_CASKET, (class_2769)class_2741.field_12483, (Comparable<T> & class_3542)class_2742.field_12560);
        this.registerMultiblock(OverlordBlocks.WARPED_CASKET, (class_2769)class_2741.field_12483, (Comparable<T> & class_3542)class_2742.field_12560);
        this.registerMultiblock(OverlordBlocks.CRIMSON_CASKET, (class_2769)class_2741.field_12483, (Comparable<T> & class_3542)class_2742.field_12560);
        this.registerForSelfDrop(OverlordBlocks.STONE_TOMBSTONE);
        this.registerForSelfDrop(OverlordBlocks.DIORITE_TOMBSTONE);
        this.registerForSelfDrop(OverlordBlocks.ANDESITE_TOMBSTONE);
        this.registerForSelfDrop(OverlordBlocks.GRANITE_TOMBSTONE);
        this.registerForSelfDrop(OverlordBlocks.BLACKSTONE_TOMBSTONE);
        this.registerForSelfDrop(OverlordBlocks.DEEPSLATE_TOMBSTONE);
        HashSet set = Sets.newHashSet();
        for (class_2248 block : OverlordBlocks.getRegisteredBlocks()) {
            class_2960 identifier = block.method_26162();
            if (identifier == class_39.field_844 || !set.add(identifier)) continue;
            class_52.class_53 builder5 = this.lootTables.remove(identifier);
            if (builder5 == null) {
                Overlord.getLogger().error(String.format("Missing loottable '%s' for '%s'", identifier, class_2378.field_11146.method_10221((Object)block)));
                continue;
            }
            identifierBuilderBiConsumer.accept(identifier, builder5);
        }
        if (!this.lootTables.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + this.lootTables.keySet());
        }
    }

    private static <T> T addSurvivesExplosionCondition(class_1935 drop, class_192<T> builder) {
        return (T)(!EXPLOSION_IMMUNE.contains(drop.method_8389()) ? builder.method_840(class_201.method_871()) : builder.method_512());
    }

    private static class_52.class_53 drops(class_1935 drop) {
        return class_52.method_324().method_336((class_55.class_56)BlockLootTableGenerator.addSurvivesExplosionCondition(drop, class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)drop))));
    }

    private static <T extends Comparable<T> & class_3542> class_52.class_53 dropsWithProperty(class_2248 drop, class_2769<T> property, T comparable) {
        return class_52.method_324().method_336((class_55.class_56)BlockLootTableGenerator.addSurvivesExplosionCondition((class_1935)drop, class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351(class_77.method_411((class_1935)drop).method_421((class_5341.class_210)class_212.method_900((class_2248)drop).method_22584(class_4559.class_4560.method_22523().method_22525(property, comparable))))));
    }

    public void register(class_2248 block, class_1935 loot) {
        this.register(block, BlockLootTableGenerator.drops(loot));
    }

    public void registerForSelfDrop(class_2248 block) {
        this.register(block, (class_1935)block);
    }

    public <T extends Comparable<T> & class_3542> void registerMultiblock(class_2248 block, class_2769<T> property, T comparable) {
        this.registerWithFunction(block, registerBlock -> BlockLootTableGenerator.dropsWithProperty(registerBlock, property, comparable));
    }

    private void registerWithFunction(class_2248 block, Function<class_2248, class_52.class_53> function) {
        this.register(block, function.apply(block));
    }

    private void register(class_2248 block, class_52.class_53 builder) {
        this.lootTables.put(block.method_26162(), builder);
    }
}

