/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.datagen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.datagen.BlockLootTableGenerator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_58;
import net.minecraft.class_60;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTablesProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger((String)"Overlord Loot Tables Generator");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final class_2403 root;
    private final List<Pair<Supplier<Consumer<BiConsumer<class_2960, class_52.class_53>>>, class_176>> lootTypeGenerators = ImmutableList.of((Object)Pair.of(BlockLootTableGenerator::new, (Object)class_173.field_1172));

    public LootTablesProvider(class_2403 dataGenerator) {
        this.root = dataGenerator;
    }

    public void method_10319(class_2408 dataCache) {
        Path path = this.root.method_10313();
        HashMap map = Maps.newHashMap();
        this.lootTypeGenerators.forEach(pair -> ((Consumer)((Supplier)pair.getFirst()).get()).accept((identifier, builder) -> {
            if (map.put(identifier, builder.method_334((class_176)pair.getSecond()).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + identifier);
            }
        }));
        class_176 lootContext = class_173.field_1177;
        Function<class_2960, class_5341> nullFunc = identifierx -> null;
        class_58 lootTableReporter = new class_58(lootContext, nullFunc, map::get);
        map.forEach((identifierx, lootTable) -> class_60.method_369((class_58)lootTableReporter, (class_2960)identifierx, (class_52)lootTable));
        Multimap multimap = lootTableReporter.method_361();
        if (!multimap.isEmpty()) {
            multimap.forEach((string, string2) -> LOGGER.warn("Found validation problem in " + string + ": " + string2));
            Overlord.getLogger().error("Failed to validate loot tables, see logs");
        } else {
            map.forEach((identifierx, lootTable) -> {
                Path path2 = LootTablesProvider.getOutput(path, identifierx);
                try {
                    class_2405.method_10320((Gson)GSON, (class_2408)dataCache, (JsonElement)class_60.method_372((class_52)lootTable), (Path)path2);
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't save loot table {}", (Object)path2, (Object)e);
                }
            });
        }
    }

    private static Path getOutput(Path rootOutput, class_2960 lootTableId) {
        return rootOutput.resolve("data/" + lootTableId.method_12836() + "/loot_tables/" + lootTableId.method_12832() + ".json");
    }

    public String method_10321() {
        return "Overlord LootTables";
    }
}

