/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.the_fireplace.overlord.block.OverlordBlocks;
import dev.the_fireplace.overlord.item.OverlordItems;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2246;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_3981;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipesProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger((String)"Overlord Recipe Generator");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 root;
    private final class_1856 bedIngredient = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8112, class_1802.field_8789, class_1802.field_8893, class_1802.field_8368, class_1802.field_8863, class_1802.field_8417, class_1802.field_8390, class_1802.field_8464, class_1802.field_8754, class_1802.field_8286, class_1802.field_8146, class_1802.field_8679, class_1802.field_8349, class_1802.field_8059, class_1802.field_8262, class_1802.field_8258});

    public RecipesProvider(class_2403 dataGenerator) {
        this.root = dataGenerator;
    }

    private void generate(Consumer<class_2444> consumer) {
        class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_10360}), (class_1935)OverlordBlocks.STONE_TOMBSTONE).method_17970("has_smooth_stone", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10360)).method_36443(consumer, "overlord:stone_tombstone_from_stonecutting");
        class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_10093}), (class_1935)OverlordBlocks.ANDESITE_TOMBSTONE).method_17970("has_polished_andesite", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10093)).method_36443(consumer, "overlord:andesite_tombstone_from_stonecutting");
        class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_10346}), (class_1935)OverlordBlocks.DIORITE_TOMBSTONE).method_17970("has_polished_diorite", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10346)).method_36443(consumer, "overlord:diorite_tombstone_from_stonecutting");
        class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_10289}), (class_1935)OverlordBlocks.GRANITE_TOMBSTONE).method_17970("has_polished_granite", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10289)).method_36443(consumer, "overlord:granite_tombstone_from_stonecutting");
        class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_23873}), (class_1935)OverlordBlocks.BLACKSTONE_TOMBSTONE).method_17970("has_polished_blackstone", (class_184)this.conditionsFromItem((class_1935)class_2246.field_23873)).method_36443(consumer, "overlord:blackstone_tombstone_from_stonecutting");
        class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_2246.field_28892}), (class_1935)OverlordBlocks.DEEPSLATE_TOMBSTONE).method_17970("has_polished_deepslate", (class_184)this.conditionsFromItem((class_1935)class_2246.field_28892)).method_36443(consumer, "overlord:deepslate_tombstone_from_stonecutting");
        class_2447.method_10436((class_1935)OverlordBlocks.ACACIA_CASKET, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8284).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8651).method_10428(Character.valueOf('B'), this.bedIngredient).method_10439("###").method_10439("%B%").method_10439("###").method_10435("wooden_casket").method_10429("has_stripped_wood", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10103)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.BIRCH_CASKET, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8472).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8191).method_10428(Character.valueOf('B'), this.bedIngredient).method_10439("###").method_10439("%B%").method_10439("###").method_10435("wooden_casket").method_10429("has_stripped_wood", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10204)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.SPRUCE_CASKET, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8362).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8113).method_10428(Character.valueOf('B'), this.bedIngredient).method_10439("###").method_10439("%B%").method_10439("###").method_10435("wooden_casket").method_10429("has_stripped_wood", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10558)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.JUNGLE_CASKET, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8785).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8842).method_10428(Character.valueOf('B'), this.bedIngredient).method_10439("###").method_10439("%B%").method_10439("###").method_10435("wooden_casket").method_10429("has_stripped_wood", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10084)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.OAK_CASKET, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8248).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8118).method_10428(Character.valueOf('B'), this.bedIngredient).method_10439("###").method_10439("%B%").method_10439("###").method_10435("wooden_casket").method_10429("has_stripped_wood", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10250)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.DARK_OAK_CASKET, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8219).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8404).method_10428(Character.valueOf('B'), this.bedIngredient).method_10439("###").method_10439("%B%").method_10439("###").method_10435("wooden_casket").method_10429("has_stripped_wood", (class_184)this.conditionsFromItem((class_1935)class_2246.field_10374)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.CRIMSON_CASKET, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_22487).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_22031).method_10428(Character.valueOf('B'), this.bedIngredient).method_10439("###").method_10439("%B%").method_10439("###").method_10435("wooden_casket").method_10429("has_stripped_wood", (class_184)this.conditionsFromItem((class_1935)class_2246.field_22506)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.WARPED_CASKET, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_22488).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_22032).method_10428(Character.valueOf('B'), this.bedIngredient).method_10439("###").method_10439("%B%").method_10439("###").method_10435("wooden_casket").method_10429("has_stripped_wood", (class_184)this.conditionsFromItem((class_1935)class_2246.field_22504)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.ACACIA_GRAVE_MARKER, (int)2).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8646).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8400).method_10439("%%%").method_10439(" # ").method_10439(" # ").method_10435("grave_marker").method_10429("has_fence", (class_184)this.conditionsFromItem((class_1935)class_1802.field_8646)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.BIRCH_GRAVE_MARKER, (int)2).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8457).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8843).method_10439("%%%").method_10439(" # ").method_10439(" # ").method_10435("grave_marker").method_10429("has_fence", (class_184)this.conditionsFromItem((class_1935)class_1802.field_8457)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.SPRUCE_GRAVE_MARKER, (int)2).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8701).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8189).method_10439("%%%").method_10439(" # ").method_10439(" # ").method_10435("grave_marker").method_10429("has_fence", (class_184)this.conditionsFromItem((class_1935)class_1802.field_8701)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.JUNGLE_GRAVE_MARKER, (int)2).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8823).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8224).method_10439("%%%").method_10439(" # ").method_10439(" # ").method_10435("grave_marker").method_10429("has_fence", (class_184)this.conditionsFromItem((class_1935)class_1802.field_8823)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.OAK_GRAVE_MARKER, (int)2).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8792).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8320).method_10439("%%%").method_10439(" # ").method_10439(" # ").method_10435("grave_marker").method_10429("has_fence", (class_184)this.conditionsFromItem((class_1935)class_1802.field_8792)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.DARK_OAK_GRAVE_MARKER, (int)2).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8454).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_8540).method_10439("%%%").method_10439(" # ").method_10439(" # ").method_10435("grave_marker").method_10429("has_fence", (class_184)this.conditionsFromItem((class_1935)class_1802.field_8454)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.CRIMSON_GRAVE_MARKER, (int)2).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_21995).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_21985).method_10439("%%%").method_10439(" # ").method_10439(" # ").method_10435("grave_marker").method_10429("has_fence", (class_184)this.conditionsFromItem((class_1935)class_1802.field_21995)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordBlocks.WARPED_GRAVE_MARKER, (int)2).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_21996).method_10434(Character.valueOf('%'), (class_1935)class_1802.field_21986).method_10439("%%%").method_10439(" # ").method_10439(" # ").method_10435("grave_marker").method_10429("has_fence", (class_184)this.conditionsFromItem((class_1935)class_1802.field_21996)).method_10431(consumer);
        class_2447.method_10436((class_1935)OverlordItems.ORDERS_WAND, (int)1).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_27063).method_10434(Character.valueOf('/'), (class_1935)class_1802.field_8600).method_10439("  #").method_10439(" / ").method_10439("/  ").method_10429("has_amethyst_shard", (class_184)this.conditionsFromItem((class_1935)class_1802.field_27063)).method_10431(consumer);
    }

    public String method_10321() {
        return "Overlord Recipes";
    }

    public void method_10319(class_2408 dataCache) {
        Path path = this.root.method_10313();
        HashSet set = Sets.newHashSet();
        this.generate(recipeJsonProvider -> {
            if (!set.add(recipeJsonProvider.method_10417())) {
                throw new IllegalStateException("Duplicate recipe " + recipeJsonProvider.method_10417());
            }
            this.saveRecipe(dataCache, recipeJsonProvider.method_17799(), path.resolve("data/" + recipeJsonProvider.method_10417().method_12836() + "/recipes/" + recipeJsonProvider.method_10417().method_12832() + ".json"));
            JsonObject jsonObject = recipeJsonProvider.method_10415();
            if (jsonObject != null) {
                this.saveRecipeAdvancement(dataCache, jsonObject, path.resolve("data/" + recipeJsonProvider.method_10417().method_12836() + "/advancements/" + recipeJsonProvider.method_10418().method_12832() + ".json"));
            }
        });
    }

    private void saveRecipe(class_2408 dataCache, JsonObject jsonObject, Path path) {
        try {
            this.save(dataCache, jsonObject, path);
        }
        catch (IOException var19) {
            LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)var19);
        }
    }

    private void saveRecipeAdvancement(class_2408 dataCache, JsonObject jsonObject, Path path) {
        try {
            this.save(dataCache, jsonObject, path);
        }
        catch (IOException var19) {
            LOGGER.error("Couldn't save recipe advancement {}", (Object)path, (Object)var19);
        }
    }

    private void save(class_2408 dataCache, JsonObject jsonObject, Path path) throws IOException {
        String string = GSON.toJson((JsonElement)jsonObject);
        String string2 = field_11280.hashUnencodedChars((CharSequence)string).toString();
        if (!Objects.equals(dataCache.method_10323(path), string2) || !Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedWriter.write(string);
            }
        }
        dataCache.method_10325(path, string2);
    }

    private class_2066.class_2068 conditionsFromItem(class_1935 itemConvertible) {
        return this.conditionsFromItemPredicates(class_2073.class_2074.method_8973().method_8977(new class_1935[]{itemConvertible}).method_8976());
    }

    private class_2066.class_2068 conditionsFromItemPredicates(class_2073 ... items) {
        return new class_2066.class_2068(class_2048.class_5258.field_24388, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, items);
    }
}

