/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.datapack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.the_fireplace.lib.api.io.injectables.JsonFileReader;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.domain.entity.creation.SkeletonIngredient;
import dev.the_fireplace.overlord.entity.creation.SkeletonBuilderImpl;
import dev.the_fireplace.overlord.entity.creation.SkeletonComponent;
import dev.the_fireplace.overlord.entity.creation.SkeletonRecipe;
import dev.the_fireplace.overlord.entity.creation.ingredient.JsonIngredient;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Inject;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public final class SkeletonBuildingPackLoader
implements SimpleSynchronousResourceReloadListener {
    private final SkeletonBuilderImpl skeletonBuilder;
    private final JsonFileReader jsonFileReader;

    @Inject
    public SkeletonBuildingPackLoader(SkeletonBuilderImpl skeletonBuilder, JsonFileReader jsonFileReader) {
        this.skeletonBuilder = skeletonBuilder;
        this.jsonFileReader = jsonFileReader;
    }

    public class_2960 getFabricId() {
        return new class_2960("overlord", "skeleton_building");
    }

    public void method_14491(class_3300 manager) {
        HashMap<String, JsonObject> recipeJsons = new HashMap<String, JsonObject>();
        String lastStandardRecipeDomain = "";
        for (class_2960 id : manager.method_14488("skeleton_recipes", path -> path.endsWith(".json"))) {
            int newPriority;
            JsonObject jsonObject = null;
            try (InputStream stream = manager.method_14486(id).method_14482();){
                jsonObject = this.jsonFileReader.readJsonFromStream(stream);
            }
            catch (Exception e) {
                Overlord.getLogger().error("Error occurred while loading resource json " + id.toString(), (Throwable)e);
            }
            if (jsonObject == null) continue;
            String resourceDomain = id.method_12836();
            String resourcePath = id.method_12832();
            boolean isStandardRecipe = resourcePath.equals("skeleton_recipes/standard.json");
            if (!recipeJsons.containsKey(resourcePath)) {
                recipeJsons.put(resourcePath, jsonObject);
                if (!isStandardRecipe) continue;
                lastStandardRecipeDomain = resourceDomain;
                continue;
            }
            JsonObject existing = (JsonObject)recipeJsons.get(resourcePath);
            int n = newPriority = jsonObject.has("priority") ? jsonObject.get("priority").getAsInt() : 0;
            if (existing.has("priority") && existing.get("priority").getAsInt() > newPriority) continue;
            recipeJsons.put(resourcePath, jsonObject);
            if (!isStandardRecipe) continue;
            lastStandardRecipeDomain = resourceDomain;
        }
        boolean hasDefaultRecipe = lastStandardRecipeDomain.equals("overlord");
        if (lastStandardRecipeDomain.isEmpty()) {
            Overlord.getLogger().error("No standard recipe found.");
        } else if (!hasDefaultRecipe) {
            Overlord.getLogger().info("The default skeleton recipe is overridden by " + lastStandardRecipeDomain);
        } else {
            Overlord.getLogger().info("The default skeleton recipe is loaded.");
        }
        this.addRecipes(recipeJsons.values());
    }

    private void addRecipes(Collection<JsonObject> recipeJsons) {
        HashSet<SkeletonRecipe> recipes = new HashSet<SkeletonRecipe>();
        for (JsonObject recipeJson : recipeJsons) {
            if (!recipeJson.has("essential")) {
                Overlord.getLogger().error("Data pack skeleton recipe is missing the essential section, skipping.");
                continue;
            }
            SkeletonComponent essentialComponent = this.getComponent(recipeJson.getAsJsonObject("essential"));
            SkeletonComponent musclesComponent = recipeJson.has("muscles") ? this.getComponent(recipeJson.getAsJsonObject("muscles")) : new SkeletonComponent();
            SkeletonComponent skinComponent = recipeJson.has("skin") ? this.getComponent(recipeJson.getAsJsonObject("skin")) : new SkeletonComponent();
            SkeletonComponent playerColorsComponent = recipeJson.has("player_colors") ? this.getComponent(recipeJson.getAsJsonObject("player_colors")) : new SkeletonComponent();
            SkeletonRecipe recipe = new SkeletonRecipe(essentialComponent, musclesComponent, skinComponent, playerColorsComponent);
            recipes.add(recipe);
        }
        this.skeletonBuilder.setSkeletonRecipes(recipes);
    }

    private SkeletonComponent getComponent(JsonObject jsonObject) {
        SkeletonComponent component = new SkeletonComponent();
        JsonArray ingredientsJson = jsonObject.has("ingredients") ? jsonObject.getAsJsonArray("ingredients") : new JsonArray();
        HashSet<SkeletonIngredient> ingredients = new HashSet<SkeletonIngredient>();
        for (JsonElement element : ingredientsJson) {
            ingredients.add(JsonIngredient.parse(element.getAsJsonObject()));
        }
        component.setIngredients(ingredients);
        JsonArray byproductsJson = jsonObject.has("byproducts") ? jsonObject.getAsJsonArray("byproducts") : new JsonArray();
        component.setByproducts(this.readByproducts(byproductsJson));
        return component;
    }

    private Collection<class_1799> readByproducts(JsonArray byproducts) {
        HashSet<class_1799> byproductStacks = new HashSet<class_1799>();
        for (JsonElement byproductElement : byproducts) {
            JsonObject byproduct = byproductElement.getAsJsonObject();
            class_2960 byproductIdentifier = new class_2960(byproduct.get("id").getAsString());
            Optional byproductItem = class_2378.field_11142.method_17966(byproductIdentifier);
            if (byproductItem.isEmpty()) {
                Overlord.getLogger().warn("Byproduct not found, skipping: {}", (Object)byproductIdentifier.toString());
                continue;
            }
            int byproductCount = byproduct.get("count").getAsInt();
            class_1799 byproductStack = new class_1799((class_1935)byproductItem.get(), byproductCount);
            if (byproduct.has("nbt")) {
                class_2487 byproductNbt = JsonIngredient.parseNbt(byproduct);
                byproductStack.method_7980(byproductNbt);
            }
            byproductStacks.add(byproductStack);
        }
        return byproductStacks;
    }
}

