/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.overlord.domain.data.Squads;
import dev.the_fireplace.overlord.domain.entity.OrderableEntity;
import dev.the_fireplace.overlord.domain.entity.Ownable;
import dev.the_fireplace.overlord.domain.entity.logic.EntityAlliances;
import dev.the_fireplace.overlord.entity.OwnedSkeletonEntity;
import dev.the_fireplace.overlord.entity.ai.GoalSelectorHelper;
import dev.the_fireplace.overlord.entity.ai.aiconfig.AISettings;
import dev.the_fireplace.overlord.entity.ai.aiconfig.combat.CombatCategory;
import dev.the_fireplace.overlord.entity.ai.aiconfig.movement.MovementCategory;
import dev.the_fireplace.overlord.entity.ai.aiconfig.movement.PositionSetting;
import dev.the_fireplace.overlord.entity.ai.aiconfig.tasks.TasksCategory;
import dev.the_fireplace.overlord.entity.ai.goal.combat.AbstractArmyBowAttackGoal;
import dev.the_fireplace.overlord.entity.ai.goal.combat.AbstractArmyCrossbowAttackGoal;
import dev.the_fireplace.overlord.entity.ai.goal.combat.ArmyBowAttackGoal;
import dev.the_fireplace.overlord.entity.ai.goal.combat.ArmyCrossbowAttackGoal;
import dev.the_fireplace.overlord.entity.ai.goal.combat.ArmyInPlaceBowAttackGoal;
import dev.the_fireplace.overlord.entity.ai.goal.combat.ArmyInPlaceCrossbowAttackGoal;
import dev.the_fireplace.overlord.entity.ai.goal.combat.ArmyInPlaceMeleeAttackGoal;
import dev.the_fireplace.overlord.entity.ai.goal.combat.ArmyMeleeAttackGoal;
import dev.the_fireplace.overlord.entity.ai.goal.equipment.FindAmmoGoal;
import dev.the_fireplace.overlord.entity.ai.goal.equipment.SwitchToMeleeWhenCloseGoal;
import dev.the_fireplace.overlord.entity.ai.goal.equipment.SwitchToRangedWhenFarGoal;
import dev.the_fireplace.overlord.entity.ai.goal.movement.FollowOwnerGoal;
import dev.the_fireplace.overlord.entity.ai.goal.movement.ReturnHomeGoal;
import dev.the_fireplace.overlord.entity.ai.goal.movement.WanderAroundHomeGoal;
import dev.the_fireplace.overlord.entity.ai.goal.target.ArmyAttackWithOwnerGoal;
import dev.the_fireplace.overlord.entity.ai.goal.target.ArmyTrackOwnerAttackerGoal;
import dev.the_fireplace.overlord.entity.ai.goal.task.GatherItemGoal;
import dev.the_fireplace.overlord.entity.ai.goal.task.GatherMilkGoal;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1344;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1384;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3745;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public abstract class ArmyEntity
extends class_1321
implements Ownable,
OrderableEntity {
    protected static final class_2940<Optional<UUID>> SQUAD = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13313);
    protected final EntityAlliances entityAlliances;
    protected final EmptyUUID emptyUUID;
    protected final Injector injector = DIContainer.get();
    protected final Squads squads;
    protected final AISettings aiSettings;
    protected boolean isSwappingEquipment;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;
    public float prevStrideDistance;
    public float strideDistance;

    protected ArmyEntity(class_1299<? extends ArmyEntity> type, class_1937 world) {
        super(type, world);
        this.entityAlliances = (EntityAlliances)this.injector.getInstance(EntityAlliances.class);
        this.emptyUUID = (EmptyUUID)this.injector.getInstance(EmptyUUID.class);
        this.squads = !world.method_8608() ? (Squads)this.injector.getInstance(Squads.class) : (Squads)this.injector.getInstance(Key.get(Squads.class, (Annotation)Names.named((String)"client")));
        this.aiSettings = this.createBaseAISettings();
        this.reloadGoals();
    }

    private AISettings createBaseAISettings() {
        return new AISettings();
    }

    protected void reloadGoals() {
        if (!this.field_6002.method_8608()) {
            GoalSelectorHelper.clear(this.field_6201);
            GoalSelectorHelper.clear(this.field_6185);
            this.method_5959();
        }
    }

    protected void method_5959() {
        if (this.aiSettings == null) {
            return;
        }
        int goalWeight = 1;
        MovementCategory movement = this.aiSettings.getMovement();
        CombatCategory combat = this.aiSettings.getCombat();
        TasksCategory tasks = this.aiSettings.getTasks();
        goalWeight = this.addBasicSurvivalGoals(goalWeight, movement);
        goalWeight = this.addCombatGoals(goalWeight, combat);
        goalWeight = this.addTaskGoals(goalWeight, tasks);
        goalWeight = this.addStandardMovementGoals(goalWeight, movement);
        goalWeight = this.addIdleGoals(goalWeight);
        this.addTargetSelectors(combat);
    }

    protected int addBasicSurvivalGoals(int goalWeight, MovementCategory movement) {
        if (movement.isEnabled() && this.method_5999()) {
            this.field_6201.method_6277(goalWeight++, (class_1352)new class_1384((class_1314)this));
            this.field_6201.method_6277(goalWeight++, (class_1352)new class_1344((class_1314)this, 1.2));
        }
        return goalWeight;
    }

    protected int addCombatGoals(int goalWeight, CombatCategory combat) {
        if (combat.isEnabled()) {
            if (combat.isRanged() && combat.isSwitchToRangedWhenFar()) {
                this.field_6201.method_6277(goalWeight, (class_1352)new SwitchToRangedWhenFarGoal(this, combat.getRangedSwitchDistance()));
            }
            if (combat.isMelee() && combat.isSwitchToMeleeWhenClose()) {
                this.field_6201.method_6277(goalWeight, (class_1352)new SwitchToMeleeWhenCloseGoal(this, combat.getMeleeSwitchDistance(), combat.isBlock()));
            }
            ++goalWeight;
            if (combat.isRanged()) {
                this.field_6201.method_6277(goalWeight, (class_1352)new FindAmmoGoal(this, combat.isMelee() && combat.isSwitchToMeleeWhenNoAmmo(), combat.isBlock()));
            }
            ++goalWeight;
            boolean pursueTargets = combat.isPursueCombatTargets();
            if (combat.isMelee()) {
                Object meleeGoal = pursueTargets ? new ArmyMeleeAttackGoal(this, 1.0, true) : new ArmyInPlaceMeleeAttackGoal(this);
                this.field_6201.method_6277(goalWeight, (class_1352)meleeGoal);
            }
            if (combat.isRanged()) {
                if (this instanceof class_3745) {
                    int crossbowRange = 8;
                    AbstractArmyCrossbowAttackGoal crossbowGoal = pursueTargets ? new ArmyCrossbowAttackGoal<ArmyEntity>(this, 1.0, crossbowRange) : new ArmyInPlaceCrossbowAttackGoal<ArmyEntity>(this, (float)crossbowRange * 1.5f);
                    this.field_6201.method_6277(goalWeight, crossbowGoal);
                }
                if (this instanceof class_1603) {
                    int bowRange = 15;
                    int attackInterval = 20;
                    AbstractArmyBowAttackGoal bowGoal = pursueTargets ? new ArmyBowAttackGoal<ArmyEntity>(this, 1.0, attackInterval, bowRange) : new ArmyInPlaceBowAttackGoal<ArmyEntity>(this, attackInterval, (float)bowRange * 1.5f);
                    this.field_6201.method_6277(goalWeight, bowGoal);
                }
            }
        }
        return goalWeight;
    }

    protected int addTaskGoals(int goalWeight, TasksCategory tasks) {
        if (tasks.isEnabled()) {
            if (tasks.isGatheringMilk()) {
                this.field_6201.method_6277(goalWeight++, (class_1352)new GatherMilkGoal(this, tasks.getCowSearchDistance()));
            }
            if (tasks.isPickUpItems()) {
                this.field_6201.method_6277(goalWeight++, (class_1352)new GatherItemGoal(this, tasks.getItemSearchDistance()));
            }
        }
        return goalWeight;
    }

    protected int addStandardMovementGoals(int goalWeight, MovementCategory movement) {
        if (movement.isEnabled()) {
            PositionSetting homeSetting = movement.getHome();
            class_243 home = new class_243((double)homeSetting.getX(), (double)homeSetting.getY(), (double)homeSetting.getZ());
            switch (movement.getMoveMode()) {
                case FOLLOW: {
                    byte minimumFollowDistance = movement.getMinimumFollowDistance();
                    byte maximumFollowDistance = movement.getMaximumFollowDistance();
                    this.field_6201.method_6277(goalWeight++, (class_1352)new FollowOwnerGoal(this, 1.0, minimumFollowDistance, maximumFollowDistance, true));
                    break;
                }
                case WANDER: {
                    if (movement.isExploringWander()) {
                        this.field_6201.method_6277(goalWeight++, (class_1352)new class_1379((class_1314)this, 1.0));
                        break;
                    }
                    this.field_6201.method_6277(goalWeight++, (class_1352)new WanderAroundHomeGoal(this, 1.0, home, movement.getMoveRadius()));
                    break;
                }
                case STATIONED: {
                    if (!movement.isStationedReturnHome()) break;
                    this.field_6201.method_6277(goalWeight++, (class_1352)new ReturnHomeGoal(this, 1.0, home));
                }
            }
        }
        return goalWeight;
    }

    protected int addIdleGoals(int goalWeight) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.field_6201.method_6277(goalWeight, (class_1352)new class_1361((class_1308)this, class_1657.class, 16.0f));
            return ++goalWeight;
        }
        if (this.aiSettings.getCombat().isEnabled()) {
            this.field_6201.method_6277(goalWeight++, (class_1352)new class_1361((class_1308)this, class_1308.class, 12.0f));
        }
        this.field_6201.method_6277(goalWeight, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(goalWeight, (class_1352)new class_1376((class_1308)this));
        return ++goalWeight;
    }

    protected void addTargetSelectors(CombatCategory combat) {
        int targetGoalWeight = 1;
        if (combat.isEnabled()) {
            this.field_6185.method_6277(targetGoalWeight++, (class_1352)new ArmyTrackOwnerAttackerGoal(this));
            if (!combat.isOnlyDefendPlayer()) {
                this.field_6185.method_6277(targetGoalWeight++, (class_1352)new ArmyAttackWithOwnerGoal(this));
                this.field_6185.method_6277(targetGoalWeight++, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
                this.field_6185.method_6277(targetGoalWeight, (class_1352)new class_1400((class_1308)this, class_1308.class, 10, true, false, mob -> mob instanceof class_1569));
            }
        }
    }

    @Override
    public AISettings getAISettings() {
        return this.aiSettings;
    }

    @Override
    public void updateAISettings(class_2487 newSettings) {
        this.aiSettings.readTag(newSettings);
        this.reloadGoals();
    }

    public abstract class_1263 getInventory();

    public abstract boolean giveItemStack(class_1799 var1);

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SQUAD, Optional.empty());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.hasExistingSquad()) {
            nbt.method_25927("Squad", this.getSquad());
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(SQUAD, nbt.method_25928("Squad") ? Optional.of(nbt.method_25926("Squad")) : Optional.empty());
    }

    public byte getEquipmentSwapTicks() {
        return 0;
    }

    public boolean isSwappingEquipment() {
        return this.isSwappingEquipment;
    }

    public void setSwappingEquipment(boolean swappingEquipment) {
        this.isSwappingEquipment = swappingEquipment;
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        return !this.entityAlliances.isAlliedTo((class_1297)this, (class_1297)target);
    }

    public class_2338 getHome() {
        PositionSetting homeSetting = this.aiSettings.getMovement().getHome();
        return new class_2338(homeSetting.getX(), homeSetting.getY(), homeSetting.getZ());
    }

    public float getAttackCooldownProgressPerTick() {
        return (float)(1.0 / this.method_26825(class_5134.field_23723) * 20.0);
    }

    public float getAttackCooldownProgress(float baseTime) {
        return class_3532.method_15363((float)(((float)this.field_6273 + baseTime) / this.getAttackCooldownProgressPerTick()), (float)0.0f, (float)1.0f);
    }

    public void resetLastAttackedTicks() {
        this.field_6273 = 0;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public boolean method_5934() {
        return false;
    }

    @Nullable
    public class_1297 method_5933() {
        return null;
    }

    public void method_5954(class_1297 entity, boolean bl) {
    }

    public void method_5932(boolean sendPacket, boolean bl) {
    }

    public abstract int getMainHandSlot();

    public abstract int getOffHandSlot();

    @Override
    public final int getEntityIdNumber() {
        return this.method_5628();
    }

    public static class_5132.class_5133 createArmyAttributes() {
        return class_1308.method_26828().method_26867(class_5134.field_23721).method_26867(class_5134.field_23723);
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    @Nullable
    public class_1309 method_6177() {
        if (this.field_6002 == null || !(this.field_6002 instanceof class_3218)) {
            return null;
        }
        class_1297 entity = ((class_3218)this.field_6002).method_14190(this.method_6139());
        return entity instanceof class_1309 ? (class_1309)entity : null;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public UUID getSquad() {
        return ((Optional)this.field_6011.method_12789(SQUAD)).orElse(this.emptyUUID.get());
    }

    public void setSquad(UUID squadId) {
        this.field_6011.method_12778(SQUAD, this.emptyUUID.is(squadId) ? Optional.empty() : Optional.of(squadId));
    }

    public boolean hasExistingSquad() {
        return !this.emptyUUID.is(this.getSquad()) && this.squads.getSquad(this.method_6139(), this.getSquad()) != null;
    }

    public void method_5773() {
        super.method_5773();
        this.updateCapeAngles();
    }

    protected void updateCapeAngles() {
        this.prevCapeX = this.capeX;
        this.prevCapeY = this.capeY;
        this.prevCapeZ = this.capeZ;
        double capeOffsetX = this.method_23317() - this.capeX;
        double capeOffsetY = this.method_23318() - this.capeY;
        double capeOffsetZ = this.method_23321() - this.capeZ;
        double minOffsetAmount = 10.0;
        if (capeOffsetX > minOffsetAmount) {
            this.prevCapeX = this.capeX = this.method_23317();
        }
        if (capeOffsetZ > minOffsetAmount) {
            this.prevCapeZ = this.capeZ = this.method_23321();
        }
        if (capeOffsetY > minOffsetAmount) {
            this.prevCapeY = this.capeY = this.method_23318();
        }
        if (capeOffsetX < -minOffsetAmount) {
            this.prevCapeX = this.capeX = this.method_23317();
        }
        if (capeOffsetZ < -minOffsetAmount) {
            this.prevCapeZ = this.capeZ = this.method_23321();
        }
        if (capeOffsetY < -minOffsetAmount) {
            this.prevCapeY = this.capeY = this.method_23318();
        }
        this.capeX += capeOffsetX * 0.25;
        this.capeZ += capeOffsetZ * 0.25;
        this.capeY += capeOffsetY * 0.25;
    }

    public void method_6007() {
        this.prevStrideDistance = this.strideDistance;
        super.method_6007();
        float g = this.field_5952 && !this.method_29504() && !this.method_5681() ? Math.min(0.1f, (float)this.method_18798().method_37267()) : 0.0f;
        this.strideDistance += (g - this.strideDistance) * 0.4f;
    }
}

