/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity;

import com.google.common.collect.Lists;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.augment.Augments;
import dev.the_fireplace.overlord.domain.config.ConfigValues;
import dev.the_fireplace.overlord.domain.entity.AnimatedMilkDrinker;
import dev.the_fireplace.overlord.domain.entity.AugmentBearer;
import dev.the_fireplace.overlord.domain.inventory.InventorySearcher;
import dev.the_fireplace.overlord.domain.registry.HeadBlockAugmentRegistry;
import dev.the_fireplace.overlord.domain.world.DaylightDetector;
import dev.the_fireplace.overlord.domain.world.MeleeAttackExecutor;
import dev.the_fireplace.overlord.domain.world.UndeadDaylightDamager;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.OverlordEntities;
import dev.the_fireplace.overlord.entity.OwnedSkeletonContainer;
import dev.the_fireplace.overlord.entity.SkeletonGrowthPhase;
import dev.the_fireplace.overlord.entity.SkeletonInventory;
import dev.the_fireplace.overlord.entity.ai.aiconfig.movement.MovementCategory;
import dev.the_fireplace.overlord.entity.ai.aiconfig.tasks.TasksCategory;
import dev.the_fireplace.overlord.entity.ai.goal.AIEquipmentHelper;
import dev.the_fireplace.overlord.entity.ai.goal.equipment.skeleton.DrinkMilkForHealthGoal;
import dev.the_fireplace.overlord.entity.ai.goal.equipment.skeleton.DrinkMilkGoal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_155;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1703;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3745;
import net.minecraft.class_3908;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class OwnedSkeletonEntity
extends ArmyEntity
implements class_1603,
class_3745,
AnimatedMilkDrinker,
AugmentBearer {
    private static final class_2940<Boolean> CHARGING = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DRINKING_MILK = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_TARGET = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> GROWTH_PHASE = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_SKIN = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_MUSCLES = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> SKINSUIT = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_1799> AUGMENT_BLOCK = class_2945.method_12791(OwnedSkeletonEntity.class, (class_2941)class_2943.field_13322);
    private static final UUID MUSCLE_ATTACK_BONUS_ID = class_3532.method_15378((Random)new Random("Muscle Attack Bonus".hashCode()));
    private static final UUID MUSCLE_TOUGHNESS_BONUS_ID = class_3532.method_15378((Random)new Random("Muscle Toughness Bonus".hashCode()));
    private static final UUID MUSCLE_SPEED_BONUS_ID = class_3532.method_15378((Random)new Random("Muscle Speed Bonus".hashCode()));
    private static final class_1322 MUSCLE_ATTACK_BONUS = new class_1322(MUSCLE_ATTACK_BONUS_ID, "Muscle Attack Bonus", 2.0, class_1322.class_1323.field_6328);
    private static final class_1322 MUSCLE_TOUGHNESS_BONUS = new class_1322(MUSCLE_TOUGHNESS_BONUS_ID, "Muscle Toughness Bonus", 0.25, class_1322.class_1323.field_6328);
    private static final class_1322 MUSCLE_SPEED_BONUS = new class_1322(MUSCLE_SPEED_BONUS_ID, "Muscle Speed Bonus", 0.05, class_1322.class_1323.field_6328);
    private int milkBucketsDrank = 0;
    private final SkeletonInventory inventory = new SkeletonInventory(this);
    private final class_1796 itemCooldownManager = new class_1796();
    private final DaylightDetector daylightDetector;
    private final UndeadDaylightDamager undeadDaylightDamager;
    private final MeleeAttackExecutor meleeAttackExecutor;
    private final InventorySearcher inventorySearcher;
    private final AIEquipmentHelper equipmentHelper;
    private final HeadBlockAugmentRegistry headBlockAugmentRegistry;
    private final ConfigValues configValues;

    @Deprecated
    public OwnedSkeletonEntity(class_1299<? extends OwnedSkeletonEntity> type, class_1937 world) {
        super(type, world);
        this.method_5937(this.field_5974.nextFloat() < 0.05f);
        this.daylightDetector = (DaylightDetector)this.injector.getInstance(DaylightDetector.class);
        this.undeadDaylightDamager = (UndeadDaylightDamager)this.injector.getInstance(UndeadDaylightDamager.class);
        this.meleeAttackExecutor = (MeleeAttackExecutor)this.injector.getInstance(MeleeAttackExecutor.class);
        this.inventorySearcher = (InventorySearcher)this.injector.getInstance(InventorySearcher.class);
        this.equipmentHelper = (AIEquipmentHelper)this.injector.getInstance(AIEquipmentHelper.class);
        this.headBlockAugmentRegistry = (HeadBlockAugmentRegistry)this.injector.getInstance(HeadBlockAugmentRegistry.class);
        this.configValues = (ConfigValues)this.injector.getInstance(ConfigValues.class);
        this.method_18382();
    }

    public static OwnedSkeletonEntity create(class_1937 world, @Nullable UUID owner) {
        OwnedSkeletonEntity e = new OwnedSkeletonEntity((class_1299<? extends OwnedSkeletonEntity>)OverlordEntities.OWNED_SKELETON_TYPE, world);
        e.method_6174(Objects.requireNonNullElseGet(owner, () -> new UUID(801295133947085751L, -7395604847578632613L)));
        return e;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CHARGING, (Object)false);
        this.field_6011.method_12784(HAS_TARGET, (Object)false);
        this.field_6011.method_12784(DRINKING_MILK, (Object)false);
        this.field_6011.method_12784(GROWTH_PHASE, (Object)SkeletonGrowthPhase.BABY.ordinal());
        this.field_6011.method_12784(HAS_SKIN, (Object)false);
        this.field_6011.method_12784(HAS_MUSCLES, (Object)false);
        this.field_6011.method_12784(SKINSUIT, Optional.empty());
        this.field_6011.method_12784(AUGMENT_BLOCK, (Object)class_1799.field_8037);
    }

    public void method_5674(class_2940<?> data) {
        if (this.field_6002.method_8608() && GROWTH_PHASE.equals(data)) {
            this.method_18382();
        }
    }

    public class_1799 getAugmentBlockStack() {
        return (class_1799)this.field_6011.method_12789(AUGMENT_BLOCK);
    }

    protected void method_5958() {
        super.method_5958();
        this.tickRegeneration();
        this.getInventory().tickItems();
        this.tickDaylight();
        this.tickMilkDrinkSound();
    }

    private void tickMilkDrinkSound() {
        if (this.isDrinkingMilk()) {
            this.method_5783(this.method_18807(this.method_6079()), 0.5f, this.field_6002.field_9229.nextFloat() * 0.1f + 0.9f);
        }
    }

    private void tickRegeneration() {
        if (this.field_6002.method_8407() == class_1267.field_5801 && this.field_6002.method_8450().method_8355(class_1928.field_19395) && this.method_6032() < this.method_6063() && this.field_6012 % 2000 == 0) {
            this.method_6025(1.0f);
        }
    }

    private void tickDaylight() {
        if (!this.hasSkin() && this.daylightDetector.isInDaylight((class_1297)this)) {
            this.undeadDaylightDamager.applyDamage((class_1309)this);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!player.method_5715()) {
            if (!player.field_6002.method_8608() && player.method_5667().equals(this.method_6139())) {
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                        buf.method_10797(OwnedSkeletonEntity.this.method_5667());
                    }

                    public class_2561 method_5476() {
                        return OwnedSkeletonEntity.this.method_5476();
                    }

                    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                        return OwnedSkeletonEntity.this.getContainer(inv, syncId);
                    }
                });
            }
            return class_1269.field_5812;
        }
        if (player.method_7337() && player.method_5667().equals(this.method_6139()) && player.method_6047().method_7909() == class_1802.field_8103 && this.canGrow()) {
            switch (this.getGrowthPhase()) {
                case BABY: {
                    this.setGrowthPhase(SkeletonGrowthPhase.QUARTER);
                    this.milkBucketsDrank = this.configValues.getQuarterGrownMilkCount();
                    break;
                }
                case QUARTER: {
                    this.setGrowthPhase(SkeletonGrowthPhase.HALF);
                    this.milkBucketsDrank = this.configValues.getHalfGrownMilkCount();
                    break;
                }
                case HALF: {
                    this.setGrowthPhase(SkeletonGrowthPhase.THREE_QUARTERS);
                    this.milkBucketsDrank = this.configValues.getThreeQuartersGrownMilkCount();
                    break;
                }
                case THREE_QUARTERS: {
                    this.setGrowthPhase(SkeletonGrowthPhase.ADULT);
                    this.milkBucketsDrank = this.configValues.getFullyGrownMilkCount();
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.method_23311();
        if (source != null) {
            this.method_18800(-class_3532.method_15362((float)((this.field_6271 + this.method_36454()) * (float)Math.PI / 180.0f)) * 0.1f, 0.1f, -class_3532.method_15374((float)((this.field_6271 + this.method_36454()) * (float)Math.PI / 180.0f)) * 0.1f);
        } else {
            this.method_18800(0.0, 0.1, 0.0);
        }
        this.method_5646();
        this.method_5729(0, false);
    }

    @Override
    public int getMainHandSlot() {
        return 40;
    }

    @Override
    public int getOffHandSlot() {
        return 41;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(CHARGING);
    }

    public void method_7110(boolean charging) {
        this.field_6011.method_12778(CHARGING, (Object)charging);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_TARGET);
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        this.field_6011.method_12778(HAS_TARGET, (Object)(target != null ? 1 : 0));
    }

    @Environment(value=EnvType.CLIENT)
    public AnimationState getAnimationState() {
        if (this.isCharging()) {
            return AnimationState.CROSSBOW_CHARGE;
        }
        if (this.method_6047().method_7909() instanceof class_1764) {
            return this.hasTarget() ? AnimationState.CROSSBOW_AIM : AnimationState.NEUTRAL;
        }
        if (this.method_6047().method_7909() instanceof class_1753) {
            return this.method_6510() ? AnimationState.BOW_AND_ARROW : AnimationState.NEUTRAL;
        }
        if (this.method_6510()) {
            return AnimationState.MELEE_ATTACK;
        }
        if (this.isDrinkingMilk()) {
            return AnimationState.DRINK;
        }
        return AnimationState.NEUTRAL;
    }

    public boolean method_5722(class_1297 other) {
        return super.method_5722(other) || this.entityAlliances.isAlliedTo((class_1297)this, other);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getStepSound(), 0.15f, 1.0f);
    }

    private class_3414 getStepSound() {
        return this.hasPaddedFeet() ? class_3417.field_14621 : class_3417.field_14548;
    }

    private boolean hasPaddedFeet() {
        return this.getGrowthPhase() == SkeletonGrowthPhase.ADULT && this.hasMuscles() || this.hasSkin();
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    protected void method_16078() {
        super.method_16078();
        this.vanishCursedItems();
        this.inventory.dropAll();
    }

    private void vanishCursedItems() {
        List<Integer> slots = this.inventorySearcher.getSlotsMatching(this.inventory, class_1890::method_8221);
        for (int slot : slots) {
            this.inventory.method_5441(slot);
        }
    }

    protected class_3414 method_6011(class_1282 source) {
        if (!this.hasPlayerlikeBody()) {
            return class_3417.field_15069;
        }
        if (source == class_1282.field_5854) {
            return class_3417.field_14623;
        }
        if (source == class_1282.field_5859) {
            return class_3417.field_15205;
        }
        if (source == class_1282.field_16992) {
            return class_3417.field_17614;
        }
        return class_3417.field_15115;
    }

    protected class_3414 method_6002() {
        return this.hasPlayerlikeBody() ? class_3417.field_14904 : class_3417.field_14877;
    }

    private boolean hasPlayerlikeBody() {
        return this.hasMuscles() && this.getGrowthPhase().ordinal() >= SkeletonGrowthPhase.THREE_QUARTERS.ordinal();
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        class_2499 inventoryTag = tag.method_10554("Inventory", 10);
        this.inventory.deserialize(inventoryTag);
        this.field_6011.method_12778(HAS_SKIN, (Object)tag.method_10577("Skin"));
        this.field_6011.method_12778(SKINSUIT, tag.method_25928("Skinsuit") ? Optional.of(tag.method_25926("Skinsuit")) : Optional.empty());
        this.setHasMuscles(tag.method_10577("Muscles"));
        this.setGrowthPhase(SkeletonGrowthPhase.values()[tag.method_10550("GrowthPhase")]);
        this.updateAISettings(tag.method_10562("aiSettings"));
        this.milkBucketsDrank = tag.method_10550("milkBucketsDrank");
        this.setAugmentBlock(class_1799.method_7915((class_2487)tag.method_10562("augment")));
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("DataVersion", class_155.method_16673().getWorldVersion());
        tag.method_10566("Inventory", (class_2520)this.inventory.serialize(new class_2499()));
        tag.method_10556("Muscles", this.hasMuscles());
        tag.method_10556("Skin", this.hasSkin());
        if (this.hasSkinsuit()) {
            tag.method_25927("Skinsuit", this.getSkinsuit());
        }
        tag.method_10566("aiSettings", (class_2520)this.aiSettings.toTag());
        tag.method_10569("GrowthPhase", ((Integer)this.field_6011.method_12789(GROWTH_PHASE)).intValue());
        tag.method_10569("milkBucketsDrank", this.milkBucketsDrank);
        tag.method_10566("augment", (class_2520)((class_1799)this.field_6011.method_12789(AUGMENT_BLOCK)).method_7953(new class_2487()));
    }

    public boolean method_5679(class_1282 damageSource) {
        if (super.method_5679(damageSource)) {
            return true;
        }
        if (damageSource == class_1282.field_5859) {
            return !this.field_6002.method_8450().method_8355(class_1928.field_20634);
        }
        if (damageSource == class_1282.field_5868) {
            return !this.field_6002.method_8450().method_8355(class_1928.field_20635);
        }
        if (damageSource.method_5534()) {
            return !this.field_6002.method_8450().method_8355(class_1928.field_20636);
        }
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source) || this.method_6032() <= 0.0f) {
            return false;
        }
        amount = this.applyDifficultyScalingModifiers(source, amount);
        return (amount = this.applyAugmentDamageModifiers(source, amount)) != 0.0f && super.method_5643(source, amount);
    }

    private float applyDifficultyScalingModifiers(class_1282 source, float amount) {
        if (source.method_5514()) {
            if (this.field_6002.method_8407() == class_1267.field_5801) {
                amount = Math.min(1.0f, amount);
            } else if (this.field_6002.method_8407() == class_1267.field_5805) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            } else if (this.field_6002.method_8407() == class_1267.field_5807) {
                amount *= 1.5f;
            }
        }
        return amount;
    }

    private float applyAugmentDamageModifiers(class_1282 source, float amount) {
        if (this.hasAugment(Augments.FRAGILE)) {
            if (source.method_5527()) {
                amount /= 4.0f;
            }
            if (source.method_5535() || source.method_5533()) {
                amount *= 1.5f;
            }
        } else if (this.hasAugment(Augments.IMPOSTER)) {
            class_1297 attacker = source.method_5529();
            if (attacker instanceof class_1309 && ((class_1309)attacker).method_5999()) {
                amount *= 0.99f;
            }
        } else if (this.hasAugment(Augments.SLOW_BURN) && source.method_5534()) {
            amount *= 0.05f;
        }
        return amount;
    }

    protected void method_6090(class_1309 attacker) {
        super.method_6090(attacker);
        if (attacker.method_6047().method_7909() instanceof class_1743) {
            this.disableShield(true);
        }
    }

    protected void method_6105(class_1282 source, float amount) {
        this.inventory.damageArmor(amount);
    }

    protected void method_6056(float amount) {
        if (amount < 3.0f || this.field_6277.method_7909() != class_1802.field_8255) {
            return;
        }
        int i = 1 + class_3532.method_15375((float)amount);
        class_1268 hand = this.method_6058();
        this.field_6277.method_7956(i, (class_1309)this, playerEntity -> this.method_20235(hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171));
        if (this.field_6277.method_7960()) {
            if (hand == class_1268.field_5808) {
                this.method_5673(class_1304.field_6173, class_1799.field_8037);
            } else {
                this.method_5673(class_1304.field_6171, class_1799.field_8037);
            }
            this.field_6277 = class_1799.field_8037;
            this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.field_6002.field_9229.nextFloat() * 0.4f);
        }
    }

    protected void method_6074(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return;
        }
        amount = this.method_6132(source, amount);
        amount = this.method_6036(source, amount);
        if ((amount = this.applyAbsorptionToDamage(amount)) != 0.0f) {
            float health = this.method_6032();
            this.method_6033(this.method_6032() - amount);
            this.method_6066().method_5547(source, health, amount);
        }
    }

    private float applyAbsorptionToDamage(float amount) {
        float preAbsorbAmount = amount;
        amount = Math.max(amount - this.method_6067(), 0.0f);
        this.method_6073(this.method_6067() - (preAbsorbAmount - amount));
        return amount;
    }

    protected void method_5997(class_1309 target) {
        this.meleeAttackExecutor.attack((class_1309)this, (class_1297)target, this.getAttackCooldownProgress(0.5f));
        this.resetLastAttackedTicks();
    }

    public void disableShield(boolean sprinting) {
        float f = 0.25f + (float)class_1890.method_8234((class_1309)this) * 0.05f;
        if (sprinting) {
            f += 0.75f;
        }
        if (this.field_5974.nextFloat() < f) {
            this.getItemCooldownManager().method_7906(class_1802.field_8255, 100);
            this.method_6021();
            this.field_6002.method_8421((class_1297)this, (byte)30);
        }
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5681() && !this.method_5765()) {
            double verticalResistance;
            double rotationY = this.method_5720().field_1351;
            double d = verticalResistance = rotationY < -0.2 ? 0.085 : 0.06;
            if (rotationY <= 0.0 || this.field_6282 || !this.field_6002.method_8320(new class_2338(this.method_23317(), this.method_23318() + 0.9, this.method_23321())).method_26227().method_15769()) {
                class_243 vec3d = this.method_18798();
                this.method_18799(vec3d.method_1031(0.0, (rotationY - vec3d.field_1351) * verticalResistance, 0.0));
            }
        }
        super.method_6091(movementInput);
    }

    protected boolean doesNotSuffocate(class_2338 pos) {
        return !this.field_6002.method_8320(pos).method_26228((class_1922)this.field_6002, pos);
    }

    public float method_6029() {
        return (float)this.method_26825(class_5134.field_23719);
    }

    protected class_3414 method_6041(int distance) {
        if (this.hasPaddedFeet()) {
            return distance > 4 ? class_3417.field_14794 : class_3417.field_14778;
        }
        return super.method_6041(distance);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5733() {
        return this.method_16914();
    }

    public class_1799 method_6118(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.inventory.getMainHandStack();
        }
        if (slot == class_1304.field_6171) {
            return (class_1799)this.inventory.offHand.get(0);
        }
        if (slot.method_5925() == class_1304.class_1305.field_6178) {
            return (class_1799)this.inventory.armor.get(slot.method_5927());
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        if (slot == class_1304.field_6173) {
            this.method_6116(stack);
            this.inventory.mainHand.set(0, (Object)stack);
        } else if (slot == class_1304.field_6171) {
            this.method_6116(stack);
            this.inventory.offHand.set(0, (Object)stack);
        } else if (slot.method_5925() == class_1304.class_1305.field_6178) {
            this.method_6116(stack);
            this.inventory.armor.set(slot.method_5927(), (Object)stack);
        }
    }

    @Override
    public boolean giveItemStack(class_1799 stack) {
        this.method_6116(stack);
        return this.inventory.insertStack(stack);
    }

    @Override
    public byte getEquipmentSwapTicks() {
        switch (this.getGrowthPhase()) {
            case BABY: {
                return 40;
            }
            case QUARTER: {
                return 30;
            }
            case HALF: {
                return 20;
            }
            case THREE_QUARTERS: {
                return 10;
            }
            case ADULT: {
                return 5;
            }
        }
        throw new IllegalStateException("Growth phase not found!");
    }

    public Iterable<class_1799> method_5877() {
        return Lists.newArrayList((Object[])new class_1799[]{this.method_6047(), this.method_6079()});
    }

    public Iterable<class_1799> method_5661() {
        return this.inventory.armor;
    }

    public class_1796 getItemCooldownManager() {
        return this.itemCooldownManager;
    }

    public boolean method_5939(class_1799 stack) {
        class_1304 equipmentSlot = class_1309.method_32326((class_1799)stack);
        return this.method_6118(equipmentSlot).method_7960();
    }

    public class_1799 method_18808(class_1799 rangedWeaponStack) {
        if (this.equipmentHelper.hasAmmoEquipped(this)) {
            return this.method_6079();
        }
        return class_1799.field_8037;
    }

    public void setGrowthPhase(SkeletonGrowthPhase newPhase) {
        this.field_6011.method_12778(GROWTH_PHASE, (Object)newPhase.ordinal());
        this.method_18382();
    }

    public float method_17825() {
        return 1.0f - 0.1f * (float)(4 - (Integer)this.field_6011.method_12789(GROWTH_PHASE));
    }

    public SkeletonGrowthPhase getGrowthPhase() {
        return SkeletonGrowthPhase.values()[(Integer)this.field_6011.method_12789(GROWTH_PHASE)];
    }

    public void setSkinsuit(UUID playerId) {
        this.field_6011.method_12778(SKINSUIT, Optional.of(playerId));
        if (!this.field_6002.method_8608()) {
            // empty if block
        }
    }

    public boolean hasSkinsuit() {
        return ((Optional)this.field_6011.method_12789(SKINSUIT)).isPresent();
    }

    public UUID getSkinsuit() {
        Optional skinsuit = (Optional)this.field_6011.method_12789(SKINSUIT);
        return skinsuit.orElseGet(() -> ((EmptyUUID)DIContainer.get().getInstance(EmptyUUID.class)).get());
    }

    public boolean hasSkin() {
        return (Boolean)this.field_6011.method_12789(HAS_SKIN);
    }

    public void setHasSkin(boolean hasSkin) {
        this.field_6011.method_12778(HAS_SKIN, (Object)hasSkin);
    }

    public boolean hasMuscles() {
        return (Boolean)this.field_6011.method_12789(HAS_MUSCLES);
    }

    public void setHasMuscles(boolean hasMuscles) {
        this.field_6011.method_12778(HAS_MUSCLES, (Object)hasMuscles);
        this.method_5996(class_5134.field_23721).method_6202(MUSCLE_ATTACK_BONUS);
        this.method_5996(class_5134.field_23725).method_6202(MUSCLE_TOUGHNESS_BONUS);
        this.method_5996(class_5134.field_23719).method_6202(MUSCLE_SPEED_BONUS);
        if (hasMuscles) {
            this.method_5996(class_5134.field_23721).method_26837(MUSCLE_ATTACK_BONUS);
            this.method_5996(class_5134.field_23725).method_26837(MUSCLE_TOUGHNESS_BONUS);
            this.method_5996(class_5134.field_23719).method_26837(MUSCLE_SPEED_BONUS);
        }
    }

    public OwnedSkeletonContainer getContainer(class_1661 playerInv, int syncId) {
        return new OwnedSkeletonContainer(playerInv, !this.field_6002.field_9236, this, syncId);
    }

    public boolean method_6115() {
        return super.method_6115();
    }

    @Override
    public SkeletonInventory getInventory() {
        return this.inventory;
    }

    public void method_18811(class_1309 target, class_1799 crossbow, class_1676 projectile, float multiShotSpray) {
        this.shootCrossbow(target, crossbow, projectile, multiShotSpray);
    }

    public void method_24651() {
    }

    private void shootCrossbow(class_1309 target, class_1799 crossbow, class_1676 projectile, float multiShotSpray) {
        boolean isMultishotProjectile;
        if (projectile == null) {
            Overlord.getLogger().warn("Projectile is not an entity! {}", projectile.getClass());
            return;
        }
        boolean bl = isMultishotProjectile = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)crossbow) > 0;
        if (projectile instanceof class_1665 && !isMultishotProjectile) {
            ((class_1665)projectile).field_7572 = class_1665.class_1666.field_7593;
        }
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23321() - this.method_23321();
        double f = class_3532.method_15355((float)((float)(d * d + e * e)));
        double g = target.method_23323(0.3333333333333333) - projectile.method_23318() + f * 0.2;
        class_1160 vector3f = this.getProjectileVelocity(new class_243(d, g, e), multiShotSpray);
        projectile.method_7485((double)vector3f.method_4943(), (double)vector3f.method_4945(), (double)vector3f.method_4947(), 1.6f, (float)(14 - this.field_6002.method_8407().method_5461() * 4));
        this.method_5783(class_3417.field_15187, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
    }

    private class_1160 getProjectileVelocity(class_243 vec3d, float multiShotSpray) {
        class_243 vec3d2 = vec3d.method_1029();
        class_243 vec3d3 = vec3d2.method_1036(new class_243(0.0, 1.0, 0.0));
        if (vec3d3.method_1027() <= 1.0E-7) {
            vec3d3 = vec3d2.method_1036(this.method_18864(1.0f));
        }
        class_1158 quaternion = new class_1158(new class_1160(vec3d3), 90.0f, true);
        class_1160 vector3f = new class_1160(vec3d2);
        vector3f.method_19262(quaternion);
        class_1158 quaternion2 = new class_1158(vector3f, multiShotSpray, true);
        class_1160 vector3f2 = new class_1160(vec3d2);
        vector3f2.method_19262(quaternion2);
        return vector3f2;
    }

    public void method_7105(class_1309 target, float f) {
        class_1799 mainHandStack = this.method_6047();
        if (mainHandStack.method_7909() instanceof class_1764) {
            class_1764.method_7777((class_1937)this.field_6002, (class_1309)this, (class_1268)class_1268.field_5808, (class_1799)mainHandStack, (float)1.6f, (float)(14 - this.field_6002.method_8407().method_5461() * 4));
        } else if (mainHandStack.method_7909() instanceof class_1753) {
            this.shootBow(target, f);
        }
    }

    public void shootBow(class_1309 target, float f) {
        boolean usingInfinity;
        class_1799 arrowStack = this.method_18808(this.method_6047());
        class_1665 projectileEntity = this.createArrowProjectile(arrowStack, f);
        boolean hasInfinity = class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)this.method_6047()) > 0;
        boolean bl = usingInfinity = hasInfinity && arrowStack.method_31574(class_1802.field_8107);
        if (!usingInfinity) {
            projectileEntity.field_7572 = class_1665.class_1666.field_7593;
        }
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333) - projectileEntity.method_23318();
        double g = target.method_23321() - this.method_23321();
        double h = class_3532.method_15355((float)((float)(d * d + g * g)));
        projectileEntity.method_7485(d, e + h * 0.2, g, 1.6f, (float)(14 - this.field_6002.method_8407().method_5461() * 4));
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
        this.field_6002.method_8649((class_1297)projectileEntity);
        if (!usingInfinity) {
            if (arrowStack.method_7947() == 1) {
                this.method_6122(class_1268.field_5810, class_1799.field_8037);
            } else {
                this.method_6079().method_7939(arrowStack.method_7947() - 1);
            }
        }
        this.method_6047().method_7956(1, (class_1309)this, entity -> entity.method_20236(class_1268.field_5808));
    }

    protected class_1665 createArrowProjectile(class_1799 arrow, float f) {
        return class_1675.method_18813((class_1309)this, (class_1799)arrow, (float)f);
    }

    @Override
    public void startDrinkingMilkAnimation() {
        this.field_6011.method_12778(DRINKING_MILK, (Object)true);
    }

    @Override
    public void completeDrinkingMilk() {
        this.field_6011.method_12778(DRINKING_MILK, (Object)false);
        if (this.canUseMilkToFullHealingPotential() || !this.canGrow()) {
            this.method_6025(Math.min(this.getMilkRestoreAmount(), this.method_6063() - this.method_6032()));
            return;
        }
        ++this.milkBucketsDrank;
        this.checkForGrowth();
    }

    protected boolean canUseMilkToFullHealingPotential() {
        return this.method_6063() - this.method_6032() >= this.getMilkRestoreAmount();
    }

    protected float getMilkRestoreAmount() {
        return 6.0f;
    }

    protected void checkForGrowth() {
        switch (this.getGrowthPhase()) {
            case BABY: {
                if (this.milkBucketsDrank < this.configValues.getQuarterGrownMilkCount()) break;
                this.setGrowthPhase(SkeletonGrowthPhase.QUARTER);
                break;
            }
            case QUARTER: {
                if (this.milkBucketsDrank < this.configValues.getHalfGrownMilkCount()) break;
                this.setGrowthPhase(SkeletonGrowthPhase.HALF);
                break;
            }
            case HALF: {
                if (this.milkBucketsDrank < this.configValues.getThreeQuartersGrownMilkCount()) break;
                this.setGrowthPhase(SkeletonGrowthPhase.THREE_QUARTERS);
                break;
            }
            case THREE_QUARTERS: {
                if (this.milkBucketsDrank < this.configValues.getFullyGrownMilkCount()) break;
                this.setGrowthPhase(SkeletonGrowthPhase.ADULT);
            }
        }
    }

    protected boolean canGrow() {
        return this.getGrowthPhase() != SkeletonGrowthPhase.ADULT;
    }

    @Override
    public boolean isDrinkingMilk() {
        return (Boolean)this.field_6011.method_12789(DRINKING_MILK);
    }

    @Override
    public boolean canDrinkMilk() {
        return this.canGrow() || this.method_6032() < this.method_6063();
    }

    @Override
    protected int addBasicSurvivalGoals(int goalWeight, MovementCategory movement) {
        goalWeight = super.addBasicSurvivalGoals(goalWeight, movement);
        this.field_6201.method_6277(goalWeight++, new DrinkMilkForHealthGoal<OwnedSkeletonEntity>(this));
        return goalWeight;
    }

    @Override
    protected int addTaskGoals(int goalWeight, TasksCategory tasks) {
        goalWeight = super.addTaskGoals(goalWeight, tasks);
        this.field_6201.method_6277(goalWeight++, new DrinkMilkGoal<OwnedSkeletonEntity>(this));
        return goalWeight;
    }

    @Override
    public boolean hasAugment(class_2960 augment) {
        class_1792 augmentBlockItem = this.getAugmentBlockStack().method_7909();
        return augmentBlockItem instanceof class_1747 && augment.equals((Object)this.headBlockAugmentRegistry.get(((class_1747)augmentBlockItem).method_7711()));
    }

    public void setAugmentBlock(class_1799 augmentBlock) {
        this.field_6011.method_12778(AUGMENT_BLOCK, (Object)augmentBlock);
    }

    @Nullable
    public class_2960 getAugment() {
        class_1792 augmentBlockItem = this.getAugmentBlockStack().method_7909();
        if (augmentBlockItem instanceof class_1747) {
            return this.headBlockAugmentRegistry.get(((class_1747)augmentBlockItem).method_7711());
        }
        return null;
    }

    public static class_5132.class_5133 createOwnedSkeletonAttributes() {
        return ArmyEntity.createArmyAttributes().method_26868(class_5134.field_23719, 0.25);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum AnimationState {
        MELEE_ATTACK,
        BOW_AND_ARROW,
        CROSSBOW_AIM,
        CROSSBOW_CHARGE,
        DRINK,
        NEUTRAL;

    }
}

