/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity;

import com.google.common.collect.ImmutableList;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.overlord.domain.world.ItemDropper;
import dev.the_fireplace.overlord.entity.OwnedSkeletonEntity;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3494;
import org.apache.commons.lang3.tuple.Pair;

public class SkeletonInventory
implements class_1263,
class_1275 {
    public final class_2371<class_1799> main = class_2371.method_10213((int)36, (Object)class_1799.field_8037);
    public final class_2371<class_1799> armor = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public final class_2371<class_1799> mainHand = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    public final class_2371<class_1799> offHand = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    public final OwnedSkeletonEntity skeleton;
    private final List<class_2371<class_1799>> combinedInventory = ImmutableList.of(this.main, this.armor, this.mainHand, this.offHand);
    public static final int MAIN_HAND_SLOT = 40;
    public static final int OFF_HAND_SLOT = 41;
    private int changeCount;

    public SkeletonInventory(OwnedSkeletonEntity skeleton) {
        this.skeleton = skeleton;
    }

    public class_1799 getMainHandStack() {
        return (class_1799)this.mainHand.get(0);
    }

    private boolean canStackAddMore(class_1799 existingStack, class_1799 stack) {
        return !existingStack.method_7960() && this.areItemsEqual(existingStack, stack) && existingStack.method_7946() && existingStack.method_7947() < existingStack.method_7914() && existingStack.method_7947() < this.method_5444();
    }

    private boolean areItemsEqual(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7909() == stack2.method_7909() && class_1799.method_7975((class_1799)stack1, (class_1799)stack2);
    }

    public int getEmptySlot() {
        for (int i = 0; i < this.main.size(); ++i) {
            if (!((class_1799)this.main.get(i)).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public int findSlotIndex(class_1799 itemStack) {
        for (int i = 0; i < this.main.size(); ++i) {
            class_1799 itemStack2 = (class_1799)this.main.get(i);
            if (((class_1799)this.main.get(i)).method_7960() || !this.areItemsEqual(itemStack, (class_1799)this.main.get(i)) || ((class_1799)this.main.get(i)).method_7986() || itemStack2.method_7942() || itemStack2.method_7938()) continue;
            return i;
        }
        return -1;
    }

    public int method_7369(Predicate<class_1799> predicate, int i) {
        int j = 0;
        for (int k = 0; k < this.method_5439(); ++k) {
            class_1799 itemStack = this.method_5438(k);
            if (itemStack.method_7960() || !predicate.test(itemStack)) continue;
            int l = i <= 0 ? itemStack.method_7947() : Math.min(i - j, itemStack.method_7947());
            j += l;
            if (i == 0) continue;
            itemStack.method_7934(l);
            if (itemStack.method_7960()) {
                this.method_5447(k, class_1799.field_8037);
            }
            if (i <= 0 || j < i) continue;
            return j;
        }
        return j;
    }

    private int addStack(class_1799 stack) {
        int i = this.getOccupiedSlotWithRoomForStack(stack);
        if (i == -1) {
            i = this.getEmptySlot();
        }
        return i == -1 ? stack.method_7947() : this.addStack(i, stack);
    }

    private int addStack(int slot, class_1799 stack) {
        class_1792 item = stack.method_7909();
        int i = stack.method_7947();
        class_1799 itemStack = this.method_5438(slot);
        if (itemStack.method_7960()) {
            itemStack = new class_1799((class_1935)item, 0);
            if (stack.method_7985()) {
                assert (stack.method_7969() != null);
                itemStack.method_7980(stack.method_7969().method_10553());
            }
            this.method_5447(slot, itemStack);
        }
        int j = i;
        if (i > itemStack.method_7914() - itemStack.method_7947()) {
            j = itemStack.method_7914() - itemStack.method_7947();
        }
        if (j > this.method_5444() - itemStack.method_7947()) {
            j = this.method_5444() - itemStack.method_7947();
        }
        if (j != 0) {
            i -= j;
            itemStack.method_7933(j);
            itemStack.method_7912(5);
        }
        return i;
    }

    public int getOccupiedSlotWithRoomForStack(class_1799 stack) {
        if (this.canStackAddMore(this.method_5438(40), stack)) {
            return 40;
        }
        if (this.canStackAddMore(this.method_5438(41), stack)) {
            return 41;
        }
        for (int i = 0; i < this.main.size(); ++i) {
            if (!this.canStackAddMore((class_1799)this.main.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public void tickItems() {
        for (class_2371<class_1799> itemStacks : this.combinedInventory) {
            for (int i = 0; i < itemStacks.size(); ++i) {
                if (((class_1799)itemStacks.get(i)).method_7960()) continue;
                ((class_1799)itemStacks.get(i)).method_7917(this.skeleton.field_6002, (class_1297)this.skeleton, i, 40 == i);
            }
        }
    }

    public boolean insertStack(class_1799 stack) {
        return this.insertStack(-1, stack);
    }

    public boolean insertStack(int slot, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        try {
            int i;
            if (stack.method_7986()) {
                if (slot == -1) {
                    slot = this.getEmptySlot();
                }
                if (slot >= 0) {
                    this.main.set(slot, (Object)stack.method_7972());
                    ((class_1799)this.main.get(slot)).method_7912(5);
                    stack.method_7939(0);
                    return true;
                }
                return false;
            }
            do {
                i = stack.method_7947();
                if (slot == -1) {
                    stack.method_7939(this.addStack(stack));
                    continue;
                }
                stack.method_7939(this.addStack(slot, stack));
            } while (!stack.method_7960() && stack.method_7947() < i);
            return stack.method_7947() < i;
        }
        catch (Throwable t) {
            class_128 crashReport = class_128.method_560((Throwable)t, (String)"Adding item to inventory");
            class_129 crashReportSection = crashReport.method_562("Item being added");
            crashReportSection.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
            crashReportSection.method_578("Item data", (Object)stack.method_7919());
            crashReportSection.method_577("Item name", () -> stack.method_7964().getString());
            throw new class_148(crashReport);
        }
    }

    public void offerOrDrop(class_1937 world, class_1799 stack) {
        if (world.field_9236) {
            return;
        }
        while (!stack.method_7960()) {
            int i = this.getOccupiedSlotWithRoomForStack(stack);
            if (i == -1) {
                i = this.getEmptySlot();
            }
            if (i == -1) {
                ((ItemDropper)DIContainer.get().getInstance(ItemDropper.class)).dropItem(stack, (class_1309)this.skeleton);
                break;
            }
            int j = stack.method_7914() - this.method_5438(i).method_7947();
            this.insertStack(i, stack.method_7971(j));
        }
    }

    public class_1799 method_5434(int slot, int amount) {
        Pair<class_2371<class_1799>, Integer> listSlot = this.getInvAndSlot(slot);
        class_2371 list = (class_2371)listSlot.getKey();
        slot = (Integer)listSlot.getValue();
        return list != null && !((class_1799)list.get(slot)).method_7960() ? class_1262.method_5430((List)list, (int)slot, (int)amount) : class_1799.field_8037;
    }

    public void removeOne(class_1799 stack) {
        block0: for (class_2371<class_1799> defaultedList : this.combinedInventory) {
            for (int i = 0; i < defaultedList.size(); ++i) {
                if (defaultedList.get(i) != stack) continue;
                defaultedList.set(i, (Object)class_1799.field_8037);
                continue block0;
            }
        }
    }

    public class_1799 method_5441(int slot) {
        Pair<class_2371<class_1799>, Integer> listSlot = this.getInvAndSlot(slot);
        class_2371 defaultedList = (class_2371)listSlot.getKey();
        slot = (Integer)listSlot.getValue();
        if (defaultedList != null && !((class_1799)defaultedList.get(slot)).method_7960()) {
            class_1799 itemStack = (class_1799)defaultedList.get(slot);
            defaultedList.set(slot, (Object)class_1799.field_8037);
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
        Pair<class_2371<class_1799>, Integer> listSlot = this.getInvAndSlot(slot);
        class_2371 defaultedList = (class_2371)listSlot.getKey();
        slot = (Integer)listSlot.getValue();
        if (defaultedList != null) {
            defaultedList.set(slot, (Object)stack);
        }
    }

    private Pair<class_2371<class_1799>, Integer> getInvAndSlot(int slotIndex) {
        class_2371<class_1799> defaultedList = null;
        for (class_2371<class_1799> defaultedList2 : this.combinedInventory) {
            if (slotIndex < defaultedList2.size()) {
                defaultedList = defaultedList2;
                break;
            }
            slotIndex -= defaultedList2.size();
        }
        return Pair.of(defaultedList, (Object)slotIndex);
    }

    public float getBlockBreakingSpeed(class_2680 block) {
        return this.getMainHandStack().method_7924(block);
    }

    public class_2499 serialize(class_2499 tag) {
        class_2487 compoundTag3;
        int k;
        for (k = 0; k < this.main.size(); ++k) {
            if (((class_1799)this.main.get(k)).method_7960()) continue;
            compoundTag3 = new class_2487();
            compoundTag3.method_10567("Slot", (byte)k);
            ((class_1799)this.main.get(k)).method_7953(compoundTag3);
            tag.add((Object)compoundTag3);
        }
        for (k = 0; k < this.armor.size(); ++k) {
            if (((class_1799)this.armor.get(k)).method_7960()) continue;
            compoundTag3 = new class_2487();
            compoundTag3.method_10567("Slot", (byte)(k + 100));
            ((class_1799)this.armor.get(k)).method_7953(compoundTag3);
            tag.add((Object)compoundTag3);
        }
        for (k = 0; k < this.mainHand.size(); ++k) {
            if (((class_1799)this.mainHand.get(k)).method_7960()) continue;
            compoundTag3 = new class_2487();
            compoundTag3.method_10567("Slot", (byte)(k + 150));
            ((class_1799)this.mainHand.get(k)).method_7953(compoundTag3);
            tag.add((Object)compoundTag3);
        }
        for (k = 0; k < this.offHand.size(); ++k) {
            if (((class_1799)this.offHand.get(k)).method_7960()) continue;
            compoundTag3 = new class_2487();
            compoundTag3.method_10567("Slot", (byte)(k + 200));
            ((class_1799)this.offHand.get(k)).method_7953(compoundTag3);
            tag.add((Object)compoundTag3);
        }
        return tag;
    }

    public void deserialize(class_2499 tag) {
        this.main.clear();
        this.armor.clear();
        this.mainHand.clear();
        this.offHand.clear();
        for (int i = 0; i < tag.size(); ++i) {
            class_2487 compoundTag = tag.method_10602(i);
            int j = compoundTag.method_10571("Slot") & 0xFF;
            class_1799 itemStack = class_1799.method_7915((class_2487)compoundTag);
            if (itemStack.method_7960()) continue;
            if (j < this.main.size()) {
                this.main.set(j, (Object)itemStack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemStack);
                continue;
            }
            if (j >= 150 && j < this.mainHand.size() + 150) {
                this.mainHand.set(j - 150, (Object)itemStack);
                continue;
            }
            if (j < 200 || j >= this.offHand.size() + 200) continue;
            this.offHand.set(j - 200, (Object)itemStack);
        }
    }

    public int method_5439() {
        return this.main.size() + this.armor.size() + this.mainHand.size() + this.offHand.size();
    }

    public boolean method_5442() {
        class_1799 itemStack3;
        Iterator var1 = this.main.iterator();
        do {
            if (var1.hasNext()) continue;
            var1 = this.armor.iterator();
            do {
                if (var1.hasNext()) continue;
                var1 = this.offHand.iterator();
                do {
                    if (var1.hasNext()) continue;
                    return true;
                } while ((itemStack3 = (class_1799)var1.next()).method_7960());
                return false;
            } while ((itemStack3 = (class_1799)var1.next()).method_7960());
            return false;
        } while ((itemStack3 = (class_1799)var1.next()).method_7960());
        return false;
    }

    public class_1799 method_5438(int slot) {
        Pair<class_2371<class_1799>, Integer> listSlot = this.getInvAndSlot(slot);
        class_2371 list = (class_2371)listSlot.getKey();
        slot = (Integer)listSlot.getValue();
        return list == null ? class_1799.field_8037 : (class_1799)list.get(slot);
    }

    public class_2561 method_5477() {
        return new class_2588("container.inventory");
    }

    public boolean isUsingEffectiveTool(class_2680 blockState) {
        return this.getMainHandStack().method_7951(blockState);
    }

    public class_1799 getArmorStack(int slot) {
        return (class_1799)this.armor.get(slot);
    }

    public void damageArmor(float armorDamage) {
        if (armorDamage > 0.0f) {
            if ((armorDamage /= 4.0f) < 1.0f) {
                armorDamage = 1.0f;
            }
            for (class_1799 itemStack : this.armor) {
                if (!(itemStack.method_7909() instanceof class_1738)) continue;
                itemStack.method_7956((int)armorDamage, (class_1309)this.skeleton, skeleton -> skeleton.method_20235(class_1304.values()[2 + this.armor.indexOf((Object)itemStack)]));
            }
        }
    }

    public void dropAll() {
        for (class_2371<class_1799> itemStacks : this.combinedInventory) {
            for (int i = 0; i < itemStacks.size(); ++i) {
                class_1799 itemStack = (class_1799)itemStacks.get(i);
                if (itemStack.method_7960()) continue;
                ((ItemDropper)DIContainer.get().getInstance(ItemDropper.class)).dropItem(itemStack, (class_1309)this.skeleton);
                itemStacks.set(i, (Object)class_1799.field_8037);
            }
        }
    }

    public void method_5431() {
        ++this.changeCount;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public boolean method_5443(class_1657 player) {
        if (this.skeleton.method_31481()) {
            return false;
        }
        return player.method_5858((class_1297)this.skeleton) <= 8.0;
    }

    public boolean contains(class_1799 stack) {
        for (class_2371<class_1799> itemStacks : this.combinedInventory) {
            for (class_1799 itemStack : itemStacks) {
                if (itemStack.method_7960() || !itemStack.method_7962(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(class_3494<class_1792> tag) {
        for (class_2371<class_1799> itemStacks : this.combinedInventory) {
            for (class_1799 itemStack : itemStacks) {
                if (itemStack.method_7960() || !tag.method_15141((Object)itemStack.method_7909())) continue;
                return true;
            }
        }
        return false;
    }

    public void clone(SkeletonInventory other) {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.method_5447(i, other.method_5438(i));
        }
    }

    public void method_5448() {
        for (class_2371<class_1799> itemStacks : this.combinedInventory) {
            itemStacks.clear();
        }
    }
}

