/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import dev.the_fireplace.overlord.domain.registry.EntityRegistry;
import dev.the_fireplace.overlord.domain.registry.EquipmentRegistry;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_2960;
import org.apache.logging.log4j.core.util.UuidUtil;

@Singleton
public class AIListManager {
    public static final UUID EMPTY_LIST_ID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final UUID ALL_MOBS_LIST_ID = UUID.fromString("00000000-0000-0000-0000-000000000001");
    public static final UUID ALL_ANIMALS_LIST_ID = UUID.fromString("00000000-0000-0000-0000-000000000002");
    public static final UUID ALL_EQUIPMENT_LIST_ID = UUID.fromString("00000000-0000-0000-0000-000000000003");
    private final EntityRegistry entityRegistry;
    private final EquipmentRegistry equipmentRegistry;
    private final BiMap<UUID, ImmutableList<class_2960>> lists = HashBiMap.create();

    @Inject
    public AIListManager(EntityRegistry entityRegistry, EquipmentRegistry equipmentRegistry) {
        this.entityRegistry = entityRegistry;
        this.equipmentRegistry = equipmentRegistry;
    }

    public UUID getId(List<class_2960> list) {
        if (this.lists.containsValue(list = this.deduplicateAndSort(list))) {
            return (UUID)this.lists.inverse().get(list);
        }
        UUID id = UuidUtil.getTimeBasedUuid();
        this.lists.put((Object)id, (Object)((ImmutableList)list));
        return id;
    }

    private ImmutableList<class_2960> deduplicateAndSort(List<class_2960> list) {
        return ImmutableSortedSet.copyOf(list).asList();
    }

    public ImmutableList<class_2960> getList(UUID id) {
        if (EMPTY_LIST_ID.equals(id)) {
            return ImmutableList.of();
        }
        if (ALL_MOBS_LIST_ID.equals(id)) {
            return ImmutableSortedSet.copyOf(this.entityRegistry.getMonsterIds()).asList();
        }
        if (ALL_ANIMALS_LIST_ID.equals(id)) {
            return ImmutableSortedSet.copyOf(this.entityRegistry.getAnimalIds()).asList();
        }
        if (ALL_EQUIPMENT_LIST_ID.equals(id)) {
            return ImmutableSortedSet.copyOf(this.equipmentRegistry.getEquipmentIds()).asList();
        }
        return this.lists.containsKey((Object)id) ? (ImmutableList)this.lists.get((Object)id) : ImmutableList.of();
    }

    public void save() {
    }

    public void load() {
    }
}

