/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.aiconfig;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.injectables.ConfigScreenBuilderFactory;
import dev.the_fireplace.lib.api.client.interfaces.ConfigScreenBuilder;
import dev.the_fireplace.lib.api.client.interfaces.CustomButtonBuilder;
import dev.the_fireplace.lib.api.client.interfaces.OptionBuilder;
import dev.the_fireplace.overlord.client.gui.config.PositionSelectorGui;
import dev.the_fireplace.overlord.client.gui.config.listbuilder.ListBuilderGui;
import dev.the_fireplace.overlord.domain.client.OrdersGuiFactory;
import dev.the_fireplace.overlord.domain.entity.OrderableEntity;
import dev.the_fireplace.overlord.entity.ai.aiconfig.AISettings;
import dev.the_fireplace.overlord.entity.ai.aiconfig.combat.CombatCategory;
import dev.the_fireplace.overlord.entity.ai.aiconfig.misc.MiscCategory;
import dev.the_fireplace.overlord.entity.ai.aiconfig.movement.EnumMovementMode;
import dev.the_fireplace.overlord.entity.ai.aiconfig.movement.MovementCategory;
import dev.the_fireplace.overlord.entity.ai.aiconfig.movement.PositionSetting;
import dev.the_fireplace.overlord.entity.ai.aiconfig.tasks.TasksCategory;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import dev.the_fireplace.overlord.network.client.builder.UpdateAIBufferBuilder;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
@Implementation
public final class SkeletonOrdersGuiFactory
implements OrdersGuiFactory {
    private static final String TRANSLATION_BASE = "gui.overlord.aisettings.";
    private static final String OPTION_TRANSLATION_BASE = "gui.overlord.aisettings.option.";
    private static final String ENABLED_TRANSLATION_KEY = "gui.overlord.aisettings.option.enabled";
    private static final String COMBAT_TRANSLATION_BASE = "gui.overlord.aisettings.option.combat.";
    private static final String MOVEMENT_TRANSLATION_BASE = "gui.overlord.aisettings.option.movement.";
    private static final String TASK_TRANSLATION_BASE = "gui.overlord.aisettings.option.task.";
    private static final String MISC_TRANSLATION_BASE = "gui.overlord.aisettings.option.misc.";
    private final AISettings defaultSettings = new AISettings();
    private final Translator translator;
    private final ConfigScreenBuilderFactory configScreenBuilderFactory;
    private ConfigScreenBuilder screenBuilder;
    @Nullable
    private class_2338 currentPosition = null;

    @Inject
    public SkeletonOrdersGuiFactory(TranslatorFactory translatorFactory, ConfigScreenBuilderFactory configScreenBuilderFactory) {
        this.translator = translatorFactory.getTranslator("overlord");
        this.configScreenBuilderFactory = configScreenBuilderFactory;
    }

    @Override
    public class_437 build(class_437 parent, OrderableEntity aiEntity) {
        this.createScreenBuilder(parent, () -> ClientPlayNetworking.send((class_2960)ClientToServerPacketIDs.UPDATE_AI, (class_2540)UpdateAIBufferBuilder.buildForEntity(aiEntity)));
        this.currentPosition = aiEntity instanceof class_1297 ? ((class_1297)aiEntity).method_24515() : null;
        this.buildCategories(aiEntity.getAISettings());
        return this.screenBuilder.build();
    }

    @Override
    public class_437 build(class_437 parent, AISettings ai) {
        this.createScreenBuilder(parent, () -> ClientPlayNetworking.send((class_2960)ClientToServerPacketIDs.UPDATE_AI, (class_2540)UpdateAIBufferBuilder.buildForWand(ai)));
        this.buildCategories(ai);
        return this.screenBuilder.build();
    }

    private void createScreenBuilder(class_437 parent, Runnable saveAction) {
        this.screenBuilder = this.configScreenBuilderFactory.create(this.translator, "gui.overlord.aisettings.name", "gui.overlord.aisettings.combat", parent, saveAction);
    }

    private void buildCategories(AISettings currentSettings) {
        this.addCombatCategory(currentSettings.getCombat());
        this.screenBuilder.startCategory("gui.overlord.aisettings.movement", new Object[0]);
        this.addMovementCategory(currentSettings.getMovement());
        this.screenBuilder.startCategory("gui.overlord.aisettings.tasks", new Object[0]);
        this.addTasksCategory(currentSettings.getTasks());
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.screenBuilder.startCategory("gui.overlord.aisettings.misc", new Object[0]);
            this.addMiscCategory(currentSettings.getMisc());
        }
    }

    private void addCombatCategory(CombatCategory currentSettings) {
        CombatCategory defaults = this.defaultSettings.getCombat();
        OptionBuilder enabled = this.screenBuilder.addBoolToggle(ENABLED_TRANSLATION_KEY, currentSettings.isEnabled(), defaults.isEnabled(), currentSettings::setEnabled).setDescriptionRowCount((byte)0);
        this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.combat.onlyDefend", currentSettings.isOnlyDefendPlayer(), defaults.isOnlyDefendPlayer(), currentSettings::setOnlyDefendPlayer).addDependency(enabled);
        this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.combat.pursueTargets", currentSettings.isPursueCombatTargets(), defaults.isPursueCombatTargets(), currentSettings::setPursueCombatTargets).addDependency(enabled);
        this.addMeleeSettings(currentSettings, defaults, (OptionBuilder<Boolean>)enabled);
        this.addRangedSettings(currentSettings, defaults, (OptionBuilder<Boolean>)enabled);
    }

    private void addMeleeSettings(CombatCategory currentSettings, CombatCategory defaults, OptionBuilder<Boolean> enabled) {
        OptionBuilder meleeEnabled = this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.combat.melee", currentSettings.isMelee(), defaults.isMelee(), currentSettings::setMelee).setDescriptionRowCount((byte)0).addDependency(enabled);
        this.screenBuilder.startSubCategory("gui.overlord.aisettings.combat.meleeSwitching", new Object[0]);
        this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.combat.switchToMeleeWhenNoAmmo", currentSettings.isSwitchToMeleeWhenNoAmmo(), defaults.isSwitchToMeleeWhenNoAmmo(), currentSettings::setSwitchToMeleeWhenNoAmmo).setDescriptionRowCount((byte)0).addDependency(meleeEnabled);
        OptionBuilder switchToMeleeWhenClose = this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.combat.switchToMeleeWhenClose", currentSettings.isSwitchToMeleeWhenClose(), defaults.isSwitchToMeleeWhenClose(), currentSettings::setSwitchToMeleeWhenClose).setDescriptionRowCount((byte)0).addDependency(meleeEnabled);
        this.screenBuilder.addByteSlider("gui.overlord.aisettings.option.combat.switchToMeleeDistance", currentSettings.getMeleeSwitchDistance(), defaults.getMeleeSwitchDistance(), currentSettings::setMeleeSwitchDistance, (byte)1, (byte)127).setDescriptionRowCount((byte)0).addDependency(switchToMeleeWhenClose);
        this.screenBuilder.endSubCategory();
    }

    private void addRangedSettings(CombatCategory currentSettings, CombatCategory defaults, OptionBuilder<Boolean> enabled) {
        OptionBuilder rangedEnabled = this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.combat.ranged", currentSettings.isRanged(), defaults.isRanged(), currentSettings::setRanged).setDescriptionRowCount((byte)0).addDependency(enabled);
        this.screenBuilder.startSubCategory("gui.overlord.aisettings.combat.rangedSwitching", new Object[0]);
        OptionBuilder switchToRangedWhenFar = this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.combat.switchToRangedWhenFar", currentSettings.isSwitchToRangedWhenFar(), defaults.isSwitchToRangedWhenFar(), currentSettings::setSwitchToRangedWhenFar).setDescriptionRowCount((byte)0).addDependency(rangedEnabled);
        this.screenBuilder.addByteSlider("gui.overlord.aisettings.option.combat.switchToRangedDistance", currentSettings.getRangedSwitchDistance(), defaults.getRangedSwitchDistance(), currentSettings::setRangedSwitchDistance, (byte)2, (byte)127).setDescriptionRowCount((byte)0).addDependency(switchToRangedWhenFar);
        this.screenBuilder.endSubCategory();
    }

    private void addMovementCategory(MovementCategory currentSettings) {
        MovementCategory defaults = this.defaultSettings.getMovement();
        OptionBuilder enabled = this.screenBuilder.addBoolToggle(ENABLED_TRANSLATION_KEY, currentSettings.isEnabled(), defaults.isEnabled(), currentSettings::setEnabled).setDescriptionRowCount((byte)0);
        OptionBuilder movementMode = this.screenBuilder.addEnumDropdown("gui.overlord.aisettings.option.movement.moveMode", (Enum)currentSettings.getMoveMode(), (Enum)defaults.getMoveMode(), (Enum[])EnumMovementMode.values(), currentSettings::setMoveMode).addDependency(enabled).setDescriptionRowCount((byte)0);
        this.screenBuilder.addByteSlider("gui.overlord.aisettings.option.movement.minimumFollowDistance", currentSettings.getMinimumFollowDistance(), defaults.getMinimumFollowDistance(), currentSettings::setMinimumFollowDistance, (byte)1, (byte)127).addDependency(movementMode, mode -> mode == EnumMovementMode.FOLLOW).setDescriptionRowCount((byte)0);
        this.screenBuilder.addByteSlider("gui.overlord.aisettings.option.movement.maximumFollowDistance", currentSettings.getMaximumFollowDistance(), defaults.getMaximumFollowDistance(), currentSettings::setMaximumFollowDistance, (byte)1, (byte)127).addDependency(movementMode, mode -> mode == EnumMovementMode.FOLLOW).setDescriptionRowCount((byte)0);
        OptionBuilder isExploringWander = this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.movement.exploringWander", currentSettings.isExploringWander(), defaults.isExploringWander(), currentSettings::setExploringWander).addDependency(movementMode, mode -> mode == EnumMovementMode.WANDER);
        this.screenBuilder.addByteSlider("gui.overlord.aisettings.option.movement.wanderRadius", currentSettings.getMoveRadius(), defaults.getMoveRadius(), currentSettings::setMoveRadius, (byte)2, (byte)127).addDependency(movementMode, mode -> mode == EnumMovementMode.WANDER).addDependency(isExploringWander, explore -> explore == false);
        this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.movement.returnHome", currentSettings.isStationedReturnHome(), defaults.isStationedReturnHome(), currentSettings::setStationedReturnHome).addDependency(movementMode, mode -> mode == EnumMovementMode.STATIONED);
        this.addPositionSetting("gui.overlord.aisettings.option.movement.home", currentSettings.getHome(), defaults.getHome(), currentSettings::setHome).addDependency(movementMode, mode -> mode == EnumMovementMode.STATIONED || mode == EnumMovementMode.WANDER);
    }

    private void addTasksCategory(TasksCategory currentSettings) {
        TasksCategory defaults = this.defaultSettings.getTasks();
        OptionBuilder enabled = this.screenBuilder.addBoolToggle(ENABLED_TRANSLATION_KEY, currentSettings.isEnabled(), defaults.isEnabled(), currentSettings::setEnabled).setDescriptionRowCount((byte)0);
        this.screenBuilder.startSubCategory("gui.overlord.aisettings.option.task.gatherMilk", new Object[0]);
        OptionBuilder gatherMilkEnabled = this.screenBuilder.addBoolToggle(ENABLED_TRANSLATION_KEY, currentSettings.isGatheringMilk(), defaults.isGatheringMilk(), currentSettings::setGatheringMilk).setDescriptionRowCount((byte)0).addDependency(enabled);
        this.screenBuilder.addShortField("gui.overlord.aisettings.option.task.cowSearchDistance", currentSettings.getCowSearchDistance(), defaults.getCowSearchDistance(), currentSettings::setCowSearchDistance).setMinimum((Object)1).setMaximum((Object)512).setDescriptionRowCount((byte)0).addDependency(gatherMilkEnabled);
        this.screenBuilder.endSubCategory();
        this.screenBuilder.startSubCategory("gui.overlord.aisettings.option.task.gatherItems", new Object[0]);
        OptionBuilder gatherItemsEnabled = this.screenBuilder.addBoolToggle(ENABLED_TRANSLATION_KEY, currentSettings.isPickUpItems(), defaults.isPickUpItems(), currentSettings::setPickUpItems).setDescriptionRowCount((byte)0).addDependency(enabled);
        this.screenBuilder.addByteField("gui.overlord.aisettings.option.task.itemSearchDistance", currentSettings.getItemSearchDistance(), defaults.getItemSearchDistance(), currentSettings::setItemSearchDistance).setMinimum((Object)1).setMaximum((Object)127).setDescriptionRowCount((byte)0).addDependency(gatherItemsEnabled);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.addUniversalList("gui.overlord.aisettings.option.task.gatherItemsList", currentSettings.getPickUpItemsList(), defaults.getPickUpItemsList(), currentSettings::setPickUpItemsList).addDependency(gatherItemsEnabled);
        }
        this.screenBuilder.endSubCategory();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.screenBuilder.startSubCategory("gui.overlord.aisettings.option.task.woodcutting", new Object[0]);
            OptionBuilder woodcuttingEnabled = this.screenBuilder.addBoolToggle(ENABLED_TRANSLATION_KEY, currentSettings.isWoodcutting(), defaults.isWoodcutting(), currentSettings::setWoodcutting).setDescriptionRowCount((byte)0);
            this.addUniversalList("gui.overlord.aisettings.option.task.woodcuttingBlockList", currentSettings.getWoodcuttingBlockList(), defaults.getWoodcuttingBlockList(), currentSettings::setWoodcuttingBlockList).addDependency(woodcuttingEnabled);
            this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.task.woodcuttingWithoutTools", currentSettings.isWoodcuttingWithoutTools(), defaults.isWoodcuttingWithoutTools(), currentSettings::setWoodcuttingWithoutTools).setDescriptionRowCount((byte)0).addDependency(woodcuttingEnabled);
            this.screenBuilder.endSubCategory();
        }
    }

    private void addMiscCategory(MiscCategory currentSettings) {
        MiscCategory defaults = this.defaultSettings.getMisc();
        OptionBuilder saveDamagedEquipment = this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.misc.saveDamagedEquipment", currentSettings.isSaveDamagedEquipment(), defaults.isSaveDamagedEquipment(), currentSettings::setSaveDamagedEquipment);
        this.addUniversalList("gui.overlord.aisettings.option.misc.saveEquipmentList", currentSettings.getSaveEquipmentList(), defaults.getSaveEquipmentList(), currentSettings::setSaveEquipmentList).addDependency(saveDamagedEquipment);
        this.screenBuilder.addBoolToggle("gui.overlord.aisettings.option.misc.loadChunks", currentSettings.isLoadChunks(), defaults.isLoadChunks(), currentSettings::setLoadChunks);
    }

    private CustomButtonBuilder<String> addUniversalList(String optionTranslationBase, UUID currentValue, UUID defaultValue, Consumer<UUID> saveFunction) {
        return this.screenBuilder.addCustomOptionButton(optionTranslationBase, currentValue.toString(), defaultValue.toString(), stringValue -> saveFunction.accept(UUID.fromString(stringValue)), (parent, current) -> new ListBuilderGui((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), parent, (String)current));
    }

    private CustomButtonBuilder<String> addPositionSetting(String optionTranslationBase, PositionSetting currentValue, PositionSetting defaultValue, Consumer<PositionSetting> saveFunction) {
        return this.screenBuilder.addCustomOptionButton(optionTranslationBase, currentValue.toString(), defaultValue.toString(), stringValue -> saveFunction.accept(PositionSetting.fromString(stringValue)), (parent, current) -> new PositionSelectorGui((class_2561)this.translator.getTranslatedText(optionTranslationBase, new Object[0]), parent, (String)current, this.currentPosition));
    }
}

