/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal;

import dev.the_fireplace.overlord.domain.inventory.CommonPriorityMappers;
import dev.the_fireplace.overlord.domain.inventory.InventorySearcher;
import dev.the_fireplace.overlord.domain.world.ItemDropper;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.util.EquipmentUtils;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1819;

@Singleton
public class AIEquipmentHelper {
    protected final InventorySearcher inventorySearcher;
    protected final CommonPriorityMappers commonPriorityMappers;
    protected final ItemDropper itemDropper;

    @Inject
    public AIEquipmentHelper(InventorySearcher inventorySearcher, CommonPriorityMappers commonPriorityMappers, ItemDropper itemDropper) {
        this.inventorySearcher = inventorySearcher;
        this.commonPriorityMappers = commonPriorityMappers;
        this.itemDropper = itemDropper;
    }

    public boolean isUsingRanged(ArmyEntity armyEntity) {
        return EquipmentUtils.isRangedWeapon(armyEntity.method_6047());
    }

    public boolean hasAmmoEquipped(ArmyEntity armyEntity) {
        return EquipmentUtils.isAmmoFor(armyEntity.method_6047(), armyEntity.method_6079()) || !this.requiresAmmoForRangedWeapon(armyEntity);
    }

    public boolean requiresAmmoForRangedWeapon(ArmyEntity armyEntity) {
        return EquipmentUtils.requiresAmmo(armyEntity.method_6047());
    }

    public boolean shouldEquipShield(ArmyEntity armyEntity) {
        if (armyEntity.method_6079().method_7909() instanceof class_1819) {
            return false;
        }
        return this.inventorySearcher.hasSlotMatching(armyEntity.getInventory(), stack -> stack.method_7909() instanceof class_1819);
    }

    public boolean hasUsableRangedWeapon(ArmyEntity armyEntity) {
        class_1263 inventory = armyEntity.getInventory();
        Map<Integer, Integer> rangedWeaponSlots = this.inventorySearcher.getSlotsMatchingByPriority(inventory, EquipmentUtils::isRangedWeapon, this.commonPriorityMappers.weapon((class_1309)armyEntity, armyEntity.method_5968()));
        for (int rangedWeaponSlot : rangedWeaponSlots.keySet()) {
            class_1799 weapon = inventory.method_5438(rangedWeaponSlot);
            boolean hasAmmo = this.hasAmmoForWeapon(inventory, weapon);
            if (!hasAmmo) continue;
            return true;
        }
        return false;
    }

    public boolean hasAmmoForWeapon(class_1263 inventory, class_1799 weapon) {
        return this.inventorySearcher.hasSlotMatching(inventory, stack -> EquipmentUtils.isAmmoFor(weapon, stack));
    }

    public void equipUsableRangedWeapon(ArmyEntity armyEntity) {
        class_1263 inventory = armyEntity.getInventory();
        Map<Integer, Integer> rangedWeaponSlots = this.inventorySearcher.getSlotsMatchingByPriority(inventory, EquipmentUtils::isRangedWeapon, this.commonPriorityMappers.weapon((class_1309)armyEntity, armyEntity.method_5968()));
        for (int rangedWeaponSlot : rangedWeaponSlots.keySet()) {
            class_1799 weapon = inventory.method_5438(rangedWeaponSlot);
            boolean hasAmmo = this.hasAmmoForWeapon(inventory, weapon);
            if (!hasAmmo) continue;
            class_1799 newWeapon = inventory.method_5441(rangedWeaponSlot);
            class_1799 oldWeapon = armyEntity.method_6047().method_7972();
            armyEntity.method_5673(class_1304.field_6173, newWeapon);
            if (!armyEntity.giveItemStack(oldWeapon)) {
                this.itemDropper.dropItem(oldWeapon, (class_1309)armyEntity);
            }
            return;
        }
    }

    public void equipUsableAmmo(ArmyEntity armyEntity) {
        class_1263 inventory = armyEntity.getInventory();
        class_1799 weapon = armyEntity.method_6047();
        Map<Integer, Integer> ammoPriority = this.inventorySearcher.getSlotsMatchingByPriority(inventory, stack -> EquipmentUtils.isAmmoFor(weapon, stack), this.commonPriorityMappers.ammo(weapon));
        int oldAmmoSlot = ammoPriority.keySet().toArray(new Integer[0])[0];
        class_1799 newAmmo = inventory.method_5441(oldAmmoSlot);
        class_1799 oldOffHandStack = armyEntity.method_6079().method_7972();
        armyEntity.method_5673(class_1304.field_6171, newAmmo);
        if (!armyEntity.giveItemStack(oldOffHandStack)) {
            this.itemDropper.dropItem(oldOffHandStack, (class_1309)armyEntity);
        }
    }

    public void equipMeleeWeapon(ArmyEntity armyEntity) {
        boolean rangedWeaponWentBackIntoMainHand;
        class_1263 inventory = armyEntity.getInventory();
        Map<Integer, Integer> meleePriority = this.inventorySearcher.getSlotsMatchingByPriority(inventory, EquipmentUtils::isMeleeWeapon, this.commonPriorityMappers.weapon((class_1309)armyEntity, armyEntity.method_5968()));
        class_1799 newWeapon = class_1799.field_8037;
        if (!meleePriority.isEmpty()) {
            int oldWeaponSlot = meleePriority.keySet().toArray(new Integer[0])[0];
            newWeapon = inventory.method_5441(oldWeaponSlot);
        }
        class_1799 oldMainHandStack = armyEntity.method_6047().method_7972();
        armyEntity.method_5673(class_1304.field_6173, newWeapon);
        if (!armyEntity.giveItemStack(oldMainHandStack)) {
            this.itemDropper.dropItem(oldMainHandStack, (class_1309)armyEntity);
        }
        boolean bl = rangedWeaponWentBackIntoMainHand = newWeapon.method_7960() && this.isUsingRanged(armyEntity);
        if (rangedWeaponWentBackIntoMainHand) {
            oldMainHandStack = armyEntity.method_6047().method_7972();
            armyEntity.method_5673(class_1304.field_6173, class_1799.field_8037);
            this.itemDropper.throwItem(oldMainHandStack, (class_1309)armyEntity);
        }
    }

    public void equipUsableShield(ArmyEntity armyEntity) {
        class_1263 inventory = armyEntity.getInventory();
        Map<Integer, Integer> shieldPriority = this.inventorySearcher.getSlotsMatchingByPriority(inventory, stack -> stack.method_7909() instanceof class_1819, stack -> stack.method_7936() - stack.method_7919());
        int oldShieldSlot = shieldPriority.keySet().toArray(new Integer[0])[0];
        class_1799 newShield = inventory.method_5441(oldShieldSlot);
        class_1799 oldOffHandStack = armyEntity.method_6079().method_7972();
        armyEntity.method_5673(class_1304.field_6171, newShield);
        if (!armyEntity.giveItemStack(oldOffHandStack)) {
            this.itemDropper.dropItem(oldOffHandStack, (class_1309)armyEntity);
        }
    }
}

