/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.combat;

import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.goal.AIEquipmentHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1753;

public abstract class AbstractArmyBowAttackGoal<T extends ArmyEntity>
extends class_1352 {
    protected final T armyEntity;
    protected int attackInterval;
    protected final float squaredRange;
    protected int cooldown = -1;
    protected int targetSeeingTicker;
    protected int combatTicks = -1;
    protected final AIEquipmentHelper equipmentHelper;
    protected long lastUpdateTime;

    public AbstractArmyBowAttackGoal(T armyEntity, int attackInterval, float range) {
        this.armyEntity = armyEntity;
        this.attackInterval = attackInterval;
        this.squaredRange = range * range;
        this.equipmentHelper = (AIEquipmentHelper)DIContainer.get().getInstance(AIEquipmentHelper.class);
    }

    public void setAttackInterval(int attackInterval) {
        this.attackInterval = attackInterval;
    }

    public boolean method_6264() {
        long worldTime = ((ArmyEntity)this.armyEntity).field_6002.method_8510();
        if (worldTime - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = worldTime;
        return this.hasAliveTarget() && this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.armyEntity.method_6047().method_7909() instanceof class_1753 && this.equipmentHelper.hasAmmoEquipped((ArmyEntity)this.armyEntity);
    }

    private boolean hasAliveTarget() {
        return this.armyEntity.method_5968() != null && this.armyEntity.method_5968().method_5805();
    }

    public boolean method_6266() {
        return this.hasAliveTarget() && this.isHoldingBow();
    }

    public void method_6269() {
        super.method_6269();
        this.armyEntity.method_19540(true);
    }

    public void method_6270() {
        super.method_6270();
        this.armyEntity.method_19540(false);
        this.targetSeeingTicker = 0;
        this.cooldown = -1;
        this.armyEntity.method_6021();
    }

    public void method_6268() {
        boolean remembersSeeingTarget;
        class_1309 target = this.armyEntity.method_5968();
        if (target == null) {
            return;
        }
        double squaredDistanceToTarget = this.armyEntity.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        boolean canSeeTarget = this.armyEntity.method_5985().method_6369((class_1297)target);
        boolean bl = remembersSeeingTarget = this.targetSeeingTicker > 0;
        if (canSeeTarget != remembersSeeingTarget) {
            this.targetSeeingTicker = 0;
        }
        this.targetSeeingTicker = canSeeTarget ? ++this.targetSeeingTicker : --this.targetSeeingTicker;
        this.combatTicks = !(squaredDistanceToTarget > (double)this.squaredRange) && this.targetSeeingTicker >= 20 ? ++this.combatTicks : -1;
        this.handleCombatMovement(target, squaredDistanceToTarget);
        if (this.combatTicks > -1) {
            this.armyEntity.method_5951((class_1297)target, 30.0f, 30.0f);
        } else {
            this.armyEntity.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        }
        if (this.armyEntity.method_6115()) {
            int itemUseTime;
            if (!canSeeTarget && this.targetSeeingTicker < -60) {
                this.armyEntity.method_6021();
            } else if (canSeeTarget && (itemUseTime = this.armyEntity.method_6048()) >= 20) {
                this.armyEntity.method_6021();
                ((class_1603)this.armyEntity).method_7105(target, class_1753.method_7722((int)itemUseTime));
                this.cooldown = this.attackInterval;
            }
        } else if (--this.cooldown <= 0 && this.targetSeeingTicker >= -60) {
            this.armyEntity.method_6019(class_1268.field_5808);
        }
    }

    protected void handleCombatMovement(class_1309 target, double squaredDistanceToTarget) {
    }
}

