/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.combat;

import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.goal.AIEquipmentHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_3745;

public abstract class AbstractArmyCrossbowAttackGoal<T extends ArmyEntity & class_3745>
extends class_1352 {
    protected final T armyEntity;
    protected final float squaredRange;
    protected final AIEquipmentHelper equipmentHelper;
    protected Stage stage;
    protected int seeingTargetTicker;
    protected int chargedTicksLeft;
    protected long lastUpdateTime;

    public AbstractArmyCrossbowAttackGoal(T armyEntity, float range) {
        this.armyEntity = armyEntity;
        this.squaredRange = range * range;
        this.equipmentHelper = (AIEquipmentHelper)DIContainer.get().getInstance(AIEquipmentHelper.class);
        this.stage = Stage.UNCHARGED;
    }

    public boolean method_6264() {
        long worldTime = ((ArmyEntity)this.armyEntity).field_6002.method_8510();
        if (worldTime - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = worldTime;
        return this.hasAliveTarget() && this.isEntityHoldingCrossbow();
    }

    private boolean isEntityHoldingCrossbow() {
        return this.armyEntity.method_6047().method_7909() instanceof class_1764 && (this.equipmentHelper.hasAmmoEquipped((ArmyEntity)this.armyEntity) || class_1764.method_7781((class_1799)this.armyEntity.method_6047()));
    }

    public boolean method_6266() {
        return this.hasAliveTarget() && this.isEntityHoldingCrossbow();
    }

    private boolean hasAliveTarget() {
        return this.armyEntity.method_5968() != null && this.armyEntity.method_5968().method_5805();
    }

    public void method_6270() {
        this.armyEntity.method_19540(false);
        this.armyEntity.method_5980(null);
        this.seeingTargetTicker = 0;
        if (this.armyEntity.method_6115()) {
            this.armyEntity.method_6021();
            ((class_3745)this.armyEntity).method_7110(false);
            class_1764.method_7782((class_1799)this.armyEntity.method_6030(), (boolean)false);
        }
    }

    public void method_6268() {
        boolean remembersSeeingTarget;
        class_1309 target = this.armyEntity.method_5968();
        if (target == null) {
            return;
        }
        boolean canSeeTarget = this.armyEntity.method_5985().method_6369((class_1297)target);
        boolean bl = remembersSeeingTarget = this.seeingTargetTicker > 0;
        if (canSeeTarget != remembersSeeingTarget) {
            this.seeingTargetTicker = 0;
        }
        this.seeingTargetTicker = canSeeTarget ? ++this.seeingTargetTicker : --this.seeingTargetTicker;
        double squaredDistanceToTarget = this.armyEntity.method_5858((class_1297)target);
        boolean targetIsOutOfRange = (squaredDistanceToTarget > (double)this.squaredRange || this.seeingTargetTicker < 5) && this.chargedTicksLeft == 0;
        this.handleMoveToTarget(target, targetIsOutOfRange);
        this.armyEntity.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        if (this.stage == Stage.UNCHARGED) {
            if (!targetIsOutOfRange) {
                this.armyEntity.method_6019(class_1268.field_5808);
                this.stage = Stage.CHARGING;
                ((class_3745)this.armyEntity).method_7110(true);
            }
        } else if (this.stage == Stage.CHARGING) {
            class_1799 crossbowStack;
            int itemUseTime;
            if (!this.armyEntity.method_6115()) {
                this.stage = Stage.UNCHARGED;
            }
            if ((itemUseTime = this.armyEntity.method_6048()) >= class_1764.method_7775((class_1799)(crossbowStack = this.armyEntity.method_6030()))) {
                this.armyEntity.method_6075();
                this.stage = Stage.CHARGED;
                this.chargedTicksLeft = 20 + this.armyEntity.method_6051().nextInt(20);
                ((class_3745)this.armyEntity).method_7110(false);
            }
        } else if (this.stage == Stage.CHARGED) {
            --this.chargedTicksLeft;
            if (this.chargedTicksLeft == 0) {
                this.stage = Stage.READY_TO_ATTACK;
            }
        } else if (this.stage == Stage.READY_TO_ATTACK && canSeeTarget) {
            ((class_1603)this.armyEntity).method_7105(target, 1.0f);
            class_1799 crossbowStack = this.armyEntity.method_5998(class_1268.field_5808);
            class_1764.method_7782((class_1799)crossbowStack, (boolean)false);
            this.stage = Stage.UNCHARGED;
        }
    }

    protected void handleMoveToTarget(class_1309 target, boolean targetIsOutOfRange) {
    }

    protected boolean isUncharged() {
        return this.stage == Stage.UNCHARGED;
    }

    static enum Stage {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

