/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.combat;

import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.goal.AIEquipmentHelper;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_5134;

public class ArmyInPlaceMeleeAttackGoal
extends class_1352 {
    protected final ArmyEntity armyEntity;
    protected final AIEquipmentHelper equipmentHelper;
    private int updateCountdownTicks;
    private int cooldown;
    private long lastUpdateTime;

    public ArmyInPlaceMeleeAttackGoal(ArmyEntity armyEntity) {
        this.armyEntity = armyEntity;
        this.equipmentHelper = (AIEquipmentHelper)DIContainer.get().getInstance(AIEquipmentHelper.class);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
    }

    private boolean meleeCanStart() {
        long l = this.armyEntity.field_6002.method_8510();
        if (l - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = l;
        class_1309 livingEntity = this.armyEntity.method_5968();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.method_5805()) {
            return false;
        }
        return this.isWithinAttackDistance(livingEntity);
    }

    private boolean isWithinAttackDistance(class_1309 livingEntity) {
        return this.getSquaredMaxAttackDistance(livingEntity) >= this.armyEntity.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
    }

    public boolean method_6264() {
        return this.meleeCanStart() && this.shouldAttackWithMelee();
    }

    private boolean shouldAttackWithMelee() {
        return !this.equipmentHelper.isUsingRanged(this.armyEntity) || !this.equipmentHelper.hasAmmoEquipped(this.armyEntity);
    }

    private boolean meleeShouldContinue() {
        class_1309 livingEntity = this.armyEntity.method_5968();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.method_5805()) {
            return false;
        }
        if (!this.isWithinAttackDistance(livingEntity)) {
            return false;
        }
        return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657)livingEntity).method_7337();
    }

    public boolean method_6266() {
        return this.meleeShouldContinue() && this.shouldAttackWithMelee();
    }

    public void method_6269() {
        this.armyEntity.method_19540(true);
        this.updateCountdownTicks = 0;
        this.cooldown = 0;
    }

    public void method_6270() {
        class_1309 livingEntity = this.armyEntity.method_5968();
        if (!class_1301.field_6156.test(livingEntity)) {
            this.armyEntity.method_5980(null);
        }
        this.armyEntity.method_19540(false);
        this.armyEntity.method_5942().method_6340();
    }

    public void method_6268() {
        class_1309 livingEntity = this.armyEntity.method_5968();
        this.armyEntity.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
        double d = this.armyEntity.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
        this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
        if (this.armyEntity.method_5985().method_6369((class_1297)livingEntity) && this.updateCountdownTicks <= 0 && this.armyEntity.method_6051().nextFloat() < 0.05f) {
            this.updateCountdownTicks = 4 + this.armyEntity.method_6051().nextInt(7);
            if (d > 1024.0) {
                this.updateCountdownTicks += 10;
            } else if (d > 256.0) {
                this.updateCountdownTicks += 5;
            }
        }
        this.cooldown = Math.max(this.cooldown - 1, 0);
        this.attack(livingEntity, d);
    }

    protected void attack(class_1309 target, double squaredDistance) {
        double d = this.getSquaredMaxAttackDistance(target);
        if (squaredDistance <= d && this.isCooledDown()) {
            if (!this.armyEntity.method_5770().method_8608()) {
                double attackSpeed = this.armyEntity.method_26825(class_5134.field_23723);
                this.cooldown = Math.max(1, (int)Math.ceil(20.0 / attackSpeed - 0.5));
            }
            this.armyEntity.method_6104(class_1268.field_5808);
            this.armyEntity.method_6121((class_1297)target);
        }
    }

    protected double getSquaredMaxAttackDistance(class_1309 entity) {
        return this.armyEntity.method_17681() * 2.0f * this.armyEntity.method_17681() * 2.0f + entity.method_17681();
    }

    protected boolean isCooledDown() {
        return this.cooldown <= 0;
    }
}

