/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.equipment;

import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.goal.AIEquipmentHelper;
import dev.the_fireplace.overlord.entity.ai.goal.equipment.SwapEquipmentGoal;

public class FindAmmoGoal
extends SwapEquipmentGoal {
    protected final boolean switchToMeleeWhenOut;
    protected final boolean equipShieldWhenSwitchingToMelee;
    protected final AIEquipmentHelper equipmentHelper;
    protected byte postSwapCooldownTicks;

    public FindAmmoGoal(ArmyEntity armyEntity, boolean switchToMeleeWhenOut, boolean equipShieldWhenSwitchingToMelee) {
        super(armyEntity);
        this.switchToMeleeWhenOut = switchToMeleeWhenOut;
        this.equipShieldWhenSwitchingToMelee = equipShieldWhenSwitchingToMelee;
        this.equipmentHelper = (AIEquipmentHelper)DIContainer.get().getInstance(AIEquipmentHelper.class);
    }

    @Override
    public boolean method_6264() {
        return super.method_6264() && this.missingRangedAmmo() && this.canSwitchAmmoOrWeapon();
    }

    private boolean canSwitchAmmoOrWeapon() {
        return this.equipmentHelper.hasUsableRangedWeapon(this.armyEntity) || this.switchToMeleeWhenOut;
    }

    private boolean missingRangedAmmo() {
        return this.equipmentHelper.isUsingRanged(this.armyEntity) && !this.equipmentHelper.hasAmmoEquipped(this.armyEntity);
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.postSwapCooldownTicks = 0;
    }

    @Override
    public boolean method_6266() {
        return this.postSwapCooldownTicks > 0 || this.missingRangedAmmo() && this.canSwitchAmmoOrWeapon() || this.equipShieldWhenSwitchingToMelee && this.equipmentHelper.shouldEquipShield(this.armyEntity);
    }

    public void method_6268() {
        if (this.postSwapCooldownTicks > 0) {
            this.postSwapCooldownTicks = (byte)(this.postSwapCooldownTicks - 1);
            return;
        }
        if (this.equipmentHelper.isUsingRanged(this.armyEntity) && !this.equipmentHelper.hasAmmoForWeapon(this.armyEntity.getInventory(), this.armyEntity.method_6047())) {
            if (this.equipmentHelper.hasUsableRangedWeapon(this.armyEntity)) {
                this.equipmentHelper.equipUsableRangedWeapon(this.armyEntity);
                this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
                return;
            }
            if (this.switchToMeleeWhenOut) {
                this.equipmentHelper.equipMeleeWeapon(this.armyEntity);
                this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
                return;
            }
        }
        if (this.equipmentHelper.isUsingRanged(this.armyEntity) && !this.equipmentHelper.hasAmmoEquipped(this.armyEntity)) {
            this.equipmentHelper.equipUsableAmmo(this.armyEntity);
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
            return;
        }
        if (this.equipShieldWhenSwitchingToMelee && this.equipmentHelper.shouldEquipShield(this.armyEntity)) {
            this.equipmentHelper.equipUsableShield(this.armyEntity);
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
        }
    }
}

