/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.equipment;

import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.goal.AIEquipmentHelper;
import dev.the_fireplace.overlord.entity.ai.goal.equipment.SwapEquipmentGoal;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class SwitchToMeleeWhenCloseGoal
extends SwapEquipmentGoal {
    protected final byte switchDistance;
    protected final boolean useShield;
    protected final AIEquipmentHelper equipmentHelper;
    protected byte postSwapCooldownTicks;

    public SwitchToMeleeWhenCloseGoal(ArmyEntity armyEntity, byte switchDistance, boolean useShield) {
        super(armyEntity);
        this.switchDistance = switchDistance;
        this.useShield = useShield;
        this.equipmentHelper = (AIEquipmentHelper)DIContainer.get().getInstance(AIEquipmentHelper.class);
    }

    @Override
    public boolean method_6264() {
        if (!super.method_6264()) {
            return false;
        }
        class_1309 target = this.armyEntity.method_5968();
        if (!this.isInSwitchToMeleeDistance(target) || !this.equipmentHelper.isUsingRanged(this.armyEntity)) {
            return false;
        }
        class_11 path = this.armyEntity.method_5942().method_6349((class_1297)target, 0);
        if (path != null) {
            return true;
        }
        return this.getSquaredMaxAttackDistance(target) >= this.armyEntity.method_5858((class_1297)target);
    }

    private boolean isInSwitchToMeleeDistance(class_1309 target) {
        return target != null && this.armyEntity.method_5858((class_1297)target) < (double)(this.switchDistance * this.switchDistance);
    }

    protected double getSquaredMaxAttackDistance(class_1309 entity) {
        return this.armyEntity.method_17681() * 2.0f * this.armyEntity.method_17681() * 2.0f + entity.method_17681();
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.postSwapCooldownTicks = 0;
    }

    @Override
    public boolean method_6266() {
        return this.postSwapCooldownTicks > 0 || this.equipmentHelper.isUsingRanged(this.armyEntity) || this.useShield && this.equipmentHelper.shouldEquipShield(this.armyEntity);
    }

    public void method_6268() {
        if (this.postSwapCooldownTicks > 0) {
            this.postSwapCooldownTicks = (byte)(this.postSwapCooldownTicks - 1);
            return;
        }
        if (this.equipmentHelper.isUsingRanged(this.armyEntity)) {
            this.equipmentHelper.equipMeleeWeapon(this.armyEntity);
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
            return;
        }
        if (this.useShield && this.equipmentHelper.shouldEquipShield(this.armyEntity)) {
            this.equipmentHelper.equipUsableShield(this.armyEntity);
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
        }
    }
}

