/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.equipment;

import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.goal.AIEquipmentHelper;
import dev.the_fireplace.overlord.entity.ai.goal.equipment.SwapEquipmentGoal;
import net.minecraft.class_1297;

public class SwitchToRangedWhenFarGoal
extends SwapEquipmentGoal {
    protected final byte switchDistance;
    protected final AIEquipmentHelper equipmentHelper;
    protected byte postSwapCooldownTicks;

    public SwitchToRangedWhenFarGoal(ArmyEntity armyEntity, byte switchDistance) {
        super(armyEntity);
        this.switchDistance = switchDistance;
        this.equipmentHelper = (AIEquipmentHelper)DIContainer.get().getInstance(AIEquipmentHelper.class);
    }

    @Override
    public boolean method_6264() {
        return super.method_6264() && this.isInRangedDistance() && !this.equipmentHelper.isUsingRanged(this.armyEntity) && this.equipmentHelper.hasUsableRangedWeapon(this.armyEntity);
    }

    private boolean isInRangedDistance() {
        return this.armyEntity.method_5968() != null && this.armyEntity.method_5858((class_1297)this.armyEntity.method_5968()) > (double)(this.switchDistance * this.switchDistance);
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.postSwapCooldownTicks = 0;
    }

    @Override
    public boolean method_6266() {
        return this.postSwapCooldownTicks > 0 || !this.equipmentHelper.isUsingRanged(this.armyEntity) || !this.equipmentHelper.hasAmmoEquipped(this.armyEntity);
    }

    public void method_6268() {
        if (this.postSwapCooldownTicks > 0) {
            this.postSwapCooldownTicks = (byte)(this.postSwapCooldownTicks - 1);
            return;
        }
        if (!this.equipmentHelper.isUsingRanged(this.armyEntity)) {
            this.equipmentHelper.equipUsableRangedWeapon(this.armyEntity);
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
            return;
        }
        if (!this.equipmentHelper.hasAmmoEquipped(this.armyEntity)) {
            this.equipmentHelper.equipUsableAmmo(this.armyEntity);
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
        }
    }
}

