/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.movement;

import dev.the_fireplace.overlord.entity.ArmyEntity;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_7;

public class FollowOwnerGoal
extends class_1352 {
    private final ArmyEntity armyEntity;
    private class_1297 owner;
    private final class_4538 world;
    private final double speed;
    private final class_1408 navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private float oldWaterPathfindingPenalty;
    private final boolean leavesAllowed;

    public FollowOwnerGoal(ArmyEntity armyEntity, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
        this.armyEntity = armyEntity;
        this.world = armyEntity.field_6002;
        this.speed = speed;
        this.navigation = armyEntity.method_5942();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.leavesAllowed = leavesAllowed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        if (!(armyEntity.method_5942() instanceof class_1409) && !(armyEntity.method_5942() instanceof class_1407)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean method_6264() {
        class_1309 owner = this.armyEntity.method_6177();
        if (owner == null) {
            return false;
        }
        if (owner.method_7325()) {
            return false;
        }
        if (this.armyEntity.method_5858((class_1297)owner) < (double)(this.minDistance * this.minDistance)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean method_6266() {
        if (this.navigation.method_6357()) {
            return false;
        }
        return !(this.armyEntity.method_5858(this.owner) <= (double)(this.maxDistance * this.maxDistance));
    }

    public void method_6269() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.armyEntity.method_5944(class_7.field_18);
        this.armyEntity.method_5941(class_7.field_18, 0.0f);
    }

    public void method_6270() {
        this.owner = null;
        this.navigation.method_6340();
        this.armyEntity.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
    }

    public void method_6268() {
        this.armyEntity.method_5988().method_6226(this.owner, 10.0f, (float)this.armyEntity.method_5978());
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = 10;
            if (!this.armyEntity.method_5934() && !this.armyEntity.method_5765()) {
                double distanceToOwner = Math.sqrt(this.armyEntity.method_5858(this.owner));
                if (distanceToOwner > (double)this.maxDistance && distanceToOwner > (double)this.minDistance) {
                    this.tryTeleport();
                } else {
                    this.navigation.method_6335(this.owner, this.speed);
                }
            }
        }
    }

    private void tryTeleport() {
        class_2338 ownerPos = new class_2338(this.owner.method_19538());
        for (int i = 0; i < 10; ++i) {
            int xOffset = this.getRandomInt(-3, 3);
            int yOffset = this.getRandomInt(-1, 1);
            int zOffset = this.getRandomInt(-3, 3);
            boolean wasTeleported = this.tryTeleportTo(ownerPos.method_10263() + xOffset, ownerPos.method_10264() + yOffset, ownerPos.method_10260() + zOffset);
            if (!wasTeleported) continue;
            return;
        }
    }

    private boolean tryTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(x, y, z))) {
            return false;
        }
        this.armyEntity.method_5808((float)x + 0.5f, y, (float)z + 0.5f, this.armyEntity.method_36454(), this.armyEntity.method_36455());
        this.navigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pos) {
        class_7 pathNodeType = class_14.method_23476((class_1922)this.world, (class_2338.class_2339)new class_2338.class_2339(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        if (pathNodeType != class_7.field_12) {
            return false;
        }
        class_2680 blockState = this.world.method_8320(pos.method_10074());
        if (!this.leavesAllowed && blockState.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockPos = pos.method_10059((class_2382)new class_2338(this.armyEntity.method_19538()));
        return this.world.method_20812((class_1297)this.armyEntity, this.armyEntity.method_5829().method_996(blockPos)).toArray().length == 0;
    }

    private int getRandomInt(int min, int max) {
        return this.armyEntity.method_6051().nextInt(max - min + 1) + min;
    }
}

