/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.task;

import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.goal.task.TaskGoal;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.class_11;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class GatherItemGoal
extends TaskGoal {
    protected final short searchDistance;
    protected byte postSwapCooldownTicks;
    protected class_1542 item;
    protected class_11 path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int updateCountdownTicks;
    protected float speed = 1.0f;

    public GatherItemGoal(ArmyEntity armyEntity, short searchDistance) {
        super(armyEntity);
        this.searchDistance = searchDistance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        return super.method_6264() && this.hasEmptySlot() && this.hasNearbyItem();
    }

    protected boolean hasEmptySlot() {
        return this.inventorySearcher.hasSlotMatching(this.armyEntity.getInventory(), class_1799::method_7960);
    }

    protected boolean hasNearbyItem() {
        return this.findOldestNearbyItem() != null;
    }

    @Nullable
    private class_1542 findOldestNearbyItem() {
        return this.armyEntity.method_5770().method_8390(class_1542.class, this.armyEntity.method_5829().method_1014((double)this.searchDistance), itemEntity -> !itemEntity.method_5767() && !itemEntity.method_6977() && this.armyEntity.method_5942().method_6349((class_1297)itemEntity, 0) != null && this.armyEntity.method_18407(itemEntity.method_24515())).stream().max(Comparator.comparing(class_1542::method_6985)).orElse(null);
    }

    @Override
    public boolean method_6266() {
        return this.notInCombat() && this.hasEmptySlot() && this.hasItemTarget() && !this.armyEntity.method_5942().method_6357();
    }

    protected boolean hasItemTarget() {
        return this.item != null && this.item.method_5805() && !this.item.method_5767() && this.armyEntity.method_18407(this.item.method_24515());
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.postSwapCooldownTicks = 0;
        this.updateCountdownTicks = 0;
        this.item = this.findOldestNearbyItem();
        this.path = this.armyEntity.method_5942().method_6349((class_1297)this.item, 0);
        this.armyEntity.method_5942().method_6334(this.path, (double)this.speed);
    }

    @Override
    public void method_6270() {
        super.method_6270();
        this.armyEntity.method_5942().method_6340();
    }

    public void method_6268() {
        this.armyEntity.method_5988().method_6226((class_1297)this.item, 30.0f, 30.0f);
        double squaredDistanceToItem = this.armyEntity.method_5649(this.item.method_23317(), this.item.method_23318(), this.item.method_23321());
        this.moveToItem(squaredDistanceToItem);
        if (this.postSwapCooldownTicks > 0) {
            this.postSwapCooldownTicks = (byte)(this.postSwapCooldownTicks - 1);
            return;
        }
        if (this.swapToEmpty()) {
            return;
        }
        this.gatherItem(squaredDistanceToItem);
    }

    private void gatherItem(double squaredDistanceToItem) {
        if (squaredDistanceToItem <= this.getSquaredMaxPickupDistance(this.item) && this.armyEntity.method_6079().method_7960()) {
            Random random = this.armyEntity.method_6051();
            this.armyEntity.field_6002.method_8396(null, this.armyEntity.method_24515(), class_3417.field_15197, class_3419.field_15254, 0.2f, ((random.nextFloat() - random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.armyEntity.method_6122(class_1268.field_5810, this.item.method_6983());
            this.item.method_31472();
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
        }
    }

    protected double getSquaredMaxPickupDistance(class_1542 entity) {
        return this.armyEntity.method_17681() * 2.0f * this.armyEntity.method_17681() * 2.0f + entity.method_17681();
    }

    private void moveToItem(double squaredDistanceToCow) {
        if (this.armyEntity.method_5985().method_6369((class_1297)this.item) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || this.item.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.armyEntity.method_6051().nextFloat() < 0.05f)) {
            this.targetX = this.item.method_23317();
            this.targetY = this.item.method_23318();
            this.targetZ = this.item.method_23321();
            this.updateCountdownTicks = 4 + this.armyEntity.method_6051().nextInt(7);
            if (squaredDistanceToCow > 1024.0) {
                this.updateCountdownTicks += 10;
            } else if (squaredDistanceToCow > 256.0) {
                this.updateCountdownTicks += 5;
            }
            if (!this.armyEntity.method_5942().method_6335((class_1297)this.item, (double)this.speed)) {
                this.updateCountdownTicks += 15;
            }
        }
    }

    private boolean swapToEmpty() {
        if (!this.armyEntity.method_6079().method_7960()) {
            class_1263 inventory = this.armyEntity.getInventory();
            int emptySlot = this.inventorySearcher.getFirstSlotMatching(inventory, class_1799::method_7960);
            int offHandSlot = this.armyEntity.getOffHandSlot();
            class_1799 oldOffHandStack = inventory.method_5441(offHandSlot);
            inventory.method_5447(offHandSlot, class_1799.field_8037);
            inventory.method_5447(emptySlot, oldOffHandStack);
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
            return true;
        }
        return false;
    }
}

