/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.ai.goal.task;

import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.ai.goal.task.TaskGoal;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1430;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_4051;
import org.jetbrains.annotations.Nullable;

public class GatherMilkGoal
extends TaskGoal {
    protected static final Predicate<class_1799> EMPTY_BUCKET_MATCHER = stack -> stack.method_31574(class_1802.field_8550);
    protected final short searchDistance;
    protected byte postSwapCooldownTicks;
    protected class_1430 cow;
    protected class_11 path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int updateCountdownTicks;
    protected float speed = 1.0f;

    public GatherMilkGoal(ArmyEntity armyEntity, short searchDistance) {
        super(armyEntity);
        this.searchDistance = searchDistance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        return super.method_6264() && this.hasEmptyBucket() && this.hasNearbyCow();
    }

    protected boolean hasEmptyBucket() {
        return this.inventorySearcher.hasSlotMatching(this.armyEntity.getInventory(), EMPTY_BUCKET_MATCHER);
    }

    protected boolean hasNearbyCow() {
        return this.findNearbyCow() != null;
    }

    @Nullable
    private class_1430 findNearbyCow() {
        return (class_1430)this.armyEntity.method_5770().method_21726(class_1430.class, class_4051.method_36626().method_18420(cow -> !cow.method_6109() && !cow.method_5767() && this.armyEntity.method_5942().method_6349((class_1297)cow, 0) != null && this.armyEntity.method_18407(cow.method_24515())), (class_1309)this.armyEntity, this.armyEntity.method_23317(), this.armyEntity.method_23318(), this.armyEntity.method_23321(), this.armyEntity.method_5829().method_1014((double)this.searchDistance));
    }

    @Override
    public boolean method_6266() {
        return this.notInCombat() && this.hasEmptyBucket() && this.hasCowTarget() && !this.armyEntity.method_5942().method_6357();
    }

    protected boolean hasCowTarget() {
        return this.cow != null && this.cow.method_5805() && !this.cow.method_6109() && !this.cow.method_5767() && this.armyEntity.method_18407(this.cow.method_24515());
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.postSwapCooldownTicks = 0;
        this.updateCountdownTicks = 0;
        this.cow = this.findNearbyCow();
        this.path = this.armyEntity.method_5942().method_6349((class_1297)this.cow, 0);
        this.armyEntity.method_5942().method_6334(this.path, (double)this.speed);
    }

    @Override
    public void method_6270() {
        super.method_6270();
        this.armyEntity.method_5942().method_6340();
    }

    public void method_6268() {
        this.armyEntity.method_5988().method_6226((class_1297)this.cow, 30.0f, 30.0f);
        double squaredDistanceToCow = this.armyEntity.method_5649(this.cow.method_23317(), this.cow.method_23318(), this.cow.method_23321());
        this.moveToCow(squaredDistanceToCow);
        if (this.postSwapCooldownTicks > 0) {
            this.postSwapCooldownTicks = (byte)(this.postSwapCooldownTicks - 1);
            return;
        }
        if (this.swapToBucket()) {
            return;
        }
        this.gatherMilk(squaredDistanceToCow);
    }

    private void gatherMilk(double squaredDistanceToCow) {
        if (squaredDistanceToCow <= this.getSquaredMaxMilkDistance((class_1309)this.cow)) {
            this.armyEntity.method_6079().method_7934(1);
            if (this.armyEntity.method_6079().method_7960()) {
                this.armyEntity.method_6122(class_1268.field_5810, class_1799.field_8037);
            }
            this.armyEntity.giveItemStack(new class_1799((class_1935)class_1802.field_8103));
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
        }
    }

    protected double getSquaredMaxMilkDistance(class_1309 entity) {
        return this.armyEntity.method_17681() * 2.0f * this.armyEntity.method_17681() * 2.0f + entity.method_17681();
    }

    private void moveToCow(double squaredDistanceToCow) {
        if (this.armyEntity.method_5985().method_6369((class_1297)this.cow) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || this.cow.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.armyEntity.method_6051().nextFloat() < 0.05f)) {
            this.targetX = this.cow.method_23317();
            this.targetY = this.cow.method_23318();
            this.targetZ = this.cow.method_23321();
            this.updateCountdownTicks = 4 + this.armyEntity.method_6051().nextInt(7);
            if (squaredDistanceToCow > 1024.0) {
                this.updateCountdownTicks += 10;
            } else if (squaredDistanceToCow > 256.0) {
                this.updateCountdownTicks += 5;
            }
            if (!this.armyEntity.method_5942().method_6335((class_1297)this.cow, (double)this.speed)) {
                this.updateCountdownTicks += 15;
            }
        }
    }

    private boolean swapToBucket() {
        if (!this.armyEntity.method_6079().method_31574(class_1802.field_8550)) {
            class_1263 inventory = this.armyEntity.getInventory();
            int emptyBucketSlot = this.inventorySearcher.getFirstSlotMatching(inventory, EMPTY_BUCKET_MATCHER);
            int offHandSlot = this.armyEntity.getOffHandSlot();
            class_1799 oldOffHandStack = inventory.method_5441(offHandSlot);
            class_1799 emptyBucketStack = inventory.method_5441(emptyBucketSlot);
            inventory.method_5447(offHandSlot, emptyBucketStack);
            inventory.method_5447(emptyBucketSlot, oldOffHandStack);
            this.postSwapCooldownTicks = this.armyEntity.getEquipmentSwapTicks();
            return true;
        }
        return false;
    }
}

