/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.creation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import dev.the_fireplace.annotateddi.api.DIContainer;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.overlord.domain.blockentity.Tombstone;
import dev.the_fireplace.overlord.domain.entity.creation.SkeletonBuilder;
import dev.the_fireplace.overlord.domain.inventory.CommonPriorityMappers;
import dev.the_fireplace.overlord.domain.inventory.InventorySearcher;
import dev.the_fireplace.overlord.domain.registry.HeadBlockAugmentRegistry;
import dev.the_fireplace.overlord.entity.OwnedSkeletonEntity;
import dev.the_fireplace.overlord.entity.creation.SkeletonRecipe;
import dev.the_fireplace.overlord.util.EquipmentUtils;
import dev.the_fireplace.overlord.util.PlayerNameHelper;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3312;

@Singleton
@Implementation
public class SkeletonBuilderImpl
implements SkeletonBuilder {
    private final Collection<SkeletonRecipe> skeletonRecipes = new ConcurrentSet();

    @Override
    public boolean canBuildWithIngredients(class_1263 inventory) {
        return this.skeletonRecipes.stream().anyMatch(recipe -> recipe.hasEssentialContents(inventory));
    }

    @Override
    public OwnedSkeletonEntity build(class_1263 inventory, class_1937 world, Tombstone tombstone) {
        Optional<SkeletonRecipe> recipeOrEmpty = this.skeletonRecipes.stream().filter(filterRecipe -> filterRecipe.hasEssentialContents(inventory)).findFirst();
        if (recipeOrEmpty.isEmpty()) {
            return null;
        }
        SkeletonRecipe recipe = recipeOrEmpty.get();
        HashSet<class_1799> byproducts = new HashSet<class_1799>(recipe.processEssentialIngredients(inventory));
        OwnedSkeletonEntity entity = OwnedSkeletonEntity.create(world, tombstone.getOwner());
        if (recipe.hasMuscleContents(inventory)) {
            byproducts.addAll(recipe.processMuscleIngredients(inventory));
            entity.setHasMuscles(true);
        }
        String tombstoneName = tombstone.getNameText().trim();
        if (recipe.hasSkinContents(inventory)) {
            byproducts.addAll(recipe.processSkinIngredients(inventory));
            entity.setHasSkin(true);
            if (!tombstoneName.isEmpty() && PlayerNameHelper.VALID_NAME_REGEX.matcher(tombstoneName).matches() && recipe.hasPlayerColorContents(inventory)) {
                class_3312.method_14510((boolean)true);
                Optional profile = world.method_8503().method_3793().method_14515(tombstoneName);
                if (profile.isPresent()) {
                    byproducts.addAll(recipe.processPlayerColorIngredients(inventory));
                    entity.setSkinsuit(((GameProfile)profile.get()).getId());
                }
            }
        }
        if (!tombstoneName.isEmpty()) {
            entity.method_5665(class_2561.method_30163((String)tombstoneName));
        }
        for (class_1799 byproduct : byproducts) {
            entity.getInventory().insertStack(byproduct);
        }
        this.findAndEquipArmor(entity, inventory);
        this.gatherWeapons(entity, inventory);
        this.gatherAugment(entity, inventory);
        this.gatherExtraArmor(entity, inventory);
        return entity;
    }

    public void setSkeletonRecipes(Collection<SkeletonRecipe> skeletonRecipes) {
        this.skeletonRecipes.clear();
        this.skeletonRecipes.addAll(skeletonRecipes);
    }

    private void findAndEquipArmor(OwnedSkeletonEntity entity, class_1263 casket) {
        CommonPriorityMappers commonPriorityMappers = (CommonPriorityMappers)DIContainer.get().getInstance(CommonPriorityMappers.class);
        HashMap armorSlots = Maps.newHashMap();
        for (int slot = 0; slot < casket.method_5439(); ++slot) {
            class_1799 stack = casket.method_5438(slot);
            if (stack.method_7960() || !EquipmentUtils.isArmor(stack)) continue;
            armorSlots.put(slot, stack);
        }
        ArrayList armorByWeight = Lists.newArrayList(armorSlots.entrySet());
        armorByWeight.sort(Comparator.comparingDouble(o -> commonPriorityMappers.armor().applyAsInt((class_1799)o.getValue())));
        if (armorByWeight.isEmpty()) {
            return;
        }
        HashMap equipped = Maps.newHashMap();
        equipped.put(class_1304.field_6169, false);
        equipped.put(class_1304.field_6174, false);
        equipped.put(class_1304.field_6172, false);
        equipped.put(class_1304.field_6166, false);
        for (Map.Entry slotEntry : armorByWeight) {
            for (Map.Entry entry : Sets.newHashSet(equipped.entrySet())) {
                if (((Boolean)entry.getValue()).booleanValue() || !class_1309.method_32326((class_1799)((class_1799)slotEntry.getValue())).equals(entry.getKey())) continue;
                entity.method_5673((class_1304)entry.getKey(), (class_1799)slotEntry.getValue());
                casket.method_5447(((Integer)slotEntry.getKey()).intValue(), class_1799.field_8037);
                equipped.put((class_1304)entry.getKey(), true);
            }
            boolean skeletonIsFullyArmored = !equipped.containsValue(false);
            if (!skeletonIsFullyArmored) continue;
            break;
        }
    }

    private void gatherWeapons(OwnedSkeletonEntity entity, class_1263 casket) {
        class_1799 stack;
        int slot;
        CommonPriorityMappers commonPriorityMappers = (CommonPriorityMappers)DIContainer.get().getInstance(CommonPriorityMappers.class);
        HashMap weaponSlots = Maps.newHashMap();
        boolean equippedOffhand = false;
        boolean hasBow = false;
        boolean hasCrossbow = false;
        class_1799 crossbow = null;
        class_1799 bow = null;
        for (int slot2 = 0; slot2 < casket.method_5439(); ++slot2) {
            class_1799 stack2 = casket.method_5438(slot2);
            if (stack2.method_7960()) continue;
            if (EquipmentUtils.isMeleeWeapon(stack2)) {
                weaponSlots.put(slot2, stack2);
                continue;
            }
            if (!equippedOffhand && stack2.method_7909() instanceof class_1819) {
                entity.method_5673(class_1304.field_6171, casket.method_5441(slot2));
                equippedOffhand = true;
                continue;
            }
            if (equippedOffhand || !EquipmentUtils.isRangedWeapon(stack2)) continue;
            entity.method_5673(class_1304.field_6171, casket.method_5441(slot2));
            equippedOffhand = true;
            if (stack2.method_7909() instanceof class_1764) {
                hasCrossbow = true;
                continue;
            }
            hasBow = true;
        }
        ArrayList weaponWeights = Lists.newArrayList(weaponSlots.entrySet());
        weaponWeights.sort(Comparator.comparingInt(o -> commonPriorityMappers.weapon((class_1309)entity, entity.method_5968()).applyAsInt((class_1799)o.getValue())));
        if (!weaponWeights.isEmpty()) {
            entity.method_5673(class_1304.field_6173, casket.method_5441(((Integer)((Map.Entry)weaponWeights.get(0)).getKey()).intValue()));
        }
        for (slot = 0; slot < casket.method_5439(); ++slot) {
            stack = casket.method_5438(slot);
            if (stack.method_7960()) continue;
            if (EquipmentUtils.isMeleeWeapon(stack)) {
                entity.getInventory().insertStack(casket.method_5438(slot));
                continue;
            }
            if (!EquipmentUtils.isRangedWeapon(stack)) continue;
            entity.getInventory().insertStack(casket.method_5438(slot));
            if (stack.method_7909() instanceof class_1764) {
                hasCrossbow = true;
                crossbow = stack;
                continue;
            }
            if (!(stack.method_7909() instanceof class_1753)) continue;
            hasBow = true;
            bow = stack;
        }
        if (hasCrossbow || hasBow) {
            for (slot = 0; slot < casket.method_5439(); ++slot) {
                stack = casket.method_5438(slot);
                if (stack.method_7960()) continue;
                if (crossbow != null && EquipmentUtils.isAmmoFor(crossbow, stack)) {
                    entity.getInventory().insertStack(casket.method_5438(slot));
                    continue;
                }
                if (bow == null || !EquipmentUtils.isAmmoFor(bow, stack)) continue;
                entity.getInventory().insertStack(casket.method_5438(slot));
            }
        }
    }

    private void gatherExtraArmor(OwnedSkeletonEntity entity, class_1263 casket) {
        CommonPriorityMappers commonPriorityMappers = (CommonPriorityMappers)DIContainer.get().getInstance(CommonPriorityMappers.class);
        HashMap armorSlots = Maps.newHashMap();
        for (int slot = 0; slot < casket.method_5439(); ++slot) {
            class_1799 stack = casket.method_5438(slot);
            if (stack.method_7960() || !EquipmentUtils.isArmor(stack) && !(stack.method_7909() instanceof class_1819)) continue;
            armorSlots.put(slot, stack);
        }
        ArrayList m = Lists.newArrayList(armorSlots.entrySet());
        m.sort(Comparator.comparingInt(o -> commonPriorityMappers.armor().applyAsInt((class_1799)o.getValue())));
        Iterator iterator = armorSlots.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            entity.getInventory().insertStack(casket.method_5438(slot));
        }
    }

    private void gatherAugment(OwnedSkeletonEntity entity, class_1263 casket) {
        HeadBlockAugmentRegistry headBlockAugmentRegistry;
        InventorySearcher inventorySearcher = (InventorySearcher)DIContainer.get().getInstance(InventorySearcher.class);
        Integer slot = inventorySearcher.getFirstSlotMatching(casket, arg_0 -> SkeletonBuilderImpl.lambda$gatherAugment$5(headBlockAugmentRegistry = (HeadBlockAugmentRegistry)DIContainer.get().getInstance(HeadBlockAugmentRegistry.class), arg_0));
        if (slot == null) {
            return;
        }
        class_1799 stack = casket.method_5438(slot.intValue());
        class_1799 augmentStack = stack.method_7971(1);
        if (stack.method_7960()) {
            casket.method_5447(slot.intValue(), class_1799.field_8037);
        }
        entity.setAugmentBlock(augmentStack);
    }

    private static /* synthetic */ boolean lambda$gatherAugment$5(HeadBlockAugmentRegistry headBlockAugmentRegistry, class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item instanceof class_1747 && headBlockAugmentRegistry.has(((class_1747)item).method_7711());
    }
}

