/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.creation;

import com.google.common.collect.Maps;
import dev.the_fireplace.overlord.domain.entity.creation.SkeletonIngredient;
import dev.the_fireplace.overlord.entity.creation.SkeletonComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

public class SkeletonRecipe {
    private final SkeletonComponent essentialsComponent;
    private final SkeletonComponent musclesComponent;
    private final SkeletonComponent skinComponent;
    private final SkeletonComponent playerColorComponent;

    public SkeletonRecipe(SkeletonComponent essentialsComponent, SkeletonComponent musclesComponent, SkeletonComponent skinComponent, SkeletonComponent playerColorComponent) {
        this.essentialsComponent = essentialsComponent;
        this.musclesComponent = musclesComponent;
        this.skinComponent = skinComponent;
        this.playerColorComponent = playerColorComponent;
    }

    public boolean hasEssentialContents(class_1263 inventory) {
        return this.hasIngredients(inventory, this.essentialsComponent.getIngredients());
    }

    public Collection<class_1799> processEssentialIngredients(class_1263 inventory) {
        this.processIngredients(inventory, this.essentialsComponent.getIngredients());
        return this.essentialsComponent.getByproducts();
    }

    public boolean hasSkinContents(class_1263 inventory) {
        return this.hasIngredients(inventory, this.skinComponent.getIngredients());
    }

    public Collection<class_1799> processSkinIngredients(class_1263 inventory) {
        this.processIngredients(inventory, this.skinComponent.getIngredients());
        return this.skinComponent.getByproducts();
    }

    public boolean hasMuscleContents(class_1263 inventory) {
        return this.hasIngredients(inventory, this.musclesComponent.getIngredients());
    }

    public Collection<class_1799> processMuscleIngredients(class_1263 inventory) {
        this.processIngredients(inventory, this.musclesComponent.getIngredients());
        return this.musclesComponent.getByproducts();
    }

    public boolean hasPlayerColorContents(class_1263 inventory) {
        return this.hasIngredients(inventory, this.playerColorComponent.getIngredients());
    }

    public Collection<class_1799> processPlayerColorIngredients(class_1263 inventory) {
        this.processIngredients(inventory, this.playerColorComponent.getIngredients());
        return this.playerColorComponent.getByproducts();
    }

    private boolean hasIngredients(class_1263 inventory, Collection<SkeletonIngredient> ingredients) {
        HashMap ingredientCounts = Maps.newHashMap();
        block0: for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_7960()) continue;
            for (SkeletonIngredient ingredient : ingredients) {
                if (!ingredient.matches(stack)) continue;
                int existingCount = ingredientCounts.getOrDefault(ingredient, 0);
                ingredientCounts.put(ingredient, existingCount + stack.method_7947());
                continue block0;
            }
        }
        for (SkeletonIngredient ingredient : ingredients) {
            if (ingredientCounts.getOrDefault(ingredient, 0) >= ingredient.getRequiredCount()) continue;
            return false;
        }
        return true;
    }

    private void processIngredients(class_1263 inventory, Collection<SkeletonIngredient> ingredients) {
        Map ingredientCountsRemaining = ingredients.stream().collect(Collectors.toConcurrentMap(ingredient -> ingredient, SkeletonIngredient::getRequiredCount));
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_7960()) continue;
            for (Map.Entry ingredientEntry : ingredientCountsRemaining.entrySet()) {
                SkeletonIngredient ingredient2 = (SkeletonIngredient)ingredientEntry.getKey();
                Integer remainingCount = (Integer)ingredientEntry.getValue();
                if (remainingCount <= 0 || !ingredient2.matches(stack)) continue;
                class_1799 takenStack = stack.method_7947() > remainingCount ? stack.method_7971(remainingCount.intValue()) : inventory.method_5441(slot);
                int newRemainingCount = remainingCount - takenStack.method_7947();
                ingredientCountsRemaining.put(ingredient2, newRemainingCount);
            }
        }
    }
}

