/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entity.creation.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.the_fireplace.overlord.domain.entity.creation.SkeletonIngredient;
import dev.the_fireplace.overlord.entity.creation.ingredient.AbstractIngredient;
import dev.the_fireplace.overlord.entity.creation.ingredient.ItemIngredient;
import dev.the_fireplace.overlord.entity.creation.ingredient.TagIngredient;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public class JsonIngredient {
    public static SkeletonIngredient parse(JsonObject jsonObject) throws JsonParseException {
        AbstractIngredient ingredient;
        boolean isTag;
        boolean bl = isTag = jsonObject.has("type") && jsonObject.get("type").getAsString().equalsIgnoreCase("tag");
        if (!jsonObject.has("id")) {
            throw new JsonParseException(String.format("Missing identifier for ingredient: %s", jsonObject));
        }
        class_2960 identifier = new class_2960(jsonObject.get("id").getAsString());
        if (isTag) {
            class_3494.class_5123 itemTag = TagFactory.ITEM.create(identifier);
            ingredient = new TagIngredient((class_3494<class_1792>)itemTag);
        } else {
            Optional item = class_2378.field_11142.method_17966(identifier);
            if (item.isEmpty()) {
                throw new JsonParseException(String.format("Item not found: %s", identifier));
            }
            ingredient = new ItemIngredient((class_1792)item.get());
            if (jsonObject.has("nbt")) {
                class_2487 nbt = JsonIngredient.parseNbt(jsonObject);
                ((ItemIngredient)ingredient).setNbtCompound(nbt);
            }
        }
        if (jsonObject.has("count")) {
            int count = jsonObject.get("count").getAsInt();
            ingredient.setRequiredCount(count);
        }
        return ingredient;
    }

    public static class_2487 parseNbt(JsonObject jsonObject) {
        class_2487 nbt;
        JsonElement jsonNbtData = jsonObject.get("nbt");
        if (jsonNbtData.isJsonObject()) {
            class_2520 element = (class_2520)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, jsonNbtData);
            return (class_2487)element;
        }
        String nbtString = jsonNbtData.getAsString();
        try {
            nbt = class_2522.method_10718((String)nbtString);
        }
        catch (CommandSyntaxException exception) {
            throw new JsonParseException(String.format("Unable to read NBT for ingredient: %s", nbtString));
        }
        return nbt;
    }
}

