/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.entrypoints;

import com.google.inject.Injector;
import dev.the_fireplace.annotateddi.api.entrypoints.ClientDIModInitializer;
import dev.the_fireplace.lib.api.datagen.injectables.DataGeneratorFactory;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.blockentity.OverlordBlockEntities;
import dev.the_fireplace.overlord.client.gui.block.CasketGui;
import dev.the_fireplace.overlord.client.gui.entity.OwnedSkeletonGui;
import dev.the_fireplace.overlord.client.model.OverlordModelLayers;
import dev.the_fireplace.overlord.client.renderer.OwnedSkeletonRenderer;
import dev.the_fireplace.overlord.client.renderer.TombstoneBlockEntityRenderer;
import dev.the_fireplace.overlord.container.ContainerEquipmentSlot;
import dev.the_fireplace.overlord.datagen.BlockTagsProvider;
import dev.the_fireplace.overlord.datagen.EntityTypeTagsProvider;
import dev.the_fireplace.overlord.datagen.ItemTagsProvider;
import dev.the_fireplace.overlord.datagen.LootTablesProvider;
import dev.the_fireplace.overlord.datagen.RecipesProvider;
import dev.the_fireplace.overlord.entity.OverlordEntities;
import dev.the_fireplace.overlord.network.client.OverlordClientPacketReceivers;
import java.io.IOException;
import java.nio.file.Paths;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1707;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public final class Client
implements ClientDIModInitializer {
    public void onInitializeClient(Injector diContainer) {
        this.registerEntityRenderers();
        this.registerBlockEntityRenderers();
        this.registerGuis();
        ((OverlordClientPacketReceivers)diContainer.getInstance(OverlordClientPacketReceivers.class)).registerPacketHandlers();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Overlord.getLogger().debug("Generating data...");
            class_2403 gen = ((DataGeneratorFactory)diContainer.getInstance(DataGeneratorFactory.class)).createAdditive(Paths.get("..", "src", "main", "resources"));
            BlockTagsProvider blockTagsProvider = new BlockTagsProvider(gen);
            gen.method_10314((class_2405)blockTagsProvider);
            gen.method_10314((class_2405)new EntityTypeTagsProvider(gen));
            gen.method_10314((class_2405)new ItemTagsProvider(gen, blockTagsProvider));
            gen.method_10314((class_2405)new RecipesProvider(gen));
            gen.method_10314((class_2405)new LootTablesProvider(gen));
            try {
                gen.method_10315();
            }
            catch (IOException e) {
                Overlord.getLogger().error((Object)e);
            }
        }
    }

    private void registerEntityRenderers() {
        OverlordModelLayers.register();
        EntityRendererRegistry.register(OverlordEntities.OWNED_SKELETON_TYPE, OwnedSkeletonRenderer::new);
    }

    private void registerBlockEntityRenderers() {
        BlockEntityRendererRegistry.register(OverlordBlockEntities.TOMBSTONE_BLOCK_ENTITY, context -> new TombstoneBlockEntityRenderer());
    }

    private void registerGuis() {
        ScreenRegistry.register(OverlordBlockEntities.CASKET_SCREEN_HANDLER, (container, playerInventory, title) -> new CasketGui((class_1707)container, playerInventory));
        ScreenRegistry.register(OverlordEntities.OWNED_SKELETON_SCREEN_HANDLER, (container, playerInventory, title) -> new OwnedSkeletonGui(container.getOwner(), playerInventory, container.field_7763));
        ClientSpriteRegistryCallback.event((class_2960)class_1059.field_5275).register((atlasTexture, registry) -> registry.register(ContainerEquipmentSlot.EMPTY_WEAPON_SLOT_TEXTURE));
    }
}

