/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.impl.data;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.injectables.SaveBasedStorageReader;
import dev.the_fireplace.lib.api.io.interfaces.SaveBasedSerializable;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageWriteBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.SaveDataStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.SaveData;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.domain.data.Squads;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_5626;
import org.jetbrains.annotations.Nullable;

@Singleton
@Implementation
public final class SquadsImpl
implements Squads {
    private static final Function<UUID, ConcurrentMap<UUID, SavedSquad>> NEW_CONCURRENT_MAP = unused -> new ConcurrentHashMap();
    private static final String DATABASE = "overlord";
    private static final String TABLE = "squads";
    private final SaveDataStateManager saveDataStateManager;
    private final SaveBasedStorageReader storageReader;
    private final ConcurrentMap<UUID, ConcurrentMap<UUID, SavedSquad>> squadCache;
    private boolean cacheLoaded = false;

    @Inject
    public SquadsImpl(SaveDataStateManager saveDataStateManager, SaveBasedStorageReader storageReader) {
        this.saveDataStateManager = saveDataStateManager;
        this.storageReader = storageReader;
        this.squadCache = new ConcurrentHashMap<UUID, ConcurrentMap<UUID, SavedSquad>>();
    }

    @Override
    @Nullable
    public Squad getSquad(UUID owner, UUID squadId) {
        SavedSquad squad = (SavedSquad)this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).get(squadId);
        if (squad == null) {
            squad = new SavedSquad(squadId, owner);
            if (this.storageReader.isStored((SaveBasedSerializable)squad)) {
                squad.init();
                this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).put(squadId, squad);
            } else {
                return null;
            }
        }
        return squad;
    }

    @Override
    public Squad createNewSquad(UUID owner, String pattern, class_1799 stack, String name) {
        UUID newSquadId;
        this.ensureCachePopulated();
        do {
            newSquadId = UUID.randomUUID();
        } while (this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).containsKey(newSquadId));
        SavedSquad squad = new SavedSquad(newSquadId, owner);
        squad.init();
        squad.updatePattern(pattern, stack);
        squad.setName(name);
        this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).put(newSquadId, squad);
        return squad;
    }

    @Override
    public boolean removeSquad(UUID owner, UUID squadId) {
        this.ensureCachePopulated();
        SavedSquad squad = (SavedSquad)this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP).remove(squadId);
        if (squad != null) {
            squad.delete();
            return true;
        }
        return false;
    }

    @Override
    public Collection<? extends Squad> getSquadsWithOwner(UUID owner) {
        this.ensureCachePopulated();
        return ImmutableSet.copyOf(((ConcurrentMap)this.squadCache.get(owner)).values());
    }

    @Override
    public Collection<? extends Squad> getSquads() {
        this.ensureCachePopulated();
        ArrayList squads = new ArrayList();
        this.squadCache.values().forEach(entry -> squads.addAll(entry.values()));
        return squads;
    }

    private void ensureCachePopulated() {
        if (this.cacheLoaded) {
            return;
        }
        this.populateCache();
    }

    private void populateCache() {
        this.cacheLoaded = true;
        Overlord.getLogger().debug("Looking up Squads...");
        int uuidStringLength = UUID.randomUUID().toString().replace("-", "").length();
        Iterator databaseIdIterator = this.storageReader.getStoredIdsIterator(DATABASE, TABLE);
        while (databaseIdIterator.hasNext()) {
            String id = (String)databaseIdIterator.next();
            UUID owner = this.storedUUIDtoUUID(id.substring(0, uuidStringLength));
            UUID squadId = this.storedUUIDtoUUID(id.substring(uuidStringLength));
            ConcurrentMap<UUID, SavedSquad> cachedOwnerSquads = this.squadCache.computeIfAbsent(owner, NEW_CONCURRENT_MAP);
            if (cachedOwnerSquads.containsKey(squadId)) continue;
            SavedSquad squad = new SavedSquad(squadId, owner);
            squad.init();
            cachedOwnerSquads.put(squadId, squad);
        }
    }

    private UUID storedUUIDtoUUID(String storedUUID) {
        return UUID.fromString(storedUUID.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
    }

    private class SavedSquad
    implements Squad,
    SaveData {
        private final UUID id;
        private final UUID owner;
        private String pattern;
        private class_1799 item;
        private String name;

        private SavedSquad(UUID id, UUID owner) {
            this.id = id;
            this.owner = owner;
            this.pattern = "missing_texture";
            this.item = new class_1799((class_1935)class_2246.field_10499);
            this.name = "Missingno";
        }

        private void init() {
            SquadsImpl.this.saveDataStateManager.initializeWithAutosave((SaveData)this, (short)10);
        }

        @Override
        public UUID getSquadId() {
            return this.id;
        }

        @Override
        public UUID getOwner() {
            return this.owner;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public class_1799 getItem() {
            return this.item;
        }

        @Override
        public void updatePattern(String capeBase, class_1799 capeItem) {
            if (this.pattern.equals(capeBase) && this.item.equals(capeItem)) {
                return;
            }
            this.pattern = capeBase;
            this.item = capeItem;
            SquadsImpl.this.saveDataStateManager.markChanged((SaveData)this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
            SquadsImpl.this.saveDataStateManager.markChanged((SaveData)this);
        }

        public void readFrom(StorageReadBuffer buffer) {
            this.pattern = buffer.readString("pattern", this.pattern);
            try {
                this.item = class_1799.method_7915((class_2487)class_2522.method_10718((String)buffer.readString("item", "")));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            this.name = buffer.readString("name", this.name);
        }

        public void writeTo(StorageWriteBuffer buffer) {
            buffer.writeString("pattern", this.pattern);
            buffer.writeString("item", new class_5626().method_32288((class_2520)this.item.method_7953(new class_2487())));
            buffer.writeString("name", this.name);
        }

        public String getDatabase() {
            return SquadsImpl.DATABASE;
        }

        public String getTable() {
            return SquadsImpl.TABLE;
        }

        public String getId() {
            return this.getOwner().toString() + this.getSquadId().toString();
        }

        private void delete() {
            SquadsImpl.this.saveDataStateManager.delete((SaveData)this);
        }
    }
}

