/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.impl.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.overlord.domain.inventory.CommonPriorityMappers;
import dev.the_fireplace.overlord.util.EquipmentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1890;
import net.minecraft.class_5134;

@Singleton
@Implementation
public class CommonPriorityMappersImpl
implements CommonPriorityMappers {
    @Override
    public ToIntFunction<class_1799> armor() {
        return stack -> {
            if (stack.method_7909() instanceof class_1819) {
                return 11;
            }
            double max = 0.0;
            for (class_1304 slot : Sets.newHashSet((Object[])class_1304.values()).stream().filter(s -> s.method_5925().equals((Object)class_1304.class_1305.field_6177)).collect(Collectors.toSet())) {
                ArrayList armorMods = Lists.newArrayList((Iterable)stack.method_7926(slot).get((Object)class_5134.field_23724));
                armorMods.addAll(stack.method_7926(slot).get((Object)class_5134.field_23725));
                double totalArmorValue = 0.0;
                for (class_1322 modifier : armorMods) {
                    switch (modifier.method_6182()) {
                        case field_6328: 
                        case field_6330: {
                            totalArmorValue += modifier.method_6186();
                        }
                        case field_6331: {
                            totalArmorValue *= modifier.method_6186();
                        }
                    }
                }
                if (!(totalArmorValue > max)) continue;
                max = totalArmorValue;
            }
            return (int)max;
        };
    }

    @Override
    public ToIntFunction<class_1799> slotArmor(class_1304 slot) {
        return this.armor();
    }

    @Override
    public ToIntFunction<class_1799> weapon(class_1309 source, @Nullable class_1309 target) {
        return stack -> {
            double damage = 0.5;
            Collection attributeModifiers = stack.method_7926(class_1304.field_6173).get((Object)class_5134.field_23721);
            for (class_1322 modifier : attributeModifiers) {
                switch (modifier.method_6182()) {
                    case field_6328: {
                        damage += modifier.method_6186();
                    }
                    case field_6330: {
                        damage += 0.5 * modifier.method_6186();
                    }
                    case field_6331: {
                        damage *= modifier.method_6186();
                    }
                }
            }
            damage += (double)class_1890.method_8218((class_1799)stack, (class_1310)(target != null ? target.method_6046() : class_1310.field_6290));
            if ((int)(damage -= 0.5) > 0) {
                return (int)damage;
            }
            if (EquipmentUtils.isRangedWeapon(stack)) {
                return 1;
            }
            return -1;
        };
    }

    @Override
    public ToIntFunction<class_1799> ammo(class_1799 forWeapon) {
        return testStack -> EquipmentUtils.isAmmoFor(forWeapon, testStack) ? 1 : -1;
    }
}

