/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.impl.inventory;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.overlord.domain.inventory.InventorySearcher;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

@Implementation
public final class InventorySearcherImpl
implements InventorySearcher {
    @Override
    public boolean hasSlotMatching(class_1263 container, Predicate<class_1799> matcher) {
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            if (!matcher.test(container.method_5438(slot))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getFirstSlotMatching(class_1263 container, Predicate<class_1799> matcher) {
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            if (!matcher.test(container.method_5438(slot))) continue;
            return slot;
        }
        return null;
    }

    @Override
    public List<Integer> getSlotsMatching(class_1263 container, Predicate<class_1799> matcher) {
        IntArrayList slotList = new IntArrayList();
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            if (!matcher.test(container.method_5438(slot))) continue;
            slotList.add(slot);
        }
        return slotList;
    }

    @Override
    public Map<Integer, Integer> getSlotsMatchingByPriority(class_1263 container, Predicate<class_1799> matcher, ToIntFunction<class_1799> priorityMapper) {
        IntArrayList slotList = new IntArrayList();
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            if (!matcher.test(container.method_5438(slot))) continue;
            slotList.add(slot);
        }
        Object slotPriorityMap = new Int2IntOpenHashMap();
        IntListIterator intListIterator = slotList.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            slotPriorityMap.put(slot, priorityMapper.applyAsInt(container.method_5438(slot)));
        }
        slotPriorityMap = this.sortByValue((Map<Integer, Integer>)slotPriorityMap);
        return slotPriorityMap;
    }

    @Override
    public Map<Integer, Integer> getSlotsByPriority(class_1263 container, ToIntFunction<class_1799> priorityMapper) {
        Object slotPriorityMap = new Int2IntOpenHashMap();
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            slotPriorityMap.put(slot, priorityMapper.applyAsInt(container.method_5438(slot)));
        }
        slotPriorityMap = this.sortByValue((Map<Integer, Integer>)slotPriorityMap);
        return slotPriorityMap;
    }

    @Override
    public Map<Integer, Integer> getSlotsByPriorityOverZero(class_1263 container, ToIntFunction<class_1799> priorityMapper) {
        Object slotPriorityMap = new Int2IntOpenHashMap();
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            int priority = priorityMapper.applyAsInt(container.method_5438(slot));
            if (priority <= 0) continue;
            slotPriorityMap.put(slot, priority);
        }
        slotPriorityMap = this.sortByValue((Map<Integer, Integer>)slotPriorityMap);
        return slotPriorityMap;
    }

    @Nonnull
    private Map<Integer, Integer> sortByValue(Map<Integer, Integer> slotPriorityMap) {
        slotPriorityMap = slotPriorityMap.entrySet().stream().sorted((i1, i2) -> Integer.compare((Integer)i2.getValue(), (Integer)i1.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        return slotPriorityMap;
    }
}

