/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.impl.rule;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import dev.the_fireplace.overlord.domain.rule.SquadEligibleItems;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.entity.OwnedSkeletonEntity;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

@Implementation
public final class SquadEligibleItemsImpl
implements SquadEligibleItems {
    @Override
    public Collection<class_1799> getEligibleItems(Collection<Squad> squads, @Nullable class_1657 player, @Nullable class_1297 armyEntity) {
        ArrayList<class_1799> squadItems = new ArrayList<class_1799>();
        if (armyEntity instanceof ArmyEntity) {
            if (armyEntity instanceof OwnedSkeletonEntity) {
                squadItems.add(((OwnedSkeletonEntity)armyEntity).getAugmentBlockStack().method_7972());
            }
            class_1263 entityInventory = ((ArmyEntity)armyEntity).getInventory();
            squadItems.addAll(this.getStacksFromInventory(entityInventory));
        }
        if (player != null) {
            class_1661 playerInventory = player.method_31548();
            squadItems.addAll(this.getStacksFromInventory((class_1263)playerInventory));
        }
        for (Squad squad : squads) {
            squadItems.add(squad.getItem());
        }
        return this.reduceAndDeduplicate(squadItems);
    }

    @Override
    public class_1799 convertToSquadItem(class_1799 stack) {
        stack = stack.method_7972();
        stack.method_7939(1);
        return stack;
    }

    private Collection<class_1799> getStacksFromInventory(class_1263 inventory) {
        ArrayList<class_1799> inventoryItems = new ArrayList<class_1799>(inventory.method_5439() / 2);
        for (int slotIndex = 0; slotIndex < inventory.method_5439(); ++slotIndex) {
            class_1799 stack = inventory.method_5438(slotIndex);
            if (stack.method_7960()) continue;
            inventoryItems.add(stack.method_7972());
        }
        return inventoryItems;
    }

    private Collection<class_1799> reduceAndDeduplicate(Collection<class_1799> itemStacks) {
        ArrayList<class_1799> reducedStacks = new ArrayList<class_1799>(itemStacks.size() - 2);
        for (class_1799 stack : itemStacks) {
            if (stack.method_7960()) continue;
            class_1799 finalStack = stack = this.convertToSquadItem(stack);
            if (!reducedStacks.stream().noneMatch(reducedStack -> class_1799.method_7973((class_1799)reducedStack, (class_1799)finalStack))) continue;
            reducedStacks.add(stack);
        }
        return reducedStacks;
    }
}

