/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.impl.world;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.overlord.domain.world.BreakSpeedModifiers;
import java.util.Objects;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3486;
import net.minecraft.class_3494;

@Implementation
public final class BreakSpeedModifiersImpl
implements BreakSpeedModifiers {
    @Override
    public float applyApplicable(class_1309 entity, float baseBreakSpeed) {
        float breakSpeed = this.applyEfficiencyToBreakSpeed(entity, baseBreakSpeed);
        breakSpeed = this.applyHasteToBreakSpeed(entity, breakSpeed);
        breakSpeed = this.applyMiningFatigueToBreakSpeed(entity, breakSpeed);
        breakSpeed = this.applyWaterToBreakSpeed(entity, breakSpeed);
        breakSpeed = this.applyOffGroundToBreakSpeed(entity, breakSpeed);
        return breakSpeed;
    }

    private float applyEfficiencyToBreakSpeed(class_1309 entity, float breakSpeed) {
        if (breakSpeed > 1.0f) {
            int efficiencyLevel = class_1890.method_8234((class_1309)entity);
            class_1799 itemStack = entity.method_6047();
            if (efficiencyLevel > 0 && !itemStack.method_7960()) {
                breakSpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
            }
        }
        return breakSpeed;
    }

    private float applyHasteToBreakSpeed(class_1309 entity, float breakSpeed) {
        if (class_1292.method_5576((class_1309)entity)) {
            breakSpeed *= 1.0f + (float)(class_1292.method_5575((class_1309)entity) + 1) * 0.2f;
        }
        return breakSpeed;
    }

    private float applyMiningFatigueToBreakSpeed(class_1309 entity, float breakSpeed) {
        if (entity.method_6059(class_1294.field_5901)) {
            breakSpeed *= (switch (Objects.requireNonNull(entity.method_6112(class_1294.field_5901)).method_5578()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        return breakSpeed;
    }

    private float applyWaterToBreakSpeed(class_1309 entity, float breakSpeed) {
        if (entity.method_5777((class_3494)class_3486.field_15517) && !class_1890.method_8200((class_1309)entity)) {
            breakSpeed /= 5.0f;
        }
        return breakSpeed;
    }

    private float applyOffGroundToBreakSpeed(class_1309 entity, float breakSpeed) {
        if (!entity.method_24828()) {
            breakSpeed /= 5.0f;
        }
        return breakSpeed;
    }
}

