/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.impl.world;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.overlord.domain.world.MeleeAttackExecutor;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1508;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1890;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

@Implementation
public final class MeleeAttackExecutorImpl
implements MeleeAttackExecutor {
    @Override
    public void attack(class_1309 attacker, class_1297 target) {
        this.attack(attacker, target, 1.0f);
    }

    @Override
    public void attack(class_1309 attacker, class_1297 target, float cooldownProgress) {
        class_1799 itemStack;
        boolean isPerformingFallingAttack;
        if (!target.method_5732() || target.method_5698((class_1297)attacker)) {
            return;
        }
        float baseAttackDamage = (float)attacker.method_26825(class_5134.field_23721);
        float enchantmentAttackDamage = class_1890.method_8218((class_1799)attacker.method_6047(), (class_1310)(target instanceof class_1309 ? ((class_1309)target).method_6046() : class_1310.field_6290));
        baseAttackDamage *= 0.2f + cooldownProgress * cooldownProgress * 0.8f;
        enchantmentAttackDamage *= cooldownProgress;
        if (baseAttackDamage <= 0.0f && enchantmentAttackDamage <= 0.0f) {
            return;
        }
        boolean isNearFullStrength = cooldownProgress > 0.9f;
        int knockbackAmount = class_1890.method_8205((class_1309)attacker);
        boolean bl = isPerformingFallingAttack = isNearFullStrength && attacker.field_6017 > 0.0f && !attacker.method_24828() && !attacker.method_6101() && !attacker.method_5799() && !attacker.method_6059(class_1294.field_5919) && !attacker.method_5765() && target instanceof class_1309;
        if (isPerformingFallingAttack) {
            baseAttackDamage *= 1.5f;
        }
        baseAttackDamage += enchantmentAttackDamage;
        boolean isSweepingSword = false;
        double horizontalAcceleration = attacker.field_5973 - attacker.field_6039;
        if (isNearFullStrength && !isPerformingFallingAttack && attacker.method_24828() && horizontalAcceleration < (double)attacker.method_6029() && (itemStack = attacker.method_5998(class_1268.field_5808)).method_7909() instanceof class_1829) {
            isSweepingSword = true;
        }
        float preDamageTargetHealth = 0.0f;
        if (target instanceof class_1309) {
            preDamageTargetHealth = ((class_1309)target).method_6032();
        }
        class_243 preDamageTargetVelocity = target.method_18798();
        boolean targetDamaged = target.method_5643(class_1282.method_5511((class_1309)attacker), baseAttackDamage);
        if (targetDamaged) {
            int fireAspectLevel = this.applyFireAspectToTarget(attacker, target);
            this.knockbackTarget(attacker, target, knockbackAmount);
            if (isSweepingSword) {
                this.dealSweepDamage(attacker, target, baseAttackDamage);
            }
            this.sendPlayerTargetVelocityUpdate(target, preDamageTargetVelocity);
            if (isPerformingFallingAttack) {
                this.spawnFallingAttackIndicators(attacker, target);
            } else if (!isSweepingSword) {
                this.playStandardAttackSound(attacker, isNearFullStrength);
            }
            if (enchantmentAttackDamage > 0.0f) {
                this.spawnStandardAttackParticles(attacker, target);
            }
            attacker.method_6114(target);
            if (target instanceof class_1309) {
                class_1890.method_8210((class_1309)((class_1309)target), (class_1297)attacker);
            }
            class_1890.method_8213((class_1309)attacker, (class_1297)target);
            class_1799 mainHandStack = attacker.method_6047();
            class_1297 targetEntity = target;
            if (target instanceof class_1508) {
                targetEntity = ((class_1508)target).field_7007;
            }
            if (!attacker.field_6002.field_9236 && !mainHandStack.method_7960() && targetEntity instanceof class_1309) {
                mainHandStack.method_7909().method_7873(mainHandStack, (class_1309)targetEntity, attacker);
                if (mainHandStack.method_7960()) {
                    attacker.method_6122(class_1268.field_5808, class_1799.field_8037);
                }
            }
            if (target instanceof class_1309) {
                float damageDealt = preDamageTargetHealth - ((class_1309)target).method_6032();
                if (fireAspectLevel > 0) {
                    target.method_5639(fireAspectLevel * 4);
                }
                if (attacker.method_5770() instanceof class_3218 && damageDealt > 2.0f) {
                    this.spawnDamageIndicatorParticles((class_3218)attacker.method_5770(), target, damageDealt);
                }
            }
        } else {
            attacker.field_6002.method_8465(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14914, attacker.method_5634(), 1.0f, 1.0f);
        }
    }

    private void spawnDamageIndicatorParticles(class_3218 world, class_1297 target, double damageDealt) {
        int particleCount = (int)(damageDealt * 0.5);
        world.method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.5), target.method_23321(), particleCount, 0.1, 0.0, 0.1, 0.2);
    }

    private int applyFireAspectToTarget(class_1309 attacker, class_1297 target) {
        int fireAspectLevel = class_1890.method_8199((class_1309)attacker);
        if (fireAspectLevel > 0 && !target.method_5809()) {
            target.method_5639(1);
        }
        return fireAspectLevel;
    }

    private void playStandardAttackSound(class_1309 attacker, boolean isNearFullStrength) {
        if (isNearFullStrength) {
            attacker.field_6002.method_8465(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14840, attacker.method_5634(), 1.0f, 1.0f);
        } else {
            attacker.field_6002.method_8465(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14625, attacker.method_5634(), 1.0f, 1.0f);
        }
    }

    private void spawnFallingAttackIndicators(class_1309 attacker, class_1297 target) {
        attacker.field_6002.method_8465(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_15016, attacker.method_5634(), 1.0f, 1.0f);
        this.addCritParticles(attacker, target);
    }

    private void sendPlayerTargetVelocityUpdate(class_1297 target, class_243 targetVelocity) {
        if (target instanceof class_3222 && target.field_6037) {
            ((class_3222)target).field_13987.method_14364((class_2596)new class_2743(target));
            target.field_6037 = false;
            target.method_18799(targetVelocity);
        }
    }

    private void dealSweepDamage(class_1309 attacker, class_1297 target, float baseAttackDamage) {
        float multiplier = 1.0f + class_1890.method_8217((class_1309)attacker) * baseAttackDamage;
        List entitiesInSweepRange = attacker.field_6002.method_18467(class_1309.class, target.method_5829().method_1009(1.0, 0.25, 1.0));
        for (class_1309 livingEntity : entitiesInSweepRange) {
            if (livingEntity instanceof class_1531 && ((class_1531)livingEntity).method_6912() || attacker.method_5722((class_1297)livingEntity) || livingEntity == target || livingEntity == attacker || !(attacker.method_5858((class_1297)livingEntity) < 9.0)) continue;
            livingEntity.method_6005((double)0.4f, (double)class_3532.method_15374((float)(attacker.method_36454() * (float)Math.PI / 180.0f)), (double)(-class_3532.method_15362((float)(attacker.method_36454() * (float)Math.PI / 180.0f))));
            livingEntity.method_5643(class_1282.method_5511((class_1309)attacker), multiplier);
        }
        attacker.field_6002.method_8465(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14706, attacker.method_5634(), 1.0f, 1.0f);
        this.showSweepParticles(attacker);
    }

    private void knockbackTarget(class_1309 attacker, class_1297 target, int knockback) {
        if (knockback > 0) {
            if (target instanceof class_1309) {
                ((class_1309)target).method_6005((double)((float)knockback * 0.5f), (double)class_3532.method_15374((float)(attacker.method_36454() * (float)Math.PI / 180.0f)), (double)(-class_3532.method_15362((float)(attacker.method_36454() * (float)Math.PI / 180.0f))));
            } else {
                target.method_5762((double)(-class_3532.method_15374((float)(attacker.method_36454() * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(class_3532.method_15362((float)(attacker.method_36454() * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
            }
            attacker.method_18799(attacker.method_18798().method_18805(0.6, 1.0, 0.6));
            attacker.method_5728(false);
        }
    }

    public void addCritParticles(class_1309 attacker, class_1297 target) {
        if (attacker.field_6002 instanceof class_3218) {
            ((class_3218)attacker.field_6002).method_14178().method_18751((class_1297)attacker, (class_2596)new class_2616(target, 4));
        }
    }

    public void spawnStandardAttackParticles(class_1309 attacker, class_1297 target) {
        if (attacker.field_6002 instanceof class_3218) {
            ((class_3218)attacker.field_6002).method_14178().method_18751((class_1297)attacker, (class_2596)new class_2616(target, 5));
        }
    }

    public void showSweepParticles(class_1309 attacker) {
        double d = -class_3532.method_15374((float)(attacker.method_36454() * (float)Math.PI / 180.0f));
        double e = class_3532.method_15362((float)(attacker.method_36454() * (float)Math.PI / 180.0f));
        if (attacker.field_6002 instanceof class_3218) {
            ((class_3218)attacker.field_6002).method_14199((class_2394)class_2398.field_11227, attacker.method_23317() + d, attacker.method_23323(0.5), attacker.method_23321() + e, 0, d, 0.0, e, 0.0);
        }
    }
}

