/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.network.client.receiver;

import dev.the_fireplace.lib.api.network.interfaces.ClientPacketReceiver;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.domain.client.OrdersGuiFactory;
import dev.the_fireplace.overlord.domain.entity.OrderableEntity;
import dev.the_fireplace.overlord.network.ServerToClientPacketIDs;
import java.util.Objects;
import javax.inject.Inject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public final class OpenOrdersGUIPacketReceiver
implements ClientPacketReceiver {
    private final OrdersGuiFactory ordersGuiFactory;

    @Inject
    public OpenOrdersGUIPacketReceiver(OrdersGuiFactory ordersGuiFactory) {
        this.ordersGuiFactory = ordersGuiFactory;
    }

    public class_2960 getId() {
        return ServerToClientPacketIDs.OPEN_ORDERS_GUI;
    }

    public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (client.field_1687 == null) {
            Overlord.getLogger().error("Received open orders packet with null client world!");
            return;
        }
        class_1297 entity = client.field_1687.method_8469(buf.readInt());
        if (!(entity instanceof OrderableEntity)) {
            Overlord.getLogger().info("Received open orders packet for non orderable entity: {}", (Object)Objects.toString(entity));
            return;
        }
        class_2487 aiCompound = buf.method_10798();
        if (aiCompound == null) {
            Overlord.getLogger().error("Received open orders packet with null ai settings!");
            return;
        }
        ((OrderableEntity)entity).updateAISettings(aiCompound);
        class_437 parentScreen = client.field_1755;
        if (parentScreen == null) {
            Overlord.getLogger().warn("Parent screen is null, attempting to open orders GUI anyways!");
        }
        client.method_20493(() -> client.method_1507(this.ordersGuiFactory.build(parentScreen, (OrderableEntity)entity)));
    }
}

