/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.network.client.receiver;

import dev.the_fireplace.lib.api.network.interfaces.ClientPacketReceiver;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.client.impl.data.ClientSquads;
import dev.the_fireplace.overlord.client.util.SquadDeserialization;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import dev.the_fireplace.overlord.network.ServerToClientPacketIDs;
import java.util.Collection;
import java.util.UUID;
import javax.inject.Inject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

@Environment(value=EnvType.CLIENT)
public final class SyncSquadsPacketReceiver
implements ClientPacketReceiver {
    private final ClientSquads clientSquads;

    @Inject
    public SyncSquadsPacketReceiver(ClientSquads clientSquads) {
        this.clientSquads = clientSquads;
    }

    public class_2960 getId() {
        return ServerToClientPacketIDs.SYNC_SQUADS;
    }

    public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_2487 squadCompound = buf.method_10798();
        if (squadCompound == null) {
            Overlord.getLogger().error("Received sync squads packet with null squads!");
            return;
        }
        UUID owner = null;
        if (buf.isReadable()) {
            owner = buf.method_10790();
        }
        Collection<? extends Squad> squads = SquadDeserialization.collectionFromNbt(squadCompound);
        if (owner != null) {
            this.clientSquads.setSquadsFromOwner(owner, squads);
        } else {
            this.clientSquads.setSquads(squads);
        }
    }
}

