/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.network.server.receiver;

import dev.the_fireplace.lib.api.network.interfaces.ServerPacketReceiver;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.domain.entity.OrderableEntity;
import dev.the_fireplace.overlord.domain.entity.Ownable;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import dev.the_fireplace.overlord.network.ServerToClientPacketIDs;
import dev.the_fireplace.overlord.network.server.builder.OpenOrdersGUIBufferBuilder;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class GetOrdersPacketReceiver
implements ServerPacketReceiver {
    public class_2960 getId() {
        return ClientToServerPacketIDs.GET_ORDERS;
    }

    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        class_1297 entity = player.method_5770().method_8469(entityId);
        if (!(entity instanceof OrderableEntity)) {
            Overlord.getLogger().info("Entity is not orderable: {}", (Object)Objects.toString(entity));
            return;
        }
        if (entity instanceof Ownable && !Objects.equals(((Ownable)entity).method_6139(), player.method_5667())) {
            Overlord.getLogger().warn("Get Orders packet received with wrong player ID, expected {} and got {}.", (Object)((Ownable)entity).method_6139(), (Object)player.method_5667());
            return;
        }
        class_2540 ordersPacketBuffer = OpenOrdersGUIBufferBuilder.build(entityId, ((OrderableEntity)entity).getAISettings());
        responseSender.sendPacket(ServerToClientPacketIDs.OPEN_ORDERS_GUI, ordersPacketBuffer);
    }
}

