/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.network.server.receiver;

import dev.the_fireplace.lib.api.network.interfaces.ServerPacketReceiver;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.domain.data.Squads;
import dev.the_fireplace.overlord.domain.entity.Ownable;
import dev.the_fireplace.overlord.entity.ArmyEntity;
import dev.the_fireplace.overlord.item.OrdersWandItem;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class SetSquadPacketReceiver
implements ServerPacketReceiver {
    private final Squads squads;

    @Inject
    public SetSquadPacketReceiver(Squads squads) {
        this.squads = squads;
    }

    public class_2960 getId() {
        return ClientToServerPacketIDs.SET_SQUAD;
    }

    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        boolean isWandSquad;
        UUID squadId = buf.method_10790();
        int entityId = buf.readInt();
        boolean bl = isWandSquad = entityId == -1;
        if (isWandSquad) {
            this.setWandSquad(player, squadId);
        } else {
            this.setEntitySquad(player, squadId, entityId);
        }
    }

    private void setWandSquad(class_3222 player, UUID squadId) {
        class_1799 wandStack = OrdersWandItem.getActiveWand((class_1657)player);
        if (!wandStack.method_7960()) {
            wandStack.method_7948().method_25927("squad", squadId);
        }
    }

    private void setEntitySquad(class_3222 player, UUID squadId, int entityId) {
        class_1297 entity = player.method_5770().method_8469(entityId);
        if (!(entity instanceof ArmyEntity)) {
            Overlord.getLogger().info("Entity is not an army entity: {}", (Object)Objects.toString(entity));
            return;
        }
        if (!Objects.equals(((Ownable)entity).method_6139(), player.method_5667())) {
            Overlord.getLogger().warn("Set Squad packet received with wrong player ID, expected {} and got {}.", (Object)((Ownable)entity).method_6139(), (Object)player.method_5667());
            return;
        }
        ((ArmyEntity)entity).setSquad(squadId);
    }
}

