/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.network.server.receiver;

import dev.the_fireplace.lib.api.network.interfaces.ServerPacketReceiver;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.domain.entity.OrderableEntity;
import dev.the_fireplace.overlord.domain.entity.Ownable;
import dev.the_fireplace.overlord.item.OrdersWandItem;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class UpdateAIPacketReceiver
implements ServerPacketReceiver {
    public class_2960 getId() {
        return ClientToServerPacketIDs.UPDATE_AI;
    }

    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        boolean isWandUpdate;
        int entityId = buf.readInt();
        class_2487 aiTag = buf.method_10798();
        boolean bl = isWandUpdate = entityId == -1;
        if (isWandUpdate) {
            this.updateWandAISettings(player, aiTag);
        } else {
            this.updateEntityAISettings(player, entityId, aiTag);
        }
    }

    private void updateWandAISettings(class_3222 player, class_2487 aiTag) {
        class_1799 wandStack = OrdersWandItem.getActiveWand((class_1657)player);
        if (!wandStack.method_7960()) {
            wandStack.method_7948().method_10566("ai", (class_2520)aiTag);
        }
    }

    private void updateEntityAISettings(class_3222 player, int entityId, class_2487 aiTag) {
        class_1297 entity = player.method_5770().method_8469(entityId);
        if (!(entity instanceof OrderableEntity)) {
            Overlord.getLogger().info("Entity is not orderable: {}", (Object)Objects.toString(entity));
            return;
        }
        if (entity instanceof Ownable && !Objects.equals(((Ownable)entity).method_6139(), player.method_5667())) {
            Overlord.getLogger().warn("Save AI packet received with wrong player ID, expected {} and got {}.", (Object)((Ownable)entity).method_6139(), (Object)player.method_5667());
            return;
        }
        if (aiTag != null) {
            ((OrderableEntity)entity).updateAISettings(aiTag);
        } else {
            Overlord.getLogger().error("No settings found in packet.");
        }
    }
}

