/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.overlord.network.server.receiver;

import com.google.common.collect.Lists;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.TextStyles;
import dev.the_fireplace.lib.api.network.interfaces.ServerPacketReceiver;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import dev.the_fireplace.overlord.Overlord;
import dev.the_fireplace.overlord.domain.data.SquadPatterns;
import dev.the_fireplace.overlord.domain.data.Squads;
import dev.the_fireplace.overlord.domain.data.objects.Squad;
import dev.the_fireplace.overlord.domain.rule.SquadEligibleItems;
import dev.the_fireplace.overlord.network.ClientToServerPacketIDs;
import dev.the_fireplace.overlord.network.ServerToClientPacketIDs;
import dev.the_fireplace.overlord.network.server.builder.SquadUpdateFailedBufferBuilder;
import dev.the_fireplace.overlord.network.server.builder.SquadUpdatedBufferBuilder;
import dev.the_fireplace.overlord.network.server.builder.SyncSquadsBufferBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

@Implementation
public final class UpdateSquadPacketReceiver
implements ServerPacketReceiver {
    private final Squads squads;
    private final SquadPatterns squadPatterns;
    private final EmptyUUID emptyUUID;
    private final TextStyles textStyles;
    private final SquadEligibleItems squadEligibleItems;

    @Inject
    public UpdateSquadPacketReceiver(Squads squads, SquadPatterns squadPatterns, EmptyUUID emptyUUID, TextStyles textStyles, SquadEligibleItems squadEligibleItems) {
        this.squads = squads;
        this.squadPatterns = squadPatterns;
        this.emptyUUID = emptyUUID;
        this.textStyles = textStyles;
        this.squadEligibleItems = squadEligibleItems;
    }

    public class_2960 getId() {
        return ClientToServerPacketIDs.UPDATE_SQUAD;
    }

    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        Squad updatedSquad;
        UUID squadId = buf.method_10790();
        boolean isNewSquad = this.emptyUUID.is(squadId);
        String squadName = buf.method_19772();
        String pattern = buf.method_19772();
        class_1799 item = this.squadEligibleItems.convertToSquadItem(buf.method_10819());
        Integer skeletonId = null;
        if (buf.isReadable()) {
            skeletonId = buf.readInt();
        }
        if (squadName.isBlank() || pattern.isBlank() || item.method_7960()) {
            this.logInvalidPacketWarning(player);
            return;
        }
        UUID owner = player.method_5667();
        Squad existingSquad = this.squads.getSquad(owner, squadId);
        List<class_2561> errors = this.getErrors(squadId, isNewSquad, pattern, item, player, existingSquad != null, skeletonId != null ? player.field_6002.method_8469(skeletonId.intValue()) : null);
        if (!errors.isEmpty()) {
            responseSender.sendPacket(ServerToClientPacketIDs.SQUAD_UPDATE_FAILED, SquadUpdateFailedBufferBuilder.build(errors));
            return;
        }
        if (isNewSquad) {
            updatedSquad = this.squads.createNewSquad(owner, pattern, item, squadName);
        } else {
            updatedSquad = existingSquad;
            if (updatedSquad == null) {
                throw new IllegalStateException("Existing squad is missing with no error.");
            }
            updatedSquad.updatePattern(pattern, item);
            updatedSquad.setName(squadName);
        }
        responseSender.sendPacket(ServerToClientPacketIDs.SQUAD_UPDATED, SquadUpdatedBufferBuilder.build(updatedSquad));
        server.method_3760().method_14581(responseSender.createPacket(ServerToClientPacketIDs.SYNC_SQUADS, SyncSquadsBufferBuilder.buildForOneOwner(owner, this.squads.getSquadsWithOwner(owner))));
    }

    private List<class_2561> getErrors(UUID squadId, boolean isNewSquad, String pattern, class_1799 item, class_3222 owner, boolean squadExists, @Nullable class_1297 armyEntity) {
        ArrayList<class_2561> errors = new ArrayList<class_2561>();
        if (isNewSquad) {
            boolean bl = isPatternTaken = !this.squadPatterns.isPatternUnused(pattern, item);
            if (isPatternTaken) {
                errors.add(this.getStyledError("gui.overlord.create_squad.pattern_taken"));
            }
        } else {
            if (!squadExists) {
                errors.add(this.getStyledError("gui.overlord.create_squad.missing_squad"));
            }
            boolean bl = isPatternTaken = !this.squadPatterns.isPatternUnusedByOtherSquads(pattern, item, owner.method_5667(), squadId);
            if (isPatternTaken) {
                errors.add(this.getStyledError("gui.overlord.create_squad.pattern_taken"));
            }
        }
        if (!this.squadPatterns.canUsePattern(owner.method_5667(), pattern)) {
            errors.add(this.getStyledError("gui.overlord.create_squad.locked_pattern"));
        }
        boolean isEligibleToUseItem = false;
        Collection<class_1799> eligibleItems = this.squadEligibleItems.getEligibleItems(Lists.newArrayList(this.squads.getSquadsWithOwner(owner.method_5667())), (class_1657)owner, armyEntity);
        for (class_1799 eligibleStack : eligibleItems) {
            if (!class_1799.method_7973((class_1799)eligibleStack, (class_1799)item)) continue;
            isEligibleToUseItem = true;
            break;
        }
        if (!isEligibleToUseItem) {
            errors.add(this.getStyledError("gui.overlord.create_squad.locked_item"));
        }
        return errors;
    }

    private class_2561 getStyledError(String translationKey) {
        return new class_2588(translationKey).method_10862(this.textStyles.red());
    }

    private void logInvalidPacketWarning(class_3222 player) {
        Overlord.getLogger().warn("Invalid squad data received from player {}", (Object)player.method_5667());
    }
}

