package gen.libmpv

import dev.toastbits.kjna.runtime.KJnaFunctionPointer
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import kjna.enum.mpv_event_id
import kjna.enum.mpv_format
import kjna.struct.mpv_event
import kjna.struct.mpv_handle
import kjna.struct.mpv_node

expect class LibMpv() {
    fun mpv_client_api_version(): ULong
    fun mpv_error_string(error: Int): String?
    fun mpv_free(data: KJnaPointer?)
    fun mpv_client_name(ctx: KJnaTypedPointer<mpv_handle>?): String?
    fun mpv_client_id(ctx: KJnaTypedPointer<mpv_handle>?): Long
    fun mpv_create(): KJnaTypedPointer<mpv_handle>?
    fun mpv_initialize(ctx: KJnaTypedPointer<mpv_handle>?): Int
    fun mpv_destroy(ctx: KJnaTypedPointer<mpv_handle>?)
    fun mpv_terminate_destroy(ctx: KJnaTypedPointer<mpv_handle>?)
    fun mpv_create_client(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): KJnaTypedPointer<mpv_handle>?
    fun mpv_create_weak_client(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): KJnaTypedPointer<mpv_handle>?
    fun mpv_load_config_file(ctx: KJnaTypedPointer<mpv_handle>?, filename: String?): Int
    fun mpv_get_time_ns(ctx: KJnaTypedPointer<mpv_handle>?): Long
    fun mpv_get_time_us(ctx: KJnaTypedPointer<mpv_handle>?): Long
    fun mpv_free_node_contents(node: KJnaTypedPointer<mpv_node>?)
    fun mpv_set_option(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, format: mpv_format, data: KJnaPointer?): Int
    fun mpv_set_option_string(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, data: String?): Int
    fun mpv_command(ctx: KJnaTypedPointer<mpv_handle>?, args: KJnaTypedPointer<String>?): Int
    fun mpv_command_node(ctx: KJnaTypedPointer<mpv_handle>?, args: KJnaTypedPointer<mpv_node>?, result: KJnaTypedPointer<mpv_node>?): Int
    fun mpv_command_ret(ctx: KJnaTypedPointer<mpv_handle>?, args: KJnaTypedPointer<String>?, result: KJnaTypedPointer<mpv_node>?): Int
    fun mpv_command_string(ctx: KJnaTypedPointer<mpv_handle>?, args: String?): Int
    fun mpv_command_async(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, args: KJnaTypedPointer<String>?): Int
    fun mpv_command_node_async(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, args: KJnaTypedPointer<mpv_node>?): Int
    fun mpv_abort_async_command(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong)
    fun mpv_set_property(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, format: mpv_format, data: KJnaPointer?): Int
    fun mpv_set_property_string(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, data: String?): Int
    fun mpv_del_property(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): Int
    fun mpv_set_property_async(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, name: String?, format: mpv_format, data: KJnaPointer?): Int
    fun mpv_get_property(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, format: mpv_format, data: KJnaPointer?): Int
    fun mpv_get_property_string(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): String?
    fun mpv_get_property_osd_string(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): String?
    fun mpv_get_property_async(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, name: String?, format: mpv_format): Int
    fun mpv_observe_property(mpv: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, name: String?, format: mpv_format): Int
    fun mpv_unobserve_property(mpv: KJnaTypedPointer<mpv_handle>?, registered_reply_userdata: ULong): Int
    fun mpv_event_name(event: mpv_event_id): String?
    fun mpv_event_to_node(dst: KJnaTypedPointer<mpv_node>?, src: KJnaTypedPointer<mpv_event>?): Int
    fun mpv_request_event(ctx: KJnaTypedPointer<mpv_handle>?, event: mpv_event_id, enable: Int): Int
    fun mpv_request_log_messages(ctx: KJnaTypedPointer<mpv_handle>?, min_level: String?): Int
    fun mpv_wait_event(ctx: KJnaTypedPointer<mpv_handle>?, timeout: Double): KJnaTypedPointer<mpv_event>?
    fun mpv_wakeup(ctx: KJnaTypedPointer<mpv_handle>?)
    fun mpv_set_wakeup_callback(ctx: KJnaTypedPointer<mpv_handle>?, cb: KJnaFunctionPointer?, d: KJnaPointer?)
    fun mpv_wait_async_requests(ctx: KJnaTypedPointer<mpv_handle>?)
    fun mpv_hook_add(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, name: String?, priority: Int): Int
    fun mpv_hook_continue(ctx: KJnaTypedPointer<mpv_handle>?, id: ULong): Int
    fun mpv_get_wakeup_pipe(ctx: KJnaTypedPointer<mpv_handle>?): Int
    
    companion object {
        fun isAvailable(): Boolean
    }
}
