package gen.libappindicator

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaFunctionPointer
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.KJnaVarargList
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import java.lang.foreign.Arena
import java.lang.foreign.Linker
import java.lang.foreign.MemorySegment
import kjna.enum.AppIndicatorCategory
import kjna.enum.AppIndicatorStatus
import kjna.enum.AtkRole
import kjna.enum.GConnectFlags
import kjna.enum.GIOCondition
import kjna.enum.GLogLevelFlags
import kjna.enum.GLogWriterOutput
import kjna.enum.GMainContextFlags
import kjna.enum.GSignalFlags
import kjna.enum.GSignalMatchType
import kjna.enum.GdkEventMask
import kjna.enum.GdkGravity
import kjna.enum.GdkModifierIntent
import kjna.enum.GdkModifierType
import kjna.enum.GtkAccelFlags
import kjna.enum.GtkAlign
import kjna.enum.GtkDirectionType
import kjna.enum.GtkIconSize
import kjna.enum.GtkOrientation
import kjna.enum.GtkSizeRequestMode
import kjna.enum.GtkStateFlags
import kjna.enum.GtkStateType
import kjna.enum.GtkTextDirection
import kjna.enum.fromJvm
import kjna.enum.toJvm
import kjna.struct._AppIndicator
import kjna.struct._AppIndicatorClass
import kjna.struct._AtkObject
import kjna.struct._AtkRelationSet
import kjna.struct._GActionGroup
import kjna.struct._GBytes
import kjna.struct._GClosure
import kjna.struct._GClosureNotifyData
import kjna.struct._GCond
import kjna.struct._GData
import kjna.struct._GError
import kjna.struct._GList
import kjna.struct._GLogField
import kjna.struct._GMainContext
import kjna.struct._GMainLoop
import kjna.struct._GMenuModel
import kjna.struct._GMenuModelPrivate
import kjna.struct._GObject
import kjna.struct._GObjectClass
import kjna.struct._GOptionEntry
import kjna.struct._GOptionGroup
import kjna.struct._GParamSpec
import kjna.struct._GPollFD
import kjna.struct._GPtrArray
import kjna.struct._GSList
import kjna.struct._GSignalInvocationHint
import kjna.struct._GSignalQuery
import kjna.struct._GSource
import kjna.struct._GSourceCallbackFuncs
import kjna.struct._GSourceFuncs
import kjna.struct._GSourcePrivate
import kjna.struct._GTimeVal
import kjna.struct._GTypeClass
import kjna.struct._GTypeInstance
import kjna.struct._GValue
import kjna.struct._GVariant
import kjna.struct._GdkAtom
import kjna.struct._GdkDevice
import kjna.struct._GdkDisplay
import kjna.struct._GdkDragContext
import kjna.struct._GdkEventAny
import kjna.struct._GdkEventButton
import kjna.struct._GdkEventConfigure
import kjna.struct._GdkEventCrossing
import kjna.struct._GdkEventDND
import kjna.struct._GdkEventExpose
import kjna.struct._GdkEventFocus
import kjna.struct._GdkEventGrabBroken
import kjna.struct._GdkEventKey
import kjna.struct._GdkEventMotion
import kjna.struct._GdkEventOwnerChange
import kjna.struct._GdkEventPadAxis
import kjna.struct._GdkEventPadButton
import kjna.struct._GdkEventPadGroupMode
import kjna.struct._GdkEventProperty
import kjna.struct._GdkEventProximity
import kjna.struct._GdkEventScroll
import kjna.struct._GdkEventSelection
import kjna.struct._GdkEventSequence
import kjna.struct._GdkEventSetting
import kjna.struct._GdkEventTouch
import kjna.struct._GdkEventTouchpadPinch
import kjna.struct._GdkEventTouchpadSwipe
import kjna.struct._GdkEventVisibility
import kjna.struct._GdkEventWindowState
import kjna.struct._GdkFrameClock
import kjna.struct._GdkMonitor
import kjna.struct._GdkPixbuf
import kjna.struct._GdkRGBA
import kjna.struct._GdkScreen
import kjna.struct._GdkVisual
import kjna.struct._GdkWindow
import kjna.struct._GtkAccelGroup
import kjna.struct._GtkAccelGroupPrivate
import kjna.struct._GtkBin
import kjna.struct._GtkBinPrivate
import kjna.struct._GtkClipboard
import kjna.struct._GtkContainer
import kjna.struct._GtkContainerPrivate
import kjna.struct._GtkMenu
import kjna.struct._GtkMenuItem
import kjna.struct._GtkMenuItemPrivate
import kjna.struct._GtkMenuPrivate
import kjna.struct._GtkMenuShell
import kjna.struct._GtkMenuShellPrivate
import kjna.struct._GtkRequisition
import kjna.struct._GtkSettings
import kjna.struct._GtkSettingsPrivate
import kjna.struct._GtkStyleContext
import kjna.struct._GtkStyleContextPrivate
import kjna.struct._GtkWidget
import kjna.struct._GtkWidgetClass
import kjna.struct._GtkWidgetClassPrivate
import kjna.struct._GtkWidgetPath
import kjna.struct._GtkWidgetPrivate
import kjna.struct._GtkWindow
import kjna.struct._GtkWindowPrivate
import kjna.struct._PangoContext
import kjna.struct._PangoFontDescription
import kjna.struct._PangoFontMap
import kjna.struct._PangoLanguage
import kjna.struct._PangoLayout
import kjna.struct._cairo
import kjna.struct._cairo_font_options
import kjna.struct._cairo_rectangle_int
import kjna.struct._cairo_region
import kjna.union._GMutex
import kjna.union._GdkEvent

actual class LibAppIndicator {
    private val _linker: Linker by lazy { Linker.nativeLinker() }
    private val _function_arena: Arena by lazy { Arena.ofAuto() }
    
    init {
        KJnaAllocationCompanion.registerAllocationCompanion(_AppIndicator.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_AppIndicator.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_AppIndicatorClass.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_AppIndicatorClass.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_AtkObject.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_AtkRelationSet.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GActionGroup.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GBytes.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GClosure.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GClosureNotifyData.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GCond.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GData.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GError.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GList.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GLogField.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GMainContext.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GMainLoop.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GMenuModel.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GMenuModelPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GObject.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GObjectClass.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GOptionEntry.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GOptionGroup.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GParamSpec.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GPollFD.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GPtrArray.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GSList.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GSignalInvocationHint.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GSignalQuery.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GSource.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GSourceCallbackFuncs.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GSourceFuncs.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GSourcePrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GTimeVal.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GTypeClass.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GTypeInstance.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GValue.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GVariant.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkAtom.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkDevice.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkDisplay.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkDragContext.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventAny.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventButton.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventConfigure.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventCrossing.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventDND.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventExpose.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventFocus.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventGrabBroken.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventKey.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventMotion.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventOwnerChange.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventPadAxis.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventPadButton.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventPadGroupMode.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventProperty.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventProximity.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventScroll.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventSelection.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventSequence.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventSetting.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventTouch.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventTouchpadPinch.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventTouchpadSwipe.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventVisibility.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkEventWindowState.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkFrameClock.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkMonitor.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkPixbuf.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkRGBA.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkScreen.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkVisual.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GdkWindow.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkAccelGroup.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkAccelGroupPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkBin.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkBinPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkClipboard.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkContainer.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkContainerPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkMenu.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkMenuItem.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkMenuItemPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkMenuPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkMenuShell.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkMenuShellPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkRequisition.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkSettings.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkSettingsPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkStyleContext.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkStyleContextPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkWidget.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkWidgetClass.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkWidgetClassPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkWidgetPath.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkWidgetPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkWindow.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_GtkWindowPrivate.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_PangoContext.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_PangoFontDescription.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_PangoFontMap.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_PangoLanguage.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_PangoLayout.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_cairo.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_cairo_font_options.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_cairo_rectangle_int.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(_cairo_region.Companion)
    }

    actual fun app_indicator_get_type(): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_type().toULong()
    }
    actual fun app_indicator_new(id: String?, icon_name: String?, category: AppIndicatorCategory): KJnaTypedPointer<_AppIndicator>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_new(id?.memorySegment(_arena), icon_name?.memorySegment(_arena), category.toJvm())?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun app_indicator_new_with_path(id: String?, icon_name: String?, category: AppIndicatorCategory, icon_theme_path: String?): KJnaTypedPointer<_AppIndicator>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_new_with_path(id?.memorySegment(_arena), icon_name?.memorySegment(_arena), category.toJvm(), icon_theme_path?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun app_indicator_set_status(self: KJnaTypedPointer<_AppIndicator>?, status: AppIndicatorStatus) {
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_status(self?.pointer ?: MemorySegment.NULL, status.toJvm())
    }
    actual fun app_indicator_set_attention_icon(self: KJnaTypedPointer<_AppIndicator>?, icon_name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_attention_icon(self?.pointer ?: MemorySegment.NULL, icon_name?.memorySegment(_arena))
    }
    actual fun app_indicator_set_attention_icon_full(self: KJnaTypedPointer<_AppIndicator>?, icon_name: String?, icon_desc: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_attention_icon_full(self?.pointer ?: MemorySegment.NULL, icon_name?.memorySegment(_arena), icon_desc?.memorySegment(_arena))
    }
    actual fun app_indicator_set_menu(self: KJnaTypedPointer<_AppIndicator>?, menu: KJnaTypedPointer<_GtkMenu>?) {
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_menu(self?.pointer ?: MemorySegment.NULL, menu?.pointer ?: MemorySegment.NULL)
    }
    actual fun app_indicator_set_icon(self: KJnaTypedPointer<_AppIndicator>?, icon_name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_icon(self?.pointer ?: MemorySegment.NULL, icon_name?.memorySegment(_arena))
    }
    actual fun app_indicator_set_icon_full(self: KJnaTypedPointer<_AppIndicator>?, icon_name: String?, icon_desc: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_icon_full(self?.pointer ?: MemorySegment.NULL, icon_name?.memorySegment(_arena), icon_desc?.memorySegment(_arena))
    }
    actual fun app_indicator_set_label(self: KJnaTypedPointer<_AppIndicator>?, label: String?, guide: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_label(self?.pointer ?: MemorySegment.NULL, label?.memorySegment(_arena), guide?.memorySegment(_arena))
    }
    actual fun app_indicator_set_icon_theme_path(self: KJnaTypedPointer<_AppIndicator>?, icon_theme_path: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_icon_theme_path(self?.pointer ?: MemorySegment.NULL, icon_theme_path?.memorySegment(_arena))
    }
    actual fun app_indicator_set_ordering_index(self: KJnaTypedPointer<_AppIndicator>?, ordering_index: UInt) {
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_ordering_index(self?.pointer ?: MemorySegment.NULL, ordering_index.toInt())
    }
    actual fun app_indicator_set_secondary_activate_target(self: KJnaTypedPointer<_AppIndicator>?, menuitem: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_secondary_activate_target(self?.pointer ?: MemorySegment.NULL, menuitem?.pointer ?: MemorySegment.NULL)
    }
    actual fun app_indicator_set_title(self: KJnaTypedPointer<_AppIndicator>?, title: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_set_title(self?.pointer ?: MemorySegment.NULL, title?.memorySegment(_arena))
    }
    actual fun app_indicator_get_id(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_id(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_category(self: KJnaTypedPointer<_AppIndicator>?): AppIndicatorCategory {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_category(self?.pointer ?: MemorySegment.NULL).let { AppIndicatorCategory.fromJvm(it) }
    }
    actual fun app_indicator_get_status(self: KJnaTypedPointer<_AppIndicator>?): AppIndicatorStatus {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_status(self?.pointer ?: MemorySegment.NULL).let { AppIndicatorStatus.fromJvm(it) }
    }
    actual fun app_indicator_get_icon(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_icon(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_icon_desc(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_icon_desc(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_icon_theme_path(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_icon_theme_path(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_attention_icon(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_attention_icon(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_attention_icon_desc(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_attention_icon_desc(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_title(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_title(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_menu(self: KJnaTypedPointer<_AppIndicator>?): KJnaTypedPointer<_GtkMenu>? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_menu(self?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun app_indicator_get_label(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_label(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_label_guide(self: KJnaTypedPointer<_AppIndicator>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_label_guide(self?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun app_indicator_get_ordering_index(self: KJnaTypedPointer<_AppIndicator>?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_ordering_index(self?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun app_indicator_get_secondary_activate_target(self: KJnaTypedPointer<_AppIndicator>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.app_indicator_get_secondary_activate_target(self?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun app_indicator_build_menu_from_desktop(self: KJnaTypedPointer<_AppIndicator>?, desktop_file: String?, desktop_profile: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.app_indicator_build_menu_from_desktop(self?.pointer ?: MemorySegment.NULL, desktop_file?.memorySegment(_arena), desktop_profile?.memorySegment(_arena))
    }
    actual fun g_main_context_new(): KJnaTypedPointer<_GMainContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_new()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_new_with_flags(flags: GMainContextFlags): KJnaTypedPointer<_GMainContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_new_with_flags(flags.toJvm())?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_ref(context: KJnaTypedPointer<_GMainContext>?): KJnaTypedPointer<_GMainContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_ref(context?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_unref(context: KJnaTypedPointer<_GMainContext>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_unref(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_default(): KJnaTypedPointer<_GMainContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_default()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_iteration(context: KJnaTypedPointer<_GMainContext>?, may_block: Int): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_iteration(context?.pointer ?: MemorySegment.NULL, may_block)
    }
    actual fun g_main_context_pending(context: KJnaTypedPointer<_GMainContext>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_pending(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_find_source_by_id(context: KJnaTypedPointer<_GMainContext>?, source_id: UInt): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_find_source_by_id(context?.pointer ?: MemorySegment.NULL, source_id.toInt())?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_find_source_by_user_data(context: KJnaTypedPointer<_GMainContext>?, user_data: KJnaPointer?): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_find_source_by_user_data(context?.pointer ?: MemorySegment.NULL, user_data?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_find_source_by_funcs_user_data(context: KJnaTypedPointer<_GMainContext>?, funcs: KJnaTypedPointer<_GSourceFuncs>?, user_data: KJnaPointer?): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_find_source_by_funcs_user_data(context?.pointer ?: MemorySegment.NULL, funcs?.pointer ?: MemorySegment.NULL, user_data?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_wakeup(context: KJnaTypedPointer<_GMainContext>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_wakeup(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_acquire(context: KJnaTypedPointer<_GMainContext>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_acquire(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_release(context: KJnaTypedPointer<_GMainContext>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_release(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_is_owner(context: KJnaTypedPointer<_GMainContext>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_is_owner(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_wait(context: KJnaTypedPointer<_GMainContext>?, cond: KJnaTypedPointer<_GCond>?, mutex: KJnaTypedPointer<_GMutex>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_wait(context?.pointer ?: MemorySegment.NULL, cond?.pointer ?: MemorySegment.NULL, mutex?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_prepare(context: KJnaTypedPointer<_GMainContext>?, priority: KJnaTypedPointer<Int>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_prepare(context?.pointer ?: MemorySegment.NULL, priority?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_query(context: KJnaTypedPointer<_GMainContext>?, max_priority: Int, timeout_: KJnaTypedPointer<Int>?, fds: KJnaTypedPointer<_GPollFD>?, n_fds: Int): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_query(context?.pointer ?: MemorySegment.NULL, max_priority, timeout_?.pointer ?: MemorySegment.NULL, fds?.pointer ?: MemorySegment.NULL, n_fds)
    }
    actual fun g_main_context_check(context: KJnaTypedPointer<_GMainContext>?, max_priority: Int, fds: KJnaTypedPointer<_GPollFD>?, n_fds: Int): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_check(context?.pointer ?: MemorySegment.NULL, max_priority, fds?.pointer ?: MemorySegment.NULL, n_fds)
    }
    actual fun g_main_context_dispatch(context: KJnaTypedPointer<_GMainContext>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_dispatch(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_set_poll_func(context: KJnaTypedPointer<_GMainContext>?, func: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_set_poll_func(context?.pointer ?: MemorySegment.NULL, func?.function ?: MemorySegment.NULL)
    }
    actual fun g_main_context_get_poll_func(context: KJnaTypedPointer<_GMainContext>?): KJnaFunctionPointer? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_get_poll_func(context?.pointer ?: MemorySegment.NULL)?.let { KJnaFunctionPointer(it) }
    }
    actual fun g_main_context_add_poll(context: KJnaTypedPointer<_GMainContext>?, fd: KJnaTypedPointer<_GPollFD>?, priority: Int) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_add_poll(context?.pointer ?: MemorySegment.NULL, fd?.pointer ?: MemorySegment.NULL, priority)
    }
    actual fun g_main_context_remove_poll(context: KJnaTypedPointer<_GMainContext>?, fd: KJnaTypedPointer<_GPollFD>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_remove_poll(context?.pointer ?: MemorySegment.NULL, fd?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_depth(): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_depth()
    }
    actual fun g_main_current_source(): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_current_source()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_push_thread_default(context: KJnaTypedPointer<_GMainContext>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_push_thread_default(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_pop_thread_default(context: KJnaTypedPointer<_GMainContext>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_pop_thread_default(context?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_get_thread_default(): KJnaTypedPointer<_GMainContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_get_thread_default()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_context_ref_thread_default(): KJnaTypedPointer<_GMainContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_context_ref_thread_default()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_loop_new(context: KJnaTypedPointer<_GMainContext>?, is_running: Int): KJnaTypedPointer<_GMainLoop>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_loop_new(context?.pointer ?: MemorySegment.NULL, is_running)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_loop_run(loop: KJnaTypedPointer<_GMainLoop>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_loop_run(loop?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_loop_quit(loop: KJnaTypedPointer<_GMainLoop>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_loop_quit(loop?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_loop_ref(loop: KJnaTypedPointer<_GMainLoop>?): KJnaTypedPointer<_GMainLoop>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_loop_ref(loop?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_main_loop_unref(loop: KJnaTypedPointer<_GMainLoop>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_loop_unref(loop?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_loop_is_running(loop: KJnaTypedPointer<_GMainLoop>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_loop_is_running(loop?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_loop_get_context(loop: KJnaTypedPointer<_GMainLoop>?): KJnaTypedPointer<_GMainContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_main_loop_get_context(loop?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_source_new(source_funcs: KJnaTypedPointer<_GSourceFuncs>?, struct_size: UInt): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_new(source_funcs?.pointer ?: MemorySegment.NULL, struct_size.toInt())?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_source_set_dispose_function(source: KJnaTypedPointer<_GSource>?, dispose: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_dispose_function(source?.pointer ?: MemorySegment.NULL, dispose?.function ?: MemorySegment.NULL)
    }
    actual fun g_source_ref(source: KJnaTypedPointer<_GSource>?): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_ref(source?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_source_unref(source: KJnaTypedPointer<_GSource>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_unref(source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_attach(source: KJnaTypedPointer<_GSource>?, context: KJnaTypedPointer<_GMainContext>?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_attach(source?.pointer ?: MemorySegment.NULL, context?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_source_destroy(source: KJnaTypedPointer<_GSource>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_destroy(source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_set_priority(source: KJnaTypedPointer<_GSource>?, priority: Int) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_priority(source?.pointer ?: MemorySegment.NULL, priority)
    }
    actual fun g_source_get_priority(source: KJnaTypedPointer<_GSource>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_get_priority(source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_set_can_recurse(source: KJnaTypedPointer<_GSource>?, can_recurse: Int) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_can_recurse(source?.pointer ?: MemorySegment.NULL, can_recurse)
    }
    actual fun g_source_get_can_recurse(source: KJnaTypedPointer<_GSource>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_get_can_recurse(source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_get_id(source: KJnaTypedPointer<_GSource>?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_get_id(source?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_source_get_context(source: KJnaTypedPointer<_GSource>?): KJnaTypedPointer<_GMainContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_get_context(source?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_source_set_callback(source: KJnaTypedPointer<_GSource>?, func: KJnaFunctionPointer?, data: KJnaPointer?, notify: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_callback(source?.pointer ?: MemorySegment.NULL, func?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, notify?.function ?: MemorySegment.NULL)
    }
    actual fun g_source_set_funcs(source: KJnaTypedPointer<_GSource>?, funcs: KJnaTypedPointer<_GSourceFuncs>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_funcs(source?.pointer ?: MemorySegment.NULL, funcs?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_is_destroyed(source: KJnaTypedPointer<_GSource>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_is_destroyed(source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_set_name(source: KJnaTypedPointer<_GSource>?, name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_name(source?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))
    }
    actual fun g_source_set_static_name(source: KJnaTypedPointer<_GSource>?, name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_static_name(source?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))
    }
    actual fun g_source_get_name(source: KJnaTypedPointer<_GSource>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_get_name(source?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun g_source_set_name_by_id(tag: UInt, name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_name_by_id(tag.toInt(), name?.memorySegment(_arena))
    }
    actual fun g_source_set_ready_time(source: KJnaTypedPointer<_GSource>?, ready_time: Long) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_ready_time(source?.pointer ?: MemorySegment.NULL, ready_time)
    }
    actual fun g_source_get_ready_time(source: KJnaTypedPointer<_GSource>?): Long {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_get_ready_time(source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_add_unix_fd(source: KJnaTypedPointer<_GSource>?, fd: Int, events: GIOCondition): KJnaPointer? {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_add_unix_fd(source?.pointer ?: MemorySegment.NULL, fd, events.toJvm())?.let { KJnaPointer(it) }
    }
    actual fun g_source_modify_unix_fd(source: KJnaTypedPointer<_GSource>?, tag: KJnaPointer?, new_events: GIOCondition) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_modify_unix_fd(source?.pointer ?: MemorySegment.NULL, tag?.pointer ?: MemorySegment.NULL, new_events.toJvm())
    }
    actual fun g_source_remove_unix_fd(source: KJnaTypedPointer<_GSource>?, tag: KJnaPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_remove_unix_fd(source?.pointer ?: MemorySegment.NULL, tag?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_query_unix_fd(source: KJnaTypedPointer<_GSource>?, tag: KJnaPointer?): GIOCondition {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_query_unix_fd(source?.pointer ?: MemorySegment.NULL, tag?.pointer ?: MemorySegment.NULL).let { GIOCondition.fromJvm(it) }
    }
    actual fun g_source_set_callback_indirect(source: KJnaTypedPointer<_GSource>?, callback_data: KJnaPointer?, callback_funcs: KJnaTypedPointer<_GSourceCallbackFuncs>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_set_callback_indirect(source?.pointer ?: MemorySegment.NULL, callback_data?.pointer ?: MemorySegment.NULL, callback_funcs?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_add_poll(source: KJnaTypedPointer<_GSource>?, fd: KJnaTypedPointer<_GPollFD>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_add_poll(source?.pointer ?: MemorySegment.NULL, fd?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_remove_poll(source: KJnaTypedPointer<_GSource>?, fd: KJnaTypedPointer<_GPollFD>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_remove_poll(source?.pointer ?: MemorySegment.NULL, fd?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_add_child_source(source: KJnaTypedPointer<_GSource>?, child_source: KJnaTypedPointer<_GSource>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_add_child_source(source?.pointer ?: MemorySegment.NULL, child_source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_remove_child_source(source: KJnaTypedPointer<_GSource>?, child_source: KJnaTypedPointer<_GSource>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_remove_child_source(source?.pointer ?: MemorySegment.NULL, child_source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_get_current_time(source: KJnaTypedPointer<_GSource>?, timeval: KJnaTypedPointer<_GTimeVal>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_source_get_current_time(source?.pointer ?: MemorySegment.NULL, timeval?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_get_time(source: KJnaTypedPointer<_GSource>?): Long {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_get_time(source?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_idle_source_new(): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_idle_source_new()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_child_watch_source_new(pid: Int): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_child_watch_source_new(pid)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_timeout_source_new(interval: UInt): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_timeout_source_new(interval.toInt())?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_timeout_source_new_seconds(interval: UInt): KJnaTypedPointer<_GSource>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_timeout_source_new_seconds(interval.toInt())?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_get_current_time(result: KJnaTypedPointer<_GTimeVal>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_get_current_time(result?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_get_monotonic_time(): Long {
        return gen.libappindicator.jextract.LibAppIndicator.g_get_monotonic_time()
    }
    actual fun g_get_real_time(): Long {
        return gen.libappindicator.jextract.LibAppIndicator.g_get_real_time()
    }
    actual fun g_source_remove(tag: UInt): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_remove(tag.toInt())
    }
    actual fun g_source_remove_by_user_data(user_data: KJnaPointer?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_remove_by_user_data(user_data?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_source_remove_by_funcs_user_data(funcs: KJnaTypedPointer<_GSourceFuncs>?, user_data: KJnaPointer?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_source_remove_by_funcs_user_data(funcs?.pointer ?: MemorySegment.NULL, user_data?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_timeout_add_full(priority: Int, interval: UInt, function: KJnaFunctionPointer?, data: KJnaPointer?, notify: KJnaFunctionPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_timeout_add_full(priority, interval.toInt(), function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, notify?.function ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_timeout_add(interval: UInt, function: KJnaFunctionPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_timeout_add(interval.toInt(), function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_timeout_add_once(interval: UInt, function: KJnaFunctionPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_timeout_add_once(interval.toInt(), function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_timeout_add_seconds_full(priority: Int, interval: UInt, function: KJnaFunctionPointer?, data: KJnaPointer?, notify: KJnaFunctionPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_timeout_add_seconds_full(priority, interval.toInt(), function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, notify?.function ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_timeout_add_seconds(interval: UInt, function: KJnaFunctionPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_timeout_add_seconds(interval.toInt(), function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_timeout_add_seconds_once(interval: UInt, function: KJnaFunctionPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_timeout_add_seconds_once(interval.toInt(), function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_child_watch_add_full(priority: Int, pid: Int, function: KJnaFunctionPointer?, data: KJnaPointer?, notify: KJnaFunctionPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_child_watch_add_full(priority, pid, function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, notify?.function ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_child_watch_add(pid: Int, function: KJnaFunctionPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_child_watch_add(pid, function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_idle_add(function: KJnaFunctionPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_idle_add(function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_idle_add_full(priority: Int, function: KJnaFunctionPointer?, data: KJnaPointer?, notify: KJnaFunctionPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_idle_add_full(priority, function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, notify?.function ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_idle_add_once(function: KJnaFunctionPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_idle_add_once(function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_idle_remove_by_data(data: KJnaPointer?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_idle_remove_by_data(data?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_main_context_invoke_full(context: KJnaTypedPointer<_GMainContext>?, priority: Int, function: KJnaFunctionPointer?, data: KJnaPointer?, notify: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_invoke_full(context?.pointer ?: MemorySegment.NULL, priority, function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, notify?.function ?: MemorySegment.NULL)
    }
    actual fun g_main_context_invoke(context: KJnaTypedPointer<_GMainContext>?, function: KJnaFunctionPointer?, data: KJnaPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_main_context_invoke(context?.pointer ?: MemorySegment.NULL, function?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_printf_string_upper_bound(format: String?, args: KJnaVarargList): ULong {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_log_set_handler(log_domain: String?, log_levels: GLogLevelFlags, log_func: KJnaFunctionPointer?, user_data: KJnaPointer?): UInt {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_log_set_handler(log_domain?.memorySegment(_arena), log_levels.toJvm(), log_func?.function ?: MemorySegment.NULL, user_data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_log_set_handler_full(log_domain: String?, log_levels: GLogLevelFlags, log_func: KJnaFunctionPointer?, user_data: KJnaPointer?, destroy: KJnaFunctionPointer?): UInt {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_log_set_handler_full(log_domain?.memorySegment(_arena), log_levels.toJvm(), log_func?.function ?: MemorySegment.NULL, user_data?.pointer ?: MemorySegment.NULL, destroy?.function ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_log_remove_handler(log_domain: String?, handler_id: UInt) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_log_remove_handler(log_domain?.memorySegment(_arena), handler_id.toInt())
    }
    actual fun g_log_default_handler(log_domain: String?, log_level: GLogLevelFlags, message: String?, unused_data: KJnaPointer?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_log_default_handler(log_domain?.memorySegment(_arena), log_level.toJvm(), message?.memorySegment(_arena), unused_data?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_log_set_default_handler(log_func: KJnaFunctionPointer?, user_data: KJnaPointer?): KJnaFunctionPointer? {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_set_default_handler(log_func?.function ?: MemorySegment.NULL, user_data?.pointer ?: MemorySegment.NULL)?.let { KJnaFunctionPointer(it) }
    }
    actual fun g_log(log_domain: String?, log_level: GLogLevelFlags, format: String?, p3: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_logv(log_domain: String?, log_level: GLogLevelFlags, format: String?, args: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_log_set_fatal_mask(log_domain: String?, fatal_mask: GLogLevelFlags): GLogLevelFlags {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_log_set_fatal_mask(log_domain?.memorySegment(_arena), fatal_mask.toJvm()).let { GLogLevelFlags.fromJvm(it) }
    }
    actual fun g_log_set_always_fatal(fatal_mask: GLogLevelFlags): GLogLevelFlags {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_set_always_fatal(fatal_mask.toJvm()).let { GLogLevelFlags.fromJvm(it) }
    }
    actual fun g_log_structured(log_domain: String?, log_level: GLogLevelFlags, p2: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_log_structured_array(log_level: GLogLevelFlags, fields: KJnaTypedPointer<_GLogField>?, n_fields: ULong) {
        gen.libappindicator.jextract.LibAppIndicator.g_log_structured_array(log_level.toJvm(), fields?.pointer ?: MemorySegment.NULL, n_fields.toLong())
    }
    actual fun g_log_variant(log_domain: String?, log_level: GLogLevelFlags, fields: KJnaTypedPointer<_GVariant>?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_log_variant(log_domain?.memorySegment(_arena), log_level.toJvm(), fields?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_log_set_writer_func(func: KJnaFunctionPointer?, user_data: KJnaPointer?, user_data_free: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_log_set_writer_func(func?.function ?: MemorySegment.NULL, user_data?.pointer ?: MemorySegment.NULL, user_data_free?.function ?: MemorySegment.NULL)
    }
    actual fun g_log_writer_supports_color(output_fd: Int): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_writer_supports_color(output_fd)
    }
    actual fun g_log_writer_is_journald(output_fd: Int): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_writer_is_journald(output_fd)
    }
    actual fun g_log_writer_format_fields(log_level: GLogLevelFlags, fields: KJnaTypedPointer<_GLogField>?, n_fields: ULong, use_color: Int): String? {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_writer_format_fields(log_level.toJvm(), fields?.pointer ?: MemorySegment.NULL, n_fields.toLong(), use_color)?.getString()
    }
    actual fun g_log_writer_syslog(log_level: GLogLevelFlags, fields: KJnaTypedPointer<_GLogField>?, n_fields: ULong, user_data: KJnaPointer?): GLogWriterOutput {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_writer_syslog(log_level.toJvm(), fields?.pointer ?: MemorySegment.NULL, n_fields.toLong(), user_data?.pointer ?: MemorySegment.NULL).let { GLogWriterOutput.fromJvm(it) }
    }
    actual fun g_log_writer_journald(log_level: GLogLevelFlags, fields: KJnaTypedPointer<_GLogField>?, n_fields: ULong, user_data: KJnaPointer?): GLogWriterOutput {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_writer_journald(log_level.toJvm(), fields?.pointer ?: MemorySegment.NULL, n_fields.toLong(), user_data?.pointer ?: MemorySegment.NULL).let { GLogWriterOutput.fromJvm(it) }
    }
    actual fun g_log_writer_standard_streams(log_level: GLogLevelFlags, fields: KJnaTypedPointer<_GLogField>?, n_fields: ULong, user_data: KJnaPointer?): GLogWriterOutput {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_writer_standard_streams(log_level.toJvm(), fields?.pointer ?: MemorySegment.NULL, n_fields.toLong(), user_data?.pointer ?: MemorySegment.NULL).let { GLogWriterOutput.fromJvm(it) }
    }
    actual fun g_log_writer_default(log_level: GLogLevelFlags, fields: KJnaTypedPointer<_GLogField>?, n_fields: ULong, user_data: KJnaPointer?): GLogWriterOutput {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_writer_default(log_level.toJvm(), fields?.pointer ?: MemorySegment.NULL, n_fields.toLong(), user_data?.pointer ?: MemorySegment.NULL).let { GLogWriterOutput.fromJvm(it) }
    }
    actual fun g_log_writer_default_set_use_stderr(use_stderr: Int) {
        gen.libappindicator.jextract.LibAppIndicator.g_log_writer_default_set_use_stderr(use_stderr)
    }
    actual fun g_log_writer_default_would_drop(log_level: GLogLevelFlags, log_domain: String?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_log_writer_default_would_drop(log_level.toJvm(), log_domain?.memorySegment(_arena))
    }
    actual fun g_log_writer_default_set_debug_domains(domains: KJnaTypedPointer<String>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_log_writer_default_set_debug_domains(domains?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_log_get_debug_enabled(): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_log_get_debug_enabled()
    }
    actual fun g_log_set_debug_enabled(enabled: Int) {
        gen.libappindicator.jextract.LibAppIndicator.g_log_set_debug_enabled(enabled)
    }
    actual fun g_return_if_fail_warning(log_domain: String?, pretty_function: String?, expression: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_return_if_fail_warning(log_domain?.memorySegment(_arena), pretty_function?.memorySegment(_arena), expression?.memorySegment(_arena))
    }
    actual fun g_warn_message(domain: String?, file: String?, line: Int, func: String?, warnexpr: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_warn_message(domain?.memorySegment(_arena), file?.memorySegment(_arena), line, func?.memorySegment(_arena), warnexpr?.memorySegment(_arena))
    }
    actual fun g_assert_warning(log_domain: String?, file: String?, line: Int, pretty_function: String?, expression: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_assert_warning(log_domain?.memorySegment(_arena), file?.memorySegment(_arena), line, pretty_function?.memorySegment(_arena), expression?.memorySegment(_arena))
    }
    actual fun g_log_structured_standard(log_domain: String?, log_level: GLogLevelFlags, file: String?, line: String?, func: String?, message_format: String?, p6: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_print(format: String?, p1: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_set_print_handler(func: KJnaFunctionPointer?): KJnaFunctionPointer? {
        return gen.libappindicator.jextract.LibAppIndicator.g_set_print_handler(func?.function ?: MemorySegment.NULL)?.let { KJnaFunctionPointer(it) }
    }
    actual fun g_printerr(format: String?, p1: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_set_printerr_handler(func: KJnaFunctionPointer?): KJnaFunctionPointer? {
        return gen.libappindicator.jextract.LibAppIndicator.g_set_printerr_handler(func?.function ?: MemorySegment.NULL)?.let { KJnaFunctionPointer(it) }
    }
    actual fun g_signal_newv(signal_name: String?, itype: ULong, signal_flags: GSignalFlags, class_closure: KJnaTypedPointer<_GClosure>?, accumulator: KJnaFunctionPointer?, accu_data: KJnaPointer?, c_marshaller: KJnaFunctionPointer?, return_type: ULong, n_params: UInt, param_types: KJnaTypedPointer<ULong>?): UInt {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_newv(signal_name?.memorySegment(_arena), itype.toLong(), signal_flags.toJvm(), class_closure?.pointer ?: MemorySegment.NULL, accumulator?.function ?: MemorySegment.NULL, accu_data?.pointer ?: MemorySegment.NULL, c_marshaller?.function ?: MemorySegment.NULL, return_type.toLong(), n_params.toInt(), param_types?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_signal_new_valist(signal_name: String?, itype: ULong, signal_flags: GSignalFlags, class_closure: KJnaTypedPointer<_GClosure>?, accumulator: KJnaFunctionPointer?, accu_data: KJnaPointer?, c_marshaller: KJnaFunctionPointer?, return_type: ULong, n_params: UInt, args: KJnaVarargList): UInt {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_signal_new(signal_name: String?, itype: ULong, signal_flags: GSignalFlags, class_offset: UInt, accumulator: KJnaFunctionPointer?, accu_data: KJnaPointer?, c_marshaller: KJnaFunctionPointer?, return_type: ULong, n_params: UInt, p9: KJnaVarargList): UInt {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_signal_new_class_handler(signal_name: String?, itype: ULong, signal_flags: GSignalFlags, class_handler: KJnaFunctionPointer?, accumulator: KJnaFunctionPointer?, accu_data: KJnaPointer?, c_marshaller: KJnaFunctionPointer?, return_type: ULong, n_params: UInt, p9: KJnaVarargList): UInt {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_signal_set_va_marshaller(signal_id: UInt, instance_type: ULong, va_marshaller: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_set_va_marshaller(signal_id.toInt(), instance_type.toLong(), va_marshaller?.function ?: MemorySegment.NULL)
    }
    actual fun g_signal_emitv(instance_and_params: KJnaTypedPointer<_GValue>?, signal_id: UInt, detail: UInt, return_value: KJnaTypedPointer<_GValue>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_emitv(instance_and_params?.pointer ?: MemorySegment.NULL, signal_id.toInt(), detail.toInt(), return_value?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_signal_emit_valist(instance: KJnaPointer?, signal_id: UInt, detail: UInt, var_args: KJnaVarargList) {
        TODO("Variadic function")
    }
    actual fun g_signal_emit(instance: KJnaPointer?, signal_id: UInt, detail: UInt, p3: KJnaVarargList) {
        TODO("Variadic function")
    }
    actual fun g_signal_emit_by_name(instance: KJnaPointer?, detailed_signal: String?, p2: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun g_signal_lookup(name: String?, itype: ULong): UInt {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_lookup(name?.memorySegment(_arena), itype.toLong()).toUInt()
    }
    actual fun g_signal_name(signal_id: UInt): String? {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_name(signal_id.toInt())?.getString()
    }
    actual fun g_signal_query(signal_id: UInt, query: KJnaTypedPointer<_GSignalQuery>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_query(signal_id.toInt(), query?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_signal_list_ids(itype: ULong, n_ids: KJnaTypedPointer<UInt>?): KJnaTypedPointer<UInt>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_list_ids(itype.toLong(), n_ids?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_signal_is_valid_name(name: String?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_is_valid_name(name?.memorySegment(_arena))
    }
    actual fun g_signal_parse_name(detailed_signal: String?, itype: ULong, signal_id_p: KJnaTypedPointer<UInt>?, detail_p: KJnaTypedPointer<UInt>?, force_detail_quark: Int): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_parse_name(detailed_signal?.memorySegment(_arena), itype.toLong(), signal_id_p?.pointer ?: MemorySegment.NULL, detail_p?.pointer ?: MemorySegment.NULL, force_detail_quark)
    }
    actual fun g_signal_get_invocation_hint(instance: KJnaPointer?): KJnaTypedPointer<_GSignalInvocationHint>? {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_get_invocation_hint(instance?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun g_signal_stop_emission(instance: KJnaPointer?, signal_id: UInt, detail: UInt) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_stop_emission(instance?.pointer ?: MemorySegment.NULL, signal_id.toInt(), detail.toInt())
    }
    actual fun g_signal_stop_emission_by_name(instance: KJnaPointer?, detailed_signal: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_signal_stop_emission_by_name(instance?.pointer ?: MemorySegment.NULL, detailed_signal?.memorySegment(_arena))
    }
    actual fun g_signal_add_emission_hook(signal_id: UInt, detail: UInt, hook_func: KJnaFunctionPointer?, hook_data: KJnaPointer?, data_destroy: KJnaFunctionPointer?): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_add_emission_hook(signal_id.toInt(), detail.toInt(), hook_func?.function ?: MemorySegment.NULL, hook_data?.pointer ?: MemorySegment.NULL, data_destroy?.function ?: MemorySegment.NULL).toULong()
    }
    actual fun g_signal_remove_emission_hook(signal_id: UInt, hook_id: ULong) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_remove_emission_hook(signal_id.toInt(), hook_id.toLong())
    }
    actual fun g_signal_has_handler_pending(instance: KJnaPointer?, signal_id: UInt, detail: UInt, may_be_blocked: Int): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_has_handler_pending(instance?.pointer ?: MemorySegment.NULL, signal_id.toInt(), detail.toInt(), may_be_blocked)
    }
    actual fun g_signal_connect_closure_by_id(instance: KJnaPointer?, signal_id: UInt, detail: UInt, closure: KJnaTypedPointer<_GClosure>?, after: Int): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_connect_closure_by_id(instance?.pointer ?: MemorySegment.NULL, signal_id.toInt(), detail.toInt(), closure?.pointer ?: MemorySegment.NULL, after).toULong()
    }
    actual fun g_signal_connect_closure(instance: KJnaPointer?, detailed_signal: String?, closure: KJnaTypedPointer<_GClosure>?, after: Int): ULong {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_connect_closure(instance?.pointer ?: MemorySegment.NULL, detailed_signal?.memorySegment(_arena), closure?.pointer ?: MemorySegment.NULL, after).toULong()
    }
    actual fun g_signal_connect_data(instance: KJnaPointer?, detailed_signal: String?, c_handler: KJnaFunctionPointer?, data: KJnaPointer?, destroy_data: KJnaFunctionPointer?, connect_flags: GConnectFlags): ULong {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_connect_data(instance?.pointer ?: MemorySegment.NULL, detailed_signal?.memorySegment(_arena), c_handler?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, destroy_data?.function ?: MemorySegment.NULL, connect_flags.toJvm()).toULong()
    }
    actual fun g_signal_handler_block(instance: KJnaPointer?, handler_id: ULong) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_handler_block(instance?.pointer ?: MemorySegment.NULL, handler_id.toLong())
    }
    actual fun g_signal_handler_unblock(instance: KJnaPointer?, handler_id: ULong) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_handler_unblock(instance?.pointer ?: MemorySegment.NULL, handler_id.toLong())
    }
    actual fun g_signal_handler_disconnect(instance: KJnaPointer?, handler_id: ULong) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_handler_disconnect(instance?.pointer ?: MemorySegment.NULL, handler_id.toLong())
    }
    actual fun g_signal_handler_is_connected(instance: KJnaPointer?, handler_id: ULong): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_handler_is_connected(instance?.pointer ?: MemorySegment.NULL, handler_id.toLong())
    }
    actual fun g_signal_handler_find(instance: KJnaPointer?, mask: GSignalMatchType, signal_id: UInt, detail: UInt, closure: KJnaTypedPointer<_GClosure>?, func: KJnaPointer?, data: KJnaPointer?): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_handler_find(instance?.pointer ?: MemorySegment.NULL, mask.toJvm(), signal_id.toInt(), detail.toInt(), closure?.pointer ?: MemorySegment.NULL, func?.pointer ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toULong()
    }
    actual fun g_signal_handlers_block_matched(instance: KJnaPointer?, mask: GSignalMatchType, signal_id: UInt, detail: UInt, closure: KJnaTypedPointer<_GClosure>?, func: KJnaPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_handlers_block_matched(instance?.pointer ?: MemorySegment.NULL, mask.toJvm(), signal_id.toInt(), detail.toInt(), closure?.pointer ?: MemorySegment.NULL, func?.pointer ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_signal_handlers_unblock_matched(instance: KJnaPointer?, mask: GSignalMatchType, signal_id: UInt, detail: UInt, closure: KJnaTypedPointer<_GClosure>?, func: KJnaPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_handlers_unblock_matched(instance?.pointer ?: MemorySegment.NULL, mask.toJvm(), signal_id.toInt(), detail.toInt(), closure?.pointer ?: MemorySegment.NULL, func?.pointer ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_signal_handlers_disconnect_matched(instance: KJnaPointer?, mask: GSignalMatchType, signal_id: UInt, detail: UInt, closure: KJnaTypedPointer<_GClosure>?, func: KJnaPointer?, data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_handlers_disconnect_matched(instance?.pointer ?: MemorySegment.NULL, mask.toJvm(), signal_id.toInt(), detail.toInt(), closure?.pointer ?: MemorySegment.NULL, func?.pointer ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun g_clear_signal_handler(handler_id_ptr: KJnaTypedPointer<ULong>?, instance: KJnaPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_clear_signal_handler(handler_id_ptr?.pointer ?: MemorySegment.NULL, instance?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_signal_override_class_closure(signal_id: UInt, instance_type: ULong, class_closure: KJnaTypedPointer<_GClosure>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_override_class_closure(signal_id.toInt(), instance_type.toLong(), class_closure?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_signal_override_class_handler(signal_name: String?, instance_type: ULong, class_handler: KJnaFunctionPointer?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.g_signal_override_class_handler(signal_name?.memorySegment(_arena), instance_type.toLong(), class_handler?.function ?: MemorySegment.NULL)
    }
    actual fun g_signal_chain_from_overridden(instance_and_params: KJnaTypedPointer<_GValue>?, return_value: KJnaTypedPointer<_GValue>?) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_chain_from_overridden(instance_and_params?.pointer ?: MemorySegment.NULL, return_value?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_signal_chain_from_overridden_handler(instance: KJnaPointer?, p1: KJnaVarargList) {
        TODO("Variadic function")
    }
    actual fun g_signal_accumulator_true_handled(ihint: KJnaTypedPointer<_GSignalInvocationHint>?, return_accu: KJnaTypedPointer<_GValue>?, handler_return: KJnaTypedPointer<_GValue>?, dummy: KJnaPointer?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_accumulator_true_handled(ihint?.pointer ?: MemorySegment.NULL, return_accu?.pointer ?: MemorySegment.NULL, handler_return?.pointer ?: MemorySegment.NULL, dummy?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_signal_accumulator_first_wins(ihint: KJnaTypedPointer<_GSignalInvocationHint>?, return_accu: KJnaTypedPointer<_GValue>?, handler_return: KJnaTypedPointer<_GValue>?, dummy: KJnaPointer?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.g_signal_accumulator_first_wins(ihint?.pointer ?: MemorySegment.NULL, return_accu?.pointer ?: MemorySegment.NULL, handler_return?.pointer ?: MemorySegment.NULL, dummy?.pointer ?: MemorySegment.NULL)
    }
    actual fun g_signal_handlers_destroy(instance: KJnaPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.g_signal_handlers_destroy(instance?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_type(): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_type().toULong()
    }
    actual fun gtk_widget_new(type: ULong, first_property_name: String?, p2: KJnaVarargList): KJnaTypedPointer<_GtkWidget>? {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun gtk_widget_destroy(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_destroy(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_destroyed(widget: KJnaTypedPointer<_GtkWidget>?, widget_pointer: KJnaTypedPointer<KJnaTypedPointer<_GtkWidget>?>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_destroyed(widget?.pointer ?: MemorySegment.NULL, widget_pointer?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_unparent(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_unparent(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_show(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_show(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_hide(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_hide(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_show_now(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_show_now(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_show_all(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_show_all(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_no_show_all(widget: KJnaTypedPointer<_GtkWidget>?, no_show_all: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_no_show_all(widget?.pointer ?: MemorySegment.NULL, no_show_all)
    }
    actual fun gtk_widget_get_no_show_all(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_no_show_all(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_map(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_map(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_unmap(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_unmap(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_realize(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_realize(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_unrealize(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_unrealize(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_draw(widget: KJnaTypedPointer<_GtkWidget>?, cr: KJnaTypedPointer<_cairo>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_draw(widget?.pointer ?: MemorySegment.NULL, cr?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_queue_draw(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_queue_draw(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_queue_draw_area(widget: KJnaTypedPointer<_GtkWidget>?, x: Int, y: Int, width: Int, height: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_queue_draw_area(widget?.pointer ?: MemorySegment.NULL, x, y, width, height)
    }
    actual fun gtk_widget_queue_draw_region(widget: KJnaTypedPointer<_GtkWidget>?, region: KJnaTypedPointer<_cairo_region>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_queue_draw_region(widget?.pointer ?: MemorySegment.NULL, region?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_queue_resize(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_queue_resize(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_queue_resize_no_redraw(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_queue_resize_no_redraw(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_queue_allocate(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_queue_allocate(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_frame_clock(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GdkFrameClock>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_frame_clock(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_size_request(widget: KJnaTypedPointer<_GtkWidget>?, requisition: KJnaTypedPointer<_GtkRequisition>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_size_request(widget?.pointer ?: MemorySegment.NULL, requisition?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_size_allocate(widget: KJnaTypedPointer<_GtkWidget>?, allocation: KJnaTypedPointer<_cairo_rectangle_int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_size_allocate(widget?.pointer ?: MemorySegment.NULL, allocation?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_size_allocate_with_baseline(widget: KJnaTypedPointer<_GtkWidget>?, allocation: KJnaTypedPointer<_cairo_rectangle_int>?, baseline: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_size_allocate_with_baseline(widget?.pointer ?: MemorySegment.NULL, allocation?.pointer ?: MemorySegment.NULL, baseline)
    }
    actual fun gtk_widget_get_request_mode(widget: KJnaTypedPointer<_GtkWidget>?): GtkSizeRequestMode {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_request_mode(widget?.pointer ?: MemorySegment.NULL).let { GtkSizeRequestMode.fromJvm(it) }
    }
    actual fun gtk_widget_get_preferred_width(widget: KJnaTypedPointer<_GtkWidget>?, minimum_width: KJnaTypedPointer<Int>?, natural_width: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_preferred_width(widget?.pointer ?: MemorySegment.NULL, minimum_width?.pointer ?: MemorySegment.NULL, natural_width?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_preferred_height_for_width(widget: KJnaTypedPointer<_GtkWidget>?, width: Int, minimum_height: KJnaTypedPointer<Int>?, natural_height: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_preferred_height_for_width(widget?.pointer ?: MemorySegment.NULL, width, minimum_height?.pointer ?: MemorySegment.NULL, natural_height?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_preferred_height(widget: KJnaTypedPointer<_GtkWidget>?, minimum_height: KJnaTypedPointer<Int>?, natural_height: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_preferred_height(widget?.pointer ?: MemorySegment.NULL, minimum_height?.pointer ?: MemorySegment.NULL, natural_height?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_preferred_width_for_height(widget: KJnaTypedPointer<_GtkWidget>?, height: Int, minimum_width: KJnaTypedPointer<Int>?, natural_width: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_preferred_width_for_height(widget?.pointer ?: MemorySegment.NULL, height, minimum_width?.pointer ?: MemorySegment.NULL, natural_width?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_preferred_height_and_baseline_for_width(widget: KJnaTypedPointer<_GtkWidget>?, width: Int, minimum_height: KJnaTypedPointer<Int>?, natural_height: KJnaTypedPointer<Int>?, minimum_baseline: KJnaTypedPointer<Int>?, natural_baseline: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_preferred_height_and_baseline_for_width(widget?.pointer ?: MemorySegment.NULL, width, minimum_height?.pointer ?: MemorySegment.NULL, natural_height?.pointer ?: MemorySegment.NULL, minimum_baseline?.pointer ?: MemorySegment.NULL, natural_baseline?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_preferred_size(widget: KJnaTypedPointer<_GtkWidget>?, minimum_size: KJnaTypedPointer<_GtkRequisition>?, natural_size: KJnaTypedPointer<_GtkRequisition>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_preferred_size(widget?.pointer ?: MemorySegment.NULL, minimum_size?.pointer ?: MemorySegment.NULL, natural_size?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_child_requisition(widget: KJnaTypedPointer<_GtkWidget>?, requisition: KJnaTypedPointer<_GtkRequisition>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_child_requisition(widget?.pointer ?: MemorySegment.NULL, requisition?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_add_accelerator(widget: KJnaTypedPointer<_GtkWidget>?, accel_signal: String?, accel_group: KJnaTypedPointer<_GtkAccelGroup>?, accel_key: UInt, accel_mods: GdkModifierType, accel_flags: GtkAccelFlags) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_add_accelerator(widget?.pointer ?: MemorySegment.NULL, accel_signal?.memorySegment(_arena), accel_group?.pointer ?: MemorySegment.NULL, accel_key.toInt(), accel_mods.toJvm(), accel_flags.toJvm())
    }
    actual fun gtk_widget_remove_accelerator(widget: KJnaTypedPointer<_GtkWidget>?, accel_group: KJnaTypedPointer<_GtkAccelGroup>?, accel_key: UInt, accel_mods: GdkModifierType): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_remove_accelerator(widget?.pointer ?: MemorySegment.NULL, accel_group?.pointer ?: MemorySegment.NULL, accel_key.toInt(), accel_mods.toJvm())
    }
    actual fun gtk_widget_set_accel_path(widget: KJnaTypedPointer<_GtkWidget>?, accel_path: String?, accel_group: KJnaTypedPointer<_GtkAccelGroup>?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_accel_path(widget?.pointer ?: MemorySegment.NULL, accel_path?.memorySegment(_arena), accel_group?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_list_accel_closures(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GList>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_list_accel_closures(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_can_activate_accel(widget: KJnaTypedPointer<_GtkWidget>?, signal_id: UInt): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_can_activate_accel(widget?.pointer ?: MemorySegment.NULL, signal_id.toInt())
    }
    actual fun gtk_widget_mnemonic_activate(widget: KJnaTypedPointer<_GtkWidget>?, group_cycling: Int): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_mnemonic_activate(widget?.pointer ?: MemorySegment.NULL, group_cycling)
    }
    actual fun gtk_widget_event(widget: KJnaTypedPointer<_GtkWidget>?, event: KJnaTypedPointer<_GdkEvent>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_event(widget?.pointer ?: MemorySegment.NULL, event?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_send_expose(widget: KJnaTypedPointer<_GtkWidget>?, event: KJnaTypedPointer<_GdkEvent>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_send_expose(widget?.pointer ?: MemorySegment.NULL, event?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_send_focus_change(widget: KJnaTypedPointer<_GtkWidget>?, event: KJnaTypedPointer<_GdkEvent>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_send_focus_change(widget?.pointer ?: MemorySegment.NULL, event?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_activate(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_activate(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_reparent(widget: KJnaTypedPointer<_GtkWidget>?, new_parent: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_reparent(widget?.pointer ?: MemorySegment.NULL, new_parent?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_intersect(widget: KJnaTypedPointer<_GtkWidget>?, area: KJnaTypedPointer<_cairo_rectangle_int>?, intersection: KJnaTypedPointer<_cairo_rectangle_int>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_intersect(widget?.pointer ?: MemorySegment.NULL, area?.pointer ?: MemorySegment.NULL, intersection?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_region_intersect(widget: KJnaTypedPointer<_GtkWidget>?, region: KJnaTypedPointer<_cairo_region>?): KJnaTypedPointer<_cairo_region>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_region_intersect(widget?.pointer ?: MemorySegment.NULL, region?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_freeze_child_notify(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_freeze_child_notify(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_child_notify(widget: KJnaTypedPointer<_GtkWidget>?, child_property: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_child_notify(widget?.pointer ?: MemorySegment.NULL, child_property?.memorySegment(_arena))
    }
    actual fun gtk_widget_thaw_child_notify(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_thaw_child_notify(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_can_focus(widget: KJnaTypedPointer<_GtkWidget>?, can_focus: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_can_focus(widget?.pointer ?: MemorySegment.NULL, can_focus)
    }
    actual fun gtk_widget_get_can_focus(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_can_focus(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_has_focus(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_has_focus(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_is_focus(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_is_focus(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_has_visible_focus(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_has_visible_focus(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_grab_focus(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_grab_focus(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_focus_on_click(widget: KJnaTypedPointer<_GtkWidget>?, focus_on_click: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_focus_on_click(widget?.pointer ?: MemorySegment.NULL, focus_on_click)
    }
    actual fun gtk_widget_get_focus_on_click(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_focus_on_click(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_can_default(widget: KJnaTypedPointer<_GtkWidget>?, can_default: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_can_default(widget?.pointer ?: MemorySegment.NULL, can_default)
    }
    actual fun gtk_widget_get_can_default(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_can_default(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_has_default(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_has_default(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_grab_default(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_grab_default(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_receives_default(widget: KJnaTypedPointer<_GtkWidget>?, receives_default: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_receives_default(widget?.pointer ?: MemorySegment.NULL, receives_default)
    }
    actual fun gtk_widget_get_receives_default(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_receives_default(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_has_grab(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_has_grab(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_device_is_shadowed(widget: KJnaTypedPointer<_GtkWidget>?, device: KJnaTypedPointer<_GdkDevice>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_device_is_shadowed(widget?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_name(widget: KJnaTypedPointer<_GtkWidget>?, name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_name(widget?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))
    }
    actual fun gtk_widget_get_name(widget: KJnaTypedPointer<_GtkWidget>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_name(widget?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_widget_set_state(widget: KJnaTypedPointer<_GtkWidget>?, state: GtkStateType) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_state(widget?.pointer ?: MemorySegment.NULL, state.toJvm())
    }
    actual fun gtk_widget_get_state(widget: KJnaTypedPointer<_GtkWidget>?): GtkStateType {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_state(widget?.pointer ?: MemorySegment.NULL).let { GtkStateType.fromJvm(it) }
    }
    actual fun gtk_widget_set_state_flags(widget: KJnaTypedPointer<_GtkWidget>?, flags: GtkStateFlags, clear: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_state_flags(widget?.pointer ?: MemorySegment.NULL, flags.toJvm(), clear)
    }
    actual fun gtk_widget_unset_state_flags(widget: KJnaTypedPointer<_GtkWidget>?, flags: GtkStateFlags) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_unset_state_flags(widget?.pointer ?: MemorySegment.NULL, flags.toJvm())
    }
    actual fun gtk_widget_get_state_flags(widget: KJnaTypedPointer<_GtkWidget>?): GtkStateFlags {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_state_flags(widget?.pointer ?: MemorySegment.NULL).let { GtkStateFlags.fromJvm(it) }
    }
    actual fun gtk_widget_set_sensitive(widget: KJnaTypedPointer<_GtkWidget>?, sensitive: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_sensitive(widget?.pointer ?: MemorySegment.NULL, sensitive)
    }
    actual fun gtk_widget_get_sensitive(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_sensitive(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_is_sensitive(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_is_sensitive(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_visible(widget: KJnaTypedPointer<_GtkWidget>?, visible: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_visible(widget?.pointer ?: MemorySegment.NULL, visible)
    }
    actual fun gtk_widget_get_visible(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_visible(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_is_visible(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_is_visible(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_has_window(widget: KJnaTypedPointer<_GtkWidget>?, has_window: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_has_window(widget?.pointer ?: MemorySegment.NULL, has_window)
    }
    actual fun gtk_widget_get_has_window(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_has_window(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_is_toplevel(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_is_toplevel(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_is_drawable(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_is_drawable(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_realized(widget: KJnaTypedPointer<_GtkWidget>?, realized: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_realized(widget?.pointer ?: MemorySegment.NULL, realized)
    }
    actual fun gtk_widget_get_realized(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_realized(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_mapped(widget: KJnaTypedPointer<_GtkWidget>?, mapped: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_mapped(widget?.pointer ?: MemorySegment.NULL, mapped)
    }
    actual fun gtk_widget_get_mapped(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_mapped(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_app_paintable(widget: KJnaTypedPointer<_GtkWidget>?, app_paintable: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_app_paintable(widget?.pointer ?: MemorySegment.NULL, app_paintable)
    }
    actual fun gtk_widget_get_app_paintable(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_app_paintable(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_double_buffered(widget: KJnaTypedPointer<_GtkWidget>?, double_buffered: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_double_buffered(widget?.pointer ?: MemorySegment.NULL, double_buffered)
    }
    actual fun gtk_widget_get_double_buffered(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_double_buffered(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_redraw_on_allocate(widget: KJnaTypedPointer<_GtkWidget>?, redraw_on_allocate: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_redraw_on_allocate(widget?.pointer ?: MemorySegment.NULL, redraw_on_allocate)
    }
    actual fun gtk_widget_set_parent(widget: KJnaTypedPointer<_GtkWidget>?, parent: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_parent(widget?.pointer ?: MemorySegment.NULL, parent?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_parent(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_parent(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_set_parent_window(widget: KJnaTypedPointer<_GtkWidget>?, parent_window: KJnaTypedPointer<_GdkWindow>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_parent_window(widget?.pointer ?: MemorySegment.NULL, parent_window?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_parent_window(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GdkWindow>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_parent_window(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_set_child_visible(widget: KJnaTypedPointer<_GtkWidget>?, is_visible: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_child_visible(widget?.pointer ?: MemorySegment.NULL, is_visible)
    }
    actual fun gtk_widget_get_child_visible(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_child_visible(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_window(widget: KJnaTypedPointer<_GtkWidget>?, window: KJnaTypedPointer<_GdkWindow>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_window(widget?.pointer ?: MemorySegment.NULL, window?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_window(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GdkWindow>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_window(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_register_window(widget: KJnaTypedPointer<_GtkWidget>?, window: KJnaTypedPointer<_GdkWindow>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_register_window(widget?.pointer ?: MemorySegment.NULL, window?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_unregister_window(widget: KJnaTypedPointer<_GtkWidget>?, window: KJnaTypedPointer<_GdkWindow>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_unregister_window(widget?.pointer ?: MemorySegment.NULL, window?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_allocated_width(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_allocated_width(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_allocated_height(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_allocated_height(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_allocated_baseline(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_allocated_baseline(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_allocated_size(widget: KJnaTypedPointer<_GtkWidget>?, allocation: KJnaTypedPointer<_cairo_rectangle_int>?, baseline: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_allocated_size(widget?.pointer ?: MemorySegment.NULL, allocation?.pointer ?: MemorySegment.NULL, baseline?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_allocation(widget: KJnaTypedPointer<_GtkWidget>?, allocation: KJnaTypedPointer<_cairo_rectangle_int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_allocation(widget?.pointer ?: MemorySegment.NULL, allocation?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_allocation(widget: KJnaTypedPointer<_GtkWidget>?, allocation: KJnaTypedPointer<_cairo_rectangle_int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_allocation(widget?.pointer ?: MemorySegment.NULL, allocation?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_clip(widget: KJnaTypedPointer<_GtkWidget>?, clip: KJnaTypedPointer<_cairo_rectangle_int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_clip(widget?.pointer ?: MemorySegment.NULL, clip?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_clip(widget: KJnaTypedPointer<_GtkWidget>?, clip: KJnaTypedPointer<_cairo_rectangle_int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_clip(widget?.pointer ?: MemorySegment.NULL, clip?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_requisition(widget: KJnaTypedPointer<_GtkWidget>?, requisition: KJnaTypedPointer<_GtkRequisition>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_requisition(widget?.pointer ?: MemorySegment.NULL, requisition?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_child_focus(widget: KJnaTypedPointer<_GtkWidget>?, direction: GtkDirectionType): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_child_focus(widget?.pointer ?: MemorySegment.NULL, direction.toJvm())
    }
    actual fun gtk_widget_keynav_failed(widget: KJnaTypedPointer<_GtkWidget>?, direction: GtkDirectionType): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_keynav_failed(widget?.pointer ?: MemorySegment.NULL, direction.toJvm())
    }
    actual fun gtk_widget_error_bell(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_error_bell(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_size_request(widget: KJnaTypedPointer<_GtkWidget>?, width: Int, height: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_size_request(widget?.pointer ?: MemorySegment.NULL, width, height)
    }
    actual fun gtk_widget_get_size_request(widget: KJnaTypedPointer<_GtkWidget>?, width: KJnaTypedPointer<Int>?, height: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_size_request(widget?.pointer ?: MemorySegment.NULL, width?.pointer ?: MemorySegment.NULL, height?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_events(widget: KJnaTypedPointer<_GtkWidget>?, events: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_events(widget?.pointer ?: MemorySegment.NULL, events)
    }
    actual fun gtk_widget_add_events(widget: KJnaTypedPointer<_GtkWidget>?, events: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_add_events(widget?.pointer ?: MemorySegment.NULL, events)
    }
    actual fun gtk_widget_set_device_events(widget: KJnaTypedPointer<_GtkWidget>?, device: KJnaTypedPointer<_GdkDevice>?, events: GdkEventMask) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_device_events(widget?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL, events.toJvm())
    }
    actual fun gtk_widget_add_device_events(widget: KJnaTypedPointer<_GtkWidget>?, device: KJnaTypedPointer<_GdkDevice>?, events: GdkEventMask) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_add_device_events(widget?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL, events.toJvm())
    }
    actual fun gtk_widget_set_opacity(widget: KJnaTypedPointer<_GtkWidget>?, opacity: Double) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_opacity(widget?.pointer ?: MemorySegment.NULL, opacity)
    }
    actual fun gtk_widget_get_opacity(widget: KJnaTypedPointer<_GtkWidget>?): Double {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_opacity(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_device_enabled(widget: KJnaTypedPointer<_GtkWidget>?, device: KJnaTypedPointer<_GdkDevice>?, enabled: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_device_enabled(widget?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL, enabled)
    }
    actual fun gtk_widget_get_device_enabled(widget: KJnaTypedPointer<_GtkWidget>?, device: KJnaTypedPointer<_GdkDevice>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_device_enabled(widget?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_toplevel(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_toplevel(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_ancestor(widget: KJnaTypedPointer<_GtkWidget>?, widget_type: ULong): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_ancestor(widget?.pointer ?: MemorySegment.NULL, widget_type.toLong())?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_visual(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GdkVisual>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_visual(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_set_visual(widget: KJnaTypedPointer<_GtkWidget>?, visual: KJnaTypedPointer<_GdkVisual>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_visual(widget?.pointer ?: MemorySegment.NULL, visual?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_screen(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GdkScreen>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_screen(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_has_screen(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_has_screen(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_scale_factor(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_scale_factor(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_display(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GdkDisplay>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_display(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_root_window(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GdkWindow>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_root_window(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_settings(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GtkSettings>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_settings(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_clipboard(widget: KJnaTypedPointer<_GtkWidget>?, selection: KJnaTypedPointer<_GdkAtom>?): KJnaTypedPointer<_GtkClipboard>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_clipboard(widget?.pointer ?: MemorySegment.NULL, selection?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_hexpand(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_hexpand(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_hexpand(widget: KJnaTypedPointer<_GtkWidget>?, expand: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_hexpand(widget?.pointer ?: MemorySegment.NULL, expand)
    }
    actual fun gtk_widget_get_hexpand_set(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_hexpand_set(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_hexpand_set(widget: KJnaTypedPointer<_GtkWidget>?, set: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_hexpand_set(widget?.pointer ?: MemorySegment.NULL, set)
    }
    actual fun gtk_widget_get_vexpand(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_vexpand(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_vexpand(widget: KJnaTypedPointer<_GtkWidget>?, expand: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_vexpand(widget?.pointer ?: MemorySegment.NULL, expand)
    }
    actual fun gtk_widget_get_vexpand_set(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_vexpand_set(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_vexpand_set(widget: KJnaTypedPointer<_GtkWidget>?, set: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_vexpand_set(widget?.pointer ?: MemorySegment.NULL, set)
    }
    actual fun gtk_widget_queue_compute_expand(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_queue_compute_expand(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_compute_expand(widget: KJnaTypedPointer<_GtkWidget>?, orientation: GtkOrientation): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_compute_expand(widget?.pointer ?: MemorySegment.NULL, orientation.toJvm())
    }
    actual fun gtk_widget_get_support_multidevice(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_support_multidevice(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_support_multidevice(widget: KJnaTypedPointer<_GtkWidget>?, support_multidevice: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_support_multidevice(widget?.pointer ?: MemorySegment.NULL, support_multidevice)
    }
    actual fun gtk_widget_class_set_accessible_type(widget_class: KJnaTypedPointer<_GtkWidgetClass>?, type: ULong) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_set_accessible_type(widget_class?.pointer ?: MemorySegment.NULL, type.toLong())
    }
    actual fun gtk_widget_class_set_accessible_role(widget_class: KJnaTypedPointer<_GtkWidgetClass>?, role: AtkRole) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_set_accessible_role(widget_class?.pointer ?: MemorySegment.NULL, role.toJvm())
    }
    actual fun gtk_widget_get_accessible(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_AtkObject>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_accessible(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_halign(widget: KJnaTypedPointer<_GtkWidget>?): GtkAlign {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_halign(widget?.pointer ?: MemorySegment.NULL).let { GtkAlign.fromJvm(it) }
    }
    actual fun gtk_widget_set_halign(widget: KJnaTypedPointer<_GtkWidget>?, align: GtkAlign) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_halign(widget?.pointer ?: MemorySegment.NULL, align.toJvm())
    }
    actual fun gtk_widget_get_valign(widget: KJnaTypedPointer<_GtkWidget>?): GtkAlign {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_valign(widget?.pointer ?: MemorySegment.NULL).let { GtkAlign.fromJvm(it) }
    }
    actual fun gtk_widget_get_valign_with_baseline(widget: KJnaTypedPointer<_GtkWidget>?): GtkAlign {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_valign_with_baseline(widget?.pointer ?: MemorySegment.NULL).let { GtkAlign.fromJvm(it) }
    }
    actual fun gtk_widget_set_valign(widget: KJnaTypedPointer<_GtkWidget>?, align: GtkAlign) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_valign(widget?.pointer ?: MemorySegment.NULL, align.toJvm())
    }
    actual fun gtk_widget_get_margin_left(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_margin_left(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_margin_left(widget: KJnaTypedPointer<_GtkWidget>?, margin: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_margin_left(widget?.pointer ?: MemorySegment.NULL, margin)
    }
    actual fun gtk_widget_get_margin_right(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_margin_right(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_margin_right(widget: KJnaTypedPointer<_GtkWidget>?, margin: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_margin_right(widget?.pointer ?: MemorySegment.NULL, margin)
    }
    actual fun gtk_widget_get_margin_start(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_margin_start(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_margin_start(widget: KJnaTypedPointer<_GtkWidget>?, margin: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_margin_start(widget?.pointer ?: MemorySegment.NULL, margin)
    }
    actual fun gtk_widget_get_margin_end(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_margin_end(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_margin_end(widget: KJnaTypedPointer<_GtkWidget>?, margin: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_margin_end(widget?.pointer ?: MemorySegment.NULL, margin)
    }
    actual fun gtk_widget_get_margin_top(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_margin_top(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_margin_top(widget: KJnaTypedPointer<_GtkWidget>?, margin: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_margin_top(widget?.pointer ?: MemorySegment.NULL, margin)
    }
    actual fun gtk_widget_get_margin_bottom(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_margin_bottom(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_margin_bottom(widget: KJnaTypedPointer<_GtkWidget>?, margin: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_margin_bottom(widget?.pointer ?: MemorySegment.NULL, margin)
    }
    actual fun gtk_widget_get_events(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_events(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_device_events(widget: KJnaTypedPointer<_GtkWidget>?, device: KJnaTypedPointer<_GdkDevice>?): GdkEventMask {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_device_events(widget?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL).let { GdkEventMask.fromJvm(it) }
    }
    actual fun gtk_widget_get_pointer(widget: KJnaTypedPointer<_GtkWidget>?, x: KJnaTypedPointer<Int>?, y: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_pointer(widget?.pointer ?: MemorySegment.NULL, x?.pointer ?: MemorySegment.NULL, y?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_is_ancestor(widget: KJnaTypedPointer<_GtkWidget>?, ancestor: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_is_ancestor(widget?.pointer ?: MemorySegment.NULL, ancestor?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_translate_coordinates(src_widget: KJnaTypedPointer<_GtkWidget>?, dest_widget: KJnaTypedPointer<_GtkWidget>?, src_x: Int, src_y: Int, dest_x: KJnaTypedPointer<Int>?, dest_y: KJnaTypedPointer<Int>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_translate_coordinates(src_widget?.pointer ?: MemorySegment.NULL, dest_widget?.pointer ?: MemorySegment.NULL, src_x, src_y, dest_x?.pointer ?: MemorySegment.NULL, dest_y?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_hide_on_delete(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_hide_on_delete(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_override_color(widget: KJnaTypedPointer<_GtkWidget>?, state: GtkStateFlags, color: KJnaTypedPointer<_GdkRGBA>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_override_color(widget?.pointer ?: MemorySegment.NULL, state.toJvm(), color?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_override_background_color(widget: KJnaTypedPointer<_GtkWidget>?, state: GtkStateFlags, color: KJnaTypedPointer<_GdkRGBA>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_override_background_color(widget?.pointer ?: MemorySegment.NULL, state.toJvm(), color?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_override_font(widget: KJnaTypedPointer<_GtkWidget>?, font_desc: KJnaTypedPointer<_PangoFontDescription>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_override_font(widget?.pointer ?: MemorySegment.NULL, font_desc?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_override_symbolic_color(widget: KJnaTypedPointer<_GtkWidget>?, name: String?, color: KJnaTypedPointer<_GdkRGBA>?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_override_symbolic_color(widget?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena), color?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_override_cursor(widget: KJnaTypedPointer<_GtkWidget>?, cursor: KJnaTypedPointer<_GdkRGBA>?, secondary_cursor: KJnaTypedPointer<_GdkRGBA>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_override_cursor(widget?.pointer ?: MemorySegment.NULL, cursor?.pointer ?: MemorySegment.NULL, secondary_cursor?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_reset_style(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_reset_style(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_create_pango_context(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_PangoContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_create_pango_context(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_pango_context(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_PangoContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_pango_context(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_set_font_options(widget: KJnaTypedPointer<_GtkWidget>?, options: KJnaTypedPointer<_cairo_font_options>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_font_options(widget?.pointer ?: MemorySegment.NULL, options?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_font_options(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_cairo_font_options>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_font_options(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_create_pango_layout(widget: KJnaTypedPointer<_GtkWidget>?, text: String?): KJnaTypedPointer<_PangoLayout>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_create_pango_layout(widget?.pointer ?: MemorySegment.NULL, text?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_render_icon_pixbuf(widget: KJnaTypedPointer<_GtkWidget>?, stock_id: String?, size: GtkIconSize): KJnaTypedPointer<_GdkPixbuf>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_render_icon_pixbuf(widget?.pointer ?: MemorySegment.NULL, stock_id?.memorySegment(_arena), size.toJvm())?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_set_composite_name(widget: KJnaTypedPointer<_GtkWidget>?, name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_composite_name(widget?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))
    }
    actual fun gtk_widget_get_composite_name(widget: KJnaTypedPointer<_GtkWidget>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_composite_name(widget?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_widget_push_composite_child() {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_push_composite_child()
    }
    actual fun gtk_widget_pop_composite_child() {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_pop_composite_child()
    }
    actual fun gtk_widget_class_install_style_property(klass: KJnaTypedPointer<_GtkWidgetClass>?, pspec: KJnaTypedPointer<_GParamSpec>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_install_style_property(klass?.pointer ?: MemorySegment.NULL, pspec?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_class_install_style_property_parser(klass: KJnaTypedPointer<_GtkWidgetClass>?, pspec: KJnaTypedPointer<_GParamSpec>?, parser: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_install_style_property_parser(klass?.pointer ?: MemorySegment.NULL, pspec?.pointer ?: MemorySegment.NULL, parser?.function ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_class_find_style_property(klass: KJnaTypedPointer<_GtkWidgetClass>?, property_name: String?): KJnaTypedPointer<_GParamSpec>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_find_style_property(klass?.pointer ?: MemorySegment.NULL, property_name?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_class_list_style_properties(klass: KJnaTypedPointer<_GtkWidgetClass>?, n_properties: KJnaTypedPointer<UInt>?): KJnaTypedPointer<KJnaTypedPointer<_GParamSpec>?>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_list_style_properties(klass?.pointer ?: MemorySegment.NULL, n_properties?.pointer ?: MemorySegment.NULL)?.let { TODO("Nested pointers") }
    }
    actual fun gtk_widget_style_get_property(widget: KJnaTypedPointer<_GtkWidget>?, property_name: String?, value: KJnaTypedPointer<_GValue>?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_style_get_property(widget?.pointer ?: MemorySegment.NULL, property_name?.memorySegment(_arena), value?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_style_get_valist(widget: KJnaTypedPointer<_GtkWidget>?, first_property_name: String?, var_args: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun gtk_widget_style_get(widget: KJnaTypedPointer<_GtkWidget>?, first_property_name: String?, p2: KJnaVarargList) {
        val _arena: Arena = Arena.ofAuto()
        TODO("Variadic function")
    }
    actual fun gtk_widget_set_direction(widget: KJnaTypedPointer<_GtkWidget>?, dir: GtkTextDirection) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_direction(widget?.pointer ?: MemorySegment.NULL, dir.toJvm())
    }
    actual fun gtk_widget_get_direction(widget: KJnaTypedPointer<_GtkWidget>?): GtkTextDirection {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_direction(widget?.pointer ?: MemorySegment.NULL).let { GtkTextDirection.fromJvm(it) }
    }
    actual fun gtk_widget_set_default_direction(dir: GtkTextDirection) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_default_direction(dir.toJvm())
    }
    actual fun gtk_widget_get_default_direction(): GtkTextDirection {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_default_direction().let { GtkTextDirection.fromJvm(it) }
    }
    actual fun gtk_widget_is_composited(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_is_composited(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_shape_combine_region(widget: KJnaTypedPointer<_GtkWidget>?, region: KJnaTypedPointer<_cairo_region>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_shape_combine_region(widget?.pointer ?: MemorySegment.NULL, region?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_input_shape_combine_region(widget: KJnaTypedPointer<_GtkWidget>?, region: KJnaTypedPointer<_cairo_region>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_input_shape_combine_region(widget?.pointer ?: MemorySegment.NULL, region?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_list_mnemonic_labels(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GList>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_list_mnemonic_labels(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_add_mnemonic_label(widget: KJnaTypedPointer<_GtkWidget>?, label: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_add_mnemonic_label(widget?.pointer ?: MemorySegment.NULL, label?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_remove_mnemonic_label(widget: KJnaTypedPointer<_GtkWidget>?, label: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_remove_mnemonic_label(widget?.pointer ?: MemorySegment.NULL, label?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_tooltip_window(widget: KJnaTypedPointer<_GtkWidget>?, custom_window: KJnaTypedPointer<_GtkWindow>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_tooltip_window(widget?.pointer ?: MemorySegment.NULL, custom_window?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_tooltip_window(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GtkWindow>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_tooltip_window(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_trigger_tooltip_query(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_trigger_tooltip_query(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_set_tooltip_text(widget: KJnaTypedPointer<_GtkWidget>?, text: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_tooltip_text(widget?.pointer ?: MemorySegment.NULL, text?.memorySegment(_arena))
    }
    actual fun gtk_widget_get_tooltip_text(widget: KJnaTypedPointer<_GtkWidget>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_tooltip_text(widget?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_widget_set_tooltip_markup(widget: KJnaTypedPointer<_GtkWidget>?, markup: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_tooltip_markup(widget?.pointer ?: MemorySegment.NULL, markup?.memorySegment(_arena))
    }
    actual fun gtk_widget_get_tooltip_markup(widget: KJnaTypedPointer<_GtkWidget>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_tooltip_markup(widget?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_widget_set_has_tooltip(widget: KJnaTypedPointer<_GtkWidget>?, has_tooltip: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_has_tooltip(widget?.pointer ?: MemorySegment.NULL, has_tooltip)
    }
    actual fun gtk_widget_get_has_tooltip(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_has_tooltip(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_cairo_should_draw_window(cr: KJnaTypedPointer<_cairo>?, window: KJnaTypedPointer<_GdkWindow>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_cairo_should_draw_window(cr?.pointer ?: MemorySegment.NULL, window?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_cairo_transform_to_window(cr: KJnaTypedPointer<_cairo>?, widget: KJnaTypedPointer<_GtkWidget>?, window: KJnaTypedPointer<_GdkWindow>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_cairo_transform_to_window(cr?.pointer ?: MemorySegment.NULL, widget?.pointer ?: MemorySegment.NULL, window?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_requisition_get_type(): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_requisition_get_type().toULong()
    }
    actual fun gtk_requisition_new(): KJnaTypedPointer<_GtkRequisition>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_requisition_new()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_requisition_copy(requisition: KJnaTypedPointer<_GtkRequisition>?): KJnaTypedPointer<_GtkRequisition>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_requisition_copy(requisition?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_requisition_free(requisition: KJnaTypedPointer<_GtkRequisition>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_requisition_free(requisition?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_in_destruction(widget: KJnaTypedPointer<_GtkWidget>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_in_destruction(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_style_context(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GtkStyleContext>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_style_context(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_get_path(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GtkWidgetPath>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_path(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_class_set_css_name(widget_class: KJnaTypedPointer<_GtkWidgetClass>?, name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_set_css_name(widget_class?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))
    }
    actual fun gtk_widget_class_get_css_name(widget_class: KJnaTypedPointer<_GtkWidgetClass>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_get_css_name(widget_class?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_widget_get_modifier_mask(widget: KJnaTypedPointer<_GtkWidget>?, intent: GdkModifierIntent): GdkModifierType {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_modifier_mask(widget?.pointer ?: MemorySegment.NULL, intent.toJvm()).let { GdkModifierType.fromJvm(it) }
    }
    actual fun gtk_widget_insert_action_group(widget: KJnaTypedPointer<_GtkWidget>?, name: String?, group: KJnaTypedPointer<_GActionGroup>?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_insert_action_group(widget?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena), group?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_add_tick_callback(widget: KJnaTypedPointer<_GtkWidget>?, callback: KJnaFunctionPointer?, user_data: KJnaPointer?, notify: KJnaFunctionPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_add_tick_callback(widget?.pointer ?: MemorySegment.NULL, callback?.function ?: MemorySegment.NULL, user_data?.pointer ?: MemorySegment.NULL, notify?.function ?: MemorySegment.NULL).toUInt()
    }
    actual fun gtk_widget_remove_tick_callback(widget: KJnaTypedPointer<_GtkWidget>?, id: UInt) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_remove_tick_callback(widget?.pointer ?: MemorySegment.NULL, id.toInt())
    }
    actual fun gtk_widget_init_template(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_init_template(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_template_child(widget: KJnaTypedPointer<_GtkWidget>?, widget_type: ULong, name: String?): KJnaTypedPointer<_GObject>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_template_child(widget?.pointer ?: MemorySegment.NULL, widget_type.toLong(), name?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_class_set_template(widget_class: KJnaTypedPointer<_GtkWidgetClass>?, template_bytes: KJnaTypedPointer<_GBytes>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_set_template(widget_class?.pointer ?: MemorySegment.NULL, template_bytes?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_class_set_template_from_resource(widget_class: KJnaTypedPointer<_GtkWidgetClass>?, resource_name: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_set_template_from_resource(widget_class?.pointer ?: MemorySegment.NULL, resource_name?.memorySegment(_arena))
    }
    actual fun gtk_widget_class_bind_template_callback_full(widget_class: KJnaTypedPointer<_GtkWidgetClass>?, callback_name: String?, callback_symbol: KJnaFunctionPointer?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_bind_template_callback_full(widget_class?.pointer ?: MemorySegment.NULL, callback_name?.memorySegment(_arena), callback_symbol?.function ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_class_set_connect_func(widget_class: KJnaTypedPointer<_GtkWidgetClass>?, connect_func: KJnaFunctionPointer?, connect_data: KJnaPointer?, connect_data_destroy: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_set_connect_func(widget_class?.pointer ?: MemorySegment.NULL, connect_func?.function ?: MemorySegment.NULL, connect_data?.pointer ?: MemorySegment.NULL, connect_data_destroy?.function ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_class_bind_template_child_full(widget_class: KJnaTypedPointer<_GtkWidgetClass>?, name: String?, internal_child: Int, struct_offset: Long) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_class_bind_template_child_full(widget_class?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena), internal_child, struct_offset)
    }
    actual fun gtk_widget_get_action_group(widget: KJnaTypedPointer<_GtkWidget>?, prefix: String?): KJnaTypedPointer<_GActionGroup>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_action_group(widget?.pointer ?: MemorySegment.NULL, prefix?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_widget_list_action_prefixes(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<String>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_list_action_prefixes(widget?.pointer ?: MemorySegment.NULL)?.let { TODO("Nested pointers") }
    }
    actual fun gtk_widget_set_font_map(widget: KJnaTypedPointer<_GtkWidget>?, font_map: KJnaTypedPointer<_PangoFontMap>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_widget_set_font_map(widget?.pointer ?: MemorySegment.NULL, font_map?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_widget_get_font_map(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_PangoFontMap>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_widget_get_font_map(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_get_type(): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_type().toULong()
    }
    actual fun gtk_menu_new(): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_new()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_new_from_model(model: KJnaTypedPointer<_GMenuModel>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_new_from_model(model?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_popup(menu: KJnaTypedPointer<_GtkMenu>?, parent_menu_shell: KJnaTypedPointer<_GtkWidget>?, parent_menu_item: KJnaTypedPointer<_GtkWidget>?, func: KJnaFunctionPointer?, data: KJnaPointer?, button: UInt, activate_time: UInt) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_popup(menu?.pointer ?: MemorySegment.NULL, parent_menu_shell?.pointer ?: MemorySegment.NULL, parent_menu_item?.pointer ?: MemorySegment.NULL, func?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, button.toInt(), activate_time.toInt())
    }
    actual fun gtk_menu_popup_for_device(menu: KJnaTypedPointer<_GtkMenu>?, device: KJnaTypedPointer<_GdkDevice>?, parent_menu_shell: KJnaTypedPointer<_GtkWidget>?, parent_menu_item: KJnaTypedPointer<_GtkWidget>?, func: KJnaFunctionPointer?, data: KJnaPointer?, destroy: KJnaFunctionPointer?, button: UInt, activate_time: UInt) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_popup_for_device(menu?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL, parent_menu_shell?.pointer ?: MemorySegment.NULL, parent_menu_item?.pointer ?: MemorySegment.NULL, func?.function ?: MemorySegment.NULL, data?.pointer ?: MemorySegment.NULL, destroy?.function ?: MemorySegment.NULL, button.toInt(), activate_time.toInt())
    }
    actual fun gtk_menu_popup_at_rect(menu: KJnaTypedPointer<_GtkMenu>?, rect_window: KJnaTypedPointer<_GdkWindow>?, rect: KJnaTypedPointer<_cairo_rectangle_int>?, rect_anchor: GdkGravity, menu_anchor: GdkGravity, trigger_event: KJnaTypedPointer<_GdkEvent>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_popup_at_rect(menu?.pointer ?: MemorySegment.NULL, rect_window?.pointer ?: MemorySegment.NULL, rect?.pointer ?: MemorySegment.NULL, rect_anchor.toJvm(), menu_anchor.toJvm(), trigger_event?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_popup_at_widget(menu: KJnaTypedPointer<_GtkMenu>?, widget: KJnaTypedPointer<_GtkWidget>?, widget_anchor: GdkGravity, menu_anchor: GdkGravity, trigger_event: KJnaTypedPointer<_GdkEvent>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_popup_at_widget(menu?.pointer ?: MemorySegment.NULL, widget?.pointer ?: MemorySegment.NULL, widget_anchor.toJvm(), menu_anchor.toJvm(), trigger_event?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_popup_at_pointer(menu: KJnaTypedPointer<_GtkMenu>?, trigger_event: KJnaTypedPointer<_GdkEvent>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_popup_at_pointer(menu?.pointer ?: MemorySegment.NULL, trigger_event?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_reposition(menu: KJnaTypedPointer<_GtkMenu>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_reposition(menu?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_popdown(menu: KJnaTypedPointer<_GtkMenu>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_popdown(menu?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_get_active(menu: KJnaTypedPointer<_GtkMenu>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_active(menu?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_set_active(menu: KJnaTypedPointer<_GtkMenu>?, index: UInt) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_set_active(menu?.pointer ?: MemorySegment.NULL, index.toInt())
    }
    actual fun gtk_menu_set_accel_group(menu: KJnaTypedPointer<_GtkMenu>?, accel_group: KJnaTypedPointer<_GtkAccelGroup>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_set_accel_group(menu?.pointer ?: MemorySegment.NULL, accel_group?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_get_accel_group(menu: KJnaTypedPointer<_GtkMenu>?): KJnaTypedPointer<_GtkAccelGroup>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_accel_group(menu?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_set_accel_path(menu: KJnaTypedPointer<_GtkMenu>?, accel_path: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_set_accel_path(menu?.pointer ?: MemorySegment.NULL, accel_path?.memorySegment(_arena))
    }
    actual fun gtk_menu_get_accel_path(menu: KJnaTypedPointer<_GtkMenu>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_accel_path(menu?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_menu_attach_to_widget(menu: KJnaTypedPointer<_GtkMenu>?, attach_widget: KJnaTypedPointer<_GtkWidget>?, detacher: KJnaFunctionPointer?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_attach_to_widget(menu?.pointer ?: MemorySegment.NULL, attach_widget?.pointer ?: MemorySegment.NULL, detacher?.function ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_detach(menu: KJnaTypedPointer<_GtkMenu>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_detach(menu?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_get_attach_widget(menu: KJnaTypedPointer<_GtkMenu>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_attach_widget(menu?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_set_tearoff_state(menu: KJnaTypedPointer<_GtkMenu>?, torn_off: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_set_tearoff_state(menu?.pointer ?: MemorySegment.NULL, torn_off)
    }
    actual fun gtk_menu_get_tearoff_state(menu: KJnaTypedPointer<_GtkMenu>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_tearoff_state(menu?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_set_title(menu: KJnaTypedPointer<_GtkMenu>?, title: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_set_title(menu?.pointer ?: MemorySegment.NULL, title?.memorySegment(_arena))
    }
    actual fun gtk_menu_get_title(menu: KJnaTypedPointer<_GtkMenu>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_title(menu?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_menu_reorder_child(menu: KJnaTypedPointer<_GtkMenu>?, child: KJnaTypedPointer<_GtkWidget>?, position: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_reorder_child(menu?.pointer ?: MemorySegment.NULL, child?.pointer ?: MemorySegment.NULL, position)
    }
    actual fun gtk_menu_set_screen(menu: KJnaTypedPointer<_GtkMenu>?, screen: KJnaTypedPointer<_GdkScreen>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_set_screen(menu?.pointer ?: MemorySegment.NULL, screen?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_attach(menu: KJnaTypedPointer<_GtkMenu>?, child: KJnaTypedPointer<_GtkWidget>?, left_attach: UInt, right_attach: UInt, top_attach: UInt, bottom_attach: UInt) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_attach(menu?.pointer ?: MemorySegment.NULL, child?.pointer ?: MemorySegment.NULL, left_attach.toInt(), right_attach.toInt(), top_attach.toInt(), bottom_attach.toInt())
    }
    actual fun gtk_menu_set_monitor(menu: KJnaTypedPointer<_GtkMenu>?, monitor_num: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_set_monitor(menu?.pointer ?: MemorySegment.NULL, monitor_num)
    }
    actual fun gtk_menu_get_monitor(menu: KJnaTypedPointer<_GtkMenu>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_monitor(menu?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_place_on_monitor(menu: KJnaTypedPointer<_GtkMenu>?, monitor: KJnaTypedPointer<_GdkMonitor>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_place_on_monitor(menu?.pointer ?: MemorySegment.NULL, monitor?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_get_for_attach_widget(widget: KJnaTypedPointer<_GtkWidget>?): KJnaTypedPointer<_GList>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_for_attach_widget(widget?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_set_reserve_toggle_size(menu: KJnaTypedPointer<_GtkMenu>?, reserve_toggle_size: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_set_reserve_toggle_size(menu?.pointer ?: MemorySegment.NULL, reserve_toggle_size)
    }
    actual fun gtk_menu_get_reserve_toggle_size(menu: KJnaTypedPointer<_GtkMenu>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_get_reserve_toggle_size(menu?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_shell_get_type(): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_get_type().toULong()
    }
    actual fun gtk_menu_shell_append(menu_shell: KJnaTypedPointer<_GtkMenuShell>?, child: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_append(menu_shell?.pointer ?: MemorySegment.NULL, child?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_shell_prepend(menu_shell: KJnaTypedPointer<_GtkMenuShell>?, child: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_prepend(menu_shell?.pointer ?: MemorySegment.NULL, child?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_shell_insert(menu_shell: KJnaTypedPointer<_GtkMenuShell>?, child: KJnaTypedPointer<_GtkWidget>?, position: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_insert(menu_shell?.pointer ?: MemorySegment.NULL, child?.pointer ?: MemorySegment.NULL, position)
    }
    actual fun gtk_menu_shell_deactivate(menu_shell: KJnaTypedPointer<_GtkMenuShell>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_deactivate(menu_shell?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_shell_select_item(menu_shell: KJnaTypedPointer<_GtkMenuShell>?, menu_item: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_select_item(menu_shell?.pointer ?: MemorySegment.NULL, menu_item?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_shell_deselect(menu_shell: KJnaTypedPointer<_GtkMenuShell>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_deselect(menu_shell?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_shell_activate_item(menu_shell: KJnaTypedPointer<_GtkMenuShell>?, menu_item: KJnaTypedPointer<_GtkWidget>?, force_deactivate: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_activate_item(menu_shell?.pointer ?: MemorySegment.NULL, menu_item?.pointer ?: MemorySegment.NULL, force_deactivate)
    }
    actual fun gtk_menu_shell_select_first(menu_shell: KJnaTypedPointer<_GtkMenuShell>?, search_sensitive: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_select_first(menu_shell?.pointer ?: MemorySegment.NULL, search_sensitive)
    }
    actual fun gtk_menu_shell_cancel(menu_shell: KJnaTypedPointer<_GtkMenuShell>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_cancel(menu_shell?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_shell_get_take_focus(menu_shell: KJnaTypedPointer<_GtkMenuShell>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_get_take_focus(menu_shell?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_shell_set_take_focus(menu_shell: KJnaTypedPointer<_GtkMenuShell>?, take_focus: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_set_take_focus(menu_shell?.pointer ?: MemorySegment.NULL, take_focus)
    }
    actual fun gtk_menu_shell_get_selected_item(menu_shell: KJnaTypedPointer<_GtkMenuShell>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_get_selected_item(menu_shell?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_shell_get_parent_shell(menu_shell: KJnaTypedPointer<_GtkMenuShell>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_get_parent_shell(menu_shell?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_shell_bind_model(menu_shell: KJnaTypedPointer<_GtkMenuShell>?, model: KJnaTypedPointer<_GMenuModel>?, action_namespace: String?, with_separators: Int) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_shell_bind_model(menu_shell?.pointer ?: MemorySegment.NULL, model?.pointer ?: MemorySegment.NULL, action_namespace?.memorySegment(_arena), with_separators)
    }
    actual fun gtk_menu_item_get_type(): ULong {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_get_type().toULong()
    }
    actual fun gtk_menu_item_new(): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_new()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_item_new_with_label(label: String?): KJnaTypedPointer<_GtkWidget>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_new_with_label(label?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_item_new_with_mnemonic(label: String?): KJnaTypedPointer<_GtkWidget>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_new_with_mnemonic(label?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_item_set_submenu(menu_item: KJnaTypedPointer<_GtkMenuItem>?, submenu: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_set_submenu(menu_item?.pointer ?: MemorySegment.NULL, submenu?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_item_get_submenu(menu_item: KJnaTypedPointer<_GtkMenuItem>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_get_submenu(menu_item?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_menu_item_select(menu_item: KJnaTypedPointer<_GtkMenuItem>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_select(menu_item?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_item_deselect(menu_item: KJnaTypedPointer<_GtkMenuItem>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_deselect(menu_item?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_item_activate(menu_item: KJnaTypedPointer<_GtkMenuItem>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_activate(menu_item?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_item_toggle_size_request(menu_item: KJnaTypedPointer<_GtkMenuItem>?, requisition: KJnaTypedPointer<Int>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_toggle_size_request(menu_item?.pointer ?: MemorySegment.NULL, requisition?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_item_toggle_size_allocate(menu_item: KJnaTypedPointer<_GtkMenuItem>?, allocation: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_toggle_size_allocate(menu_item?.pointer ?: MemorySegment.NULL, allocation)
    }
    actual fun gtk_menu_item_set_right_justified(menu_item: KJnaTypedPointer<_GtkMenuItem>?, right_justified: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_set_right_justified(menu_item?.pointer ?: MemorySegment.NULL, right_justified)
    }
    actual fun gtk_menu_item_get_right_justified(menu_item: KJnaTypedPointer<_GtkMenuItem>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_get_right_justified(menu_item?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_item_set_accel_path(menu_item: KJnaTypedPointer<_GtkMenuItem>?, accel_path: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_set_accel_path(menu_item?.pointer ?: MemorySegment.NULL, accel_path?.memorySegment(_arena))
    }
    actual fun gtk_menu_item_get_accel_path(menu_item: KJnaTypedPointer<_GtkMenuItem>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_get_accel_path(menu_item?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_menu_item_set_label(menu_item: KJnaTypedPointer<_GtkMenuItem>?, label: String?) {
        val _arena: Arena = Arena.ofAuto()
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_set_label(menu_item?.pointer ?: MemorySegment.NULL, label?.memorySegment(_arena))
    }
    actual fun gtk_menu_item_get_label(menu_item: KJnaTypedPointer<_GtkMenuItem>?): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_get_label(menu_item?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun gtk_menu_item_set_use_underline(menu_item: KJnaTypedPointer<_GtkMenuItem>?, setting: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_set_use_underline(menu_item?.pointer ?: MemorySegment.NULL, setting)
    }
    actual fun gtk_menu_item_get_use_underline(menu_item: KJnaTypedPointer<_GtkMenuItem>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_get_use_underline(menu_item?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_menu_item_set_reserve_indicator(menu_item: KJnaTypedPointer<_GtkMenuItem>?, reserve: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_set_reserve_indicator(menu_item?.pointer ?: MemorySegment.NULL, reserve)
    }
    actual fun gtk_menu_item_get_reserve_indicator(menu_item: KJnaTypedPointer<_GtkMenuItem>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_menu_item_get_reserve_indicator(menu_item?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_get_major_version(): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_major_version().toUInt()
    }
    actual fun gtk_get_minor_version(): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_minor_version().toUInt()
    }
    actual fun gtk_get_micro_version(): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_micro_version().toUInt()
    }
    actual fun gtk_get_binary_age(): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_binary_age().toUInt()
    }
    actual fun gtk_get_interface_age(): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_interface_age().toUInt()
    }
    actual fun gtk_check_version(required_major: UInt, required_minor: UInt, required_micro: UInt): String? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_check_version(required_major.toInt(), required_minor.toInt(), required_micro.toInt())?.getString()
    }
    actual fun gtk_parse_args(argc: KJnaTypedPointer<Int>?, argv: KJnaTypedPointer<KJnaTypedPointer<String>?>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_parse_args(argc?.pointer ?: MemorySegment.NULL, argv?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_init(argc: KJnaTypedPointer<Int>?, argv: KJnaTypedPointer<KJnaTypedPointer<String>?>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_init(argc?.pointer ?: MemorySegment.NULL, argv?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_init_check(argc: KJnaTypedPointer<Int>?, argv: KJnaTypedPointer<KJnaTypedPointer<String>?>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_init_check(argc?.pointer ?: MemorySegment.NULL, argv?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_init_with_args(argc: KJnaTypedPointer<Int>?, argv: KJnaTypedPointer<KJnaTypedPointer<String>?>?, parameter_string: String?, entries: KJnaTypedPointer<_GOptionEntry>?, translation_domain: String?, error: KJnaTypedPointer<KJnaTypedPointer<_GError>?>?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libappindicator.jextract.LibAppIndicator.gtk_init_with_args(argc?.pointer ?: MemorySegment.NULL, argv?.pointer ?: MemorySegment.NULL, parameter_string?.memorySegment(_arena), entries?.pointer ?: MemorySegment.NULL, translation_domain?.memorySegment(_arena), error?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_get_option_group(open_default_display: Int): KJnaTypedPointer<_GOptionGroup>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_option_group(open_default_display)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_disable_setlocale() {
        gen.libappindicator.jextract.LibAppIndicator.gtk_disable_setlocale()
    }
    actual fun gtk_get_default_language(): KJnaTypedPointer<_PangoLanguage>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_default_language()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_get_locale_direction(): GtkTextDirection {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_locale_direction().let { GtkTextDirection.fromJvm(it) }
    }
    actual fun gtk_events_pending(): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_events_pending()
    }
    actual fun gtk_main_do_event(event: KJnaTypedPointer<_GdkEvent>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_main_do_event(event?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_main() {
        gen.libappindicator.jextract.LibAppIndicator.gtk_main()
    }
    actual fun gtk_main_level(): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_main_level().toUInt()
    }
    actual fun gtk_main_quit() {
        gen.libappindicator.jextract.LibAppIndicator.gtk_main_quit()
    }
    actual fun gtk_main_iteration(): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_main_iteration()
    }
    actual fun gtk_main_iteration_do(blocking: Int): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_main_iteration_do(blocking)
    }
    actual fun gtk_true(): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_true()
    }
    actual fun gtk_false(): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_false()
    }
    actual fun gtk_grab_add(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_grab_add(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_grab_get_current(): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_grab_get_current()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_grab_remove(widget: KJnaTypedPointer<_GtkWidget>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_grab_remove(widget?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_device_grab_add(widget: KJnaTypedPointer<_GtkWidget>?, device: KJnaTypedPointer<_GdkDevice>?, block_others: Int) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_device_grab_add(widget?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL, block_others)
    }
    actual fun gtk_device_grab_remove(widget: KJnaTypedPointer<_GtkWidget>?, device: KJnaTypedPointer<_GdkDevice>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_device_grab_remove(widget?.pointer ?: MemorySegment.NULL, device?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_key_snooper_install(snooper: KJnaFunctionPointer?, func_data: KJnaPointer?): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_key_snooper_install(snooper?.function ?: MemorySegment.NULL, func_data?.pointer ?: MemorySegment.NULL).toUInt()
    }
    actual fun gtk_key_snooper_remove(snooper_handler_id: UInt) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_key_snooper_remove(snooper_handler_id.toInt())
    }
    actual fun gtk_get_current_event(): KJnaTypedPointer<_GdkEvent>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_current_event()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_get_current_event_time(): UInt {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_current_event_time().toUInt()
    }
    actual fun gtk_get_current_event_state(state: KJnaTypedPointer<GdkModifierType>?): Int {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_current_event_state(state?.pointer ?: MemorySegment.NULL)
    }
    actual fun gtk_get_current_event_device(): KJnaTypedPointer<_GdkDevice>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_current_event_device()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_get_event_widget(event: KJnaTypedPointer<_GdkEvent>?): KJnaTypedPointer<_GtkWidget>? {
        return gen.libappindicator.jextract.LibAppIndicator.gtk_get_event_widget(event?.pointer ?: MemorySegment.NULL)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun gtk_propagate_event(widget: KJnaTypedPointer<_GtkWidget>?, event: KJnaTypedPointer<_GdkEvent>?) {
        gen.libappindicator.jextract.LibAppIndicator.gtk_propagate_event(widget?.pointer ?: MemorySegment.NULL, event?.pointer ?: MemorySegment.NULL)
    }
    
    actual companion object {
        actual fun isAvailable(): Boolean = true
    }
}
