package gen.libmpv

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaFunctionPointer
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.getString
import dev.toastbits.kjna.runtime.memorySegment
import java.lang.foreign.Arena
import java.lang.foreign.Linker
import java.lang.foreign.MemorySegment
import kjna.enum.mpv_event_id
import kjna.enum.mpv_format
import kjna.enum.toJvm
import kjna.struct.mpv_byte_array
import kjna.struct.mpv_event
import kjna.struct.mpv_event_client_message
import kjna.struct.mpv_event_command
import kjna.struct.mpv_event_end_file
import kjna.struct.mpv_event_hook
import kjna.struct.mpv_event_log_message
import kjna.struct.mpv_event_property
import kjna.struct.mpv_event_start_file
import kjna.struct.mpv_handle
import kjna.struct.mpv_node
import kjna.struct.mpv_node_list

actual class LibMpv {
    private val _linker: Linker by lazy { Linker.nativeLinker() }
    private val _function_arena: Arena by lazy { Arena.ofAuto() }
    
    init {
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_byte_array.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_event.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_event_client_message.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_event_command.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_event_end_file.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_event_hook.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_event_log_message.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_event_property.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_event_start_file.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_handle.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_node.Companion)
        KJnaAllocationCompanion.registerAllocationCompanion(mpv_node_list.Companion)
    }

    actual fun mpv_client_api_version(): ULong {
        return gen.libmpv.jextract.LibMpv.mpv_client_api_version().toULong()
    }
    actual fun mpv_error_string(error: Int): String? {
        return gen.libmpv.jextract.LibMpv.mpv_error_string(error)?.getString()
    }
    actual fun mpv_free(data: KJnaPointer?) {
        gen.libmpv.jextract.LibMpv.mpv_free(data?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_client_name(ctx: KJnaTypedPointer<mpv_handle>?): String? {
        return gen.libmpv.jextract.LibMpv.mpv_client_name(ctx?.pointer ?: MemorySegment.NULL)?.getString()
    }
    actual fun mpv_client_id(ctx: KJnaTypedPointer<mpv_handle>?): Long {
        return gen.libmpv.jextract.LibMpv.mpv_client_id(ctx?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_create(): KJnaTypedPointer<mpv_handle>? {
        return gen.libmpv.jextract.LibMpv.mpv_create()?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun mpv_initialize(ctx: KJnaTypedPointer<mpv_handle>?): Int {
        return gen.libmpv.jextract.LibMpv.mpv_initialize(ctx?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_destroy(ctx: KJnaTypedPointer<mpv_handle>?) {
        gen.libmpv.jextract.LibMpv.mpv_destroy(ctx?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_terminate_destroy(ctx: KJnaTypedPointer<mpv_handle>?) {
        gen.libmpv.jextract.LibMpv.mpv_terminate_destroy(ctx?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_create_client(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): KJnaTypedPointer<mpv_handle>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_create_client(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun mpv_create_weak_client(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): KJnaTypedPointer<mpv_handle>? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_create_weak_client(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun mpv_load_config_file(ctx: KJnaTypedPointer<mpv_handle>?, filename: String?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_load_config_file(ctx?.pointer ?: MemorySegment.NULL, filename?.memorySegment(_arena))
    }
    actual fun mpv_get_time_ns(ctx: KJnaTypedPointer<mpv_handle>?): Long {
        return gen.libmpv.jextract.LibMpv.mpv_get_time_ns(ctx?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_get_time_us(ctx: KJnaTypedPointer<mpv_handle>?): Long {
        return gen.libmpv.jextract.LibMpv.mpv_get_time_us(ctx?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_free_node_contents(node: KJnaTypedPointer<mpv_node>?) {
        gen.libmpv.jextract.LibMpv.mpv_free_node_contents(node?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_set_option(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, format: mpv_format, data: KJnaPointer?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_set_option(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena), format.toJvm(), data?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_set_option_string(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, data: String?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_set_option_string(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena), data?.memorySegment(_arena))
    }
    actual fun mpv_command(ctx: KJnaTypedPointer<mpv_handle>?, args: KJnaTypedPointer<String>?): Int {
        return gen.libmpv.jextract.LibMpv.mpv_command(ctx?.pointer ?: MemorySegment.NULL, args?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_command_node(ctx: KJnaTypedPointer<mpv_handle>?, args: KJnaTypedPointer<mpv_node>?, result: KJnaTypedPointer<mpv_node>?): Int {
        return gen.libmpv.jextract.LibMpv.mpv_command_node(ctx?.pointer ?: MemorySegment.NULL, args?.pointer ?: MemorySegment.NULL, result?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_command_ret(ctx: KJnaTypedPointer<mpv_handle>?, args: KJnaTypedPointer<String>?, result: KJnaTypedPointer<mpv_node>?): Int {
        return gen.libmpv.jextract.LibMpv.mpv_command_ret(ctx?.pointer ?: MemorySegment.NULL, args?.pointer ?: MemorySegment.NULL, result?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_command_string(ctx: KJnaTypedPointer<mpv_handle>?, args: String?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_command_string(ctx?.pointer ?: MemorySegment.NULL, args?.memorySegment(_arena))
    }
    actual fun mpv_command_async(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, args: KJnaTypedPointer<String>?): Int {
        return gen.libmpv.jextract.LibMpv.mpv_command_async(ctx?.pointer ?: MemorySegment.NULL, reply_userdata.toLong(), args?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_command_node_async(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, args: KJnaTypedPointer<mpv_node>?): Int {
        return gen.libmpv.jextract.LibMpv.mpv_command_node_async(ctx?.pointer ?: MemorySegment.NULL, reply_userdata.toLong(), args?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_abort_async_command(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong) {
        gen.libmpv.jextract.LibMpv.mpv_abort_async_command(ctx?.pointer ?: MemorySegment.NULL, reply_userdata.toLong())
    }
    actual fun mpv_set_property(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, format: mpv_format, data: KJnaPointer?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_set_property(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena), format.toJvm(), data?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_set_property_string(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, data: String?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_set_property_string(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena), data?.memorySegment(_arena))
    }
    actual fun mpv_del_property(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_del_property(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))
    }
    actual fun mpv_set_property_async(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, name: String?, format: mpv_format, data: KJnaPointer?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_set_property_async(ctx?.pointer ?: MemorySegment.NULL, reply_userdata.toLong(), name?.memorySegment(_arena), format.toJvm(), data?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_get_property(ctx: KJnaTypedPointer<mpv_handle>?, name: String?, format: mpv_format, data: KJnaPointer?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_get_property(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena), format.toJvm(), data?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_get_property_string(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): String? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_get_property_string(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))?.getString()
    }
    actual fun mpv_get_property_osd_string(ctx: KJnaTypedPointer<mpv_handle>?, name: String?): String? {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_get_property_osd_string(ctx?.pointer ?: MemorySegment.NULL, name?.memorySegment(_arena))?.getString()
    }
    actual fun mpv_get_property_async(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, name: String?, format: mpv_format): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_get_property_async(ctx?.pointer ?: MemorySegment.NULL, reply_userdata.toLong(), name?.memorySegment(_arena), format.toJvm())
    }
    actual fun mpv_observe_property(mpv: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, name: String?, format: mpv_format): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_observe_property(mpv?.pointer ?: MemorySegment.NULL, reply_userdata.toLong(), name?.memorySegment(_arena), format.toJvm())
    }
    actual fun mpv_unobserve_property(mpv: KJnaTypedPointer<mpv_handle>?, registered_reply_userdata: ULong): Int {
        return gen.libmpv.jextract.LibMpv.mpv_unobserve_property(mpv?.pointer ?: MemorySegment.NULL, registered_reply_userdata.toLong())
    }
    actual fun mpv_event_name(event: mpv_event_id): String? {
        return gen.libmpv.jextract.LibMpv.mpv_event_name(event.toJvm())?.getString()
    }
    actual fun mpv_event_to_node(dst: KJnaTypedPointer<mpv_node>?, src: KJnaTypedPointer<mpv_event>?): Int {
        return gen.libmpv.jextract.LibMpv.mpv_event_to_node(dst?.pointer ?: MemorySegment.NULL, src?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_request_event(ctx: KJnaTypedPointer<mpv_handle>?, event: mpv_event_id, enable: Int): Int {
        return gen.libmpv.jextract.LibMpv.mpv_request_event(ctx?.pointer ?: MemorySegment.NULL, event.toJvm(), enable)
    }
    actual fun mpv_request_log_messages(ctx: KJnaTypedPointer<mpv_handle>?, min_level: String?): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_request_log_messages(ctx?.pointer ?: MemorySegment.NULL, min_level?.memorySegment(_arena))
    }
    actual fun mpv_wait_event(ctx: KJnaTypedPointer<mpv_handle>?, timeout: Double): KJnaTypedPointer<mpv_event>? {
        return gen.libmpv.jextract.LibMpv.mpv_wait_event(ctx?.pointer ?: MemorySegment.NULL, timeout)?.let { KJnaTypedPointer.ofNativeObject(it) }
    }
    actual fun mpv_wakeup(ctx: KJnaTypedPointer<mpv_handle>?) {
        gen.libmpv.jextract.LibMpv.mpv_wakeup(ctx?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_set_wakeup_callback(ctx: KJnaTypedPointer<mpv_handle>?, cb: KJnaFunctionPointer?, d: KJnaPointer?) {
        gen.libmpv.jextract.LibMpv.mpv_set_wakeup_callback(ctx?.pointer ?: MemorySegment.NULL, cb?.function ?: MemorySegment.NULL, d?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_wait_async_requests(ctx: KJnaTypedPointer<mpv_handle>?) {
        gen.libmpv.jextract.LibMpv.mpv_wait_async_requests(ctx?.pointer ?: MemorySegment.NULL)
    }
    actual fun mpv_hook_add(ctx: KJnaTypedPointer<mpv_handle>?, reply_userdata: ULong, name: String?, priority: Int): Int {
        val _arena: Arena = Arena.ofAuto()
        return gen.libmpv.jextract.LibMpv.mpv_hook_add(ctx?.pointer ?: MemorySegment.NULL, reply_userdata.toLong(), name?.memorySegment(_arena), priority)
    }
    actual fun mpv_hook_continue(ctx: KJnaTypedPointer<mpv_handle>?, id: ULong): Int {
        return gen.libmpv.jextract.LibMpv.mpv_hook_continue(ctx?.pointer ?: MemorySegment.NULL, id.toLong())
    }
    actual fun mpv_get_wakeup_pipe(ctx: KJnaTypedPointer<mpv_handle>?): Int {
        return gen.libmpv.jextract.LibMpv.mpv_get_wakeup_pipe(ctx?.pointer ?: MemorySegment.NULL)
    }
    
    actual companion object {
        actual fun isAvailable(): Boolean = true
    }
}
