package kjna.struct

import dev.toastbits.kjna.runtime.KJnaAllocationCompanion
import dev.toastbits.kjna.runtime.KJnaMemScope
import dev.toastbits.kjna.runtime.KJnaPointer
import dev.toastbits.kjna.runtime.KJnaTypedPointer
import dev.toastbits.kjna.runtime.uncheckedCast
import gen.libappindicator.jextract._GClosure as _jextract__GClosure
import java.lang.foreign.Arena
import java.lang.foreign.MemorySegment
import kjna.struct._GClosureNotifyData

actual class _GClosure constructor(val _jextract_value: MemorySegment, private val _mem_scope: Arena = Arena.ofAuto()) {
    actual var data: KJnaPointer?
        get() = _jextract__GClosure.data(_jextract_value)?.let { KJnaPointer(it).uncheckedCast() }
        set(value) { _jextract__GClosure.data(_jextract_value, value?.pointer) }
    actual var notifiers: KJnaTypedPointer<_GClosureNotifyData>?
        get() = _jextract__GClosure.notifiers(_jextract_value)?.let { KJnaTypedPointer.ofNativeObject(it, _GClosureNotifyData.Companion).uncheckedCast() }
        set(value) { _jextract__GClosure.notifiers(_jextract_value, value?.pointer) }

    override fun toString(): String = 
        "_GClosure(data=$data, notifiers=$notifiers)"

    companion object: KJnaAllocationCompanion<_GClosure>() {
        override fun allocate(scope: KJnaMemScope): KJnaTypedPointer<_GClosure> {
            return KJnaTypedPointer.ofNativeObject(_jextract__GClosure.allocate(scope.jvm_arena), this)
        }
        override fun construct(from: KJnaPointer): _GClosure {
            return _GClosure(from.pointer)
        }
        override fun set(value: _GClosure, pointer: KJnaTypedPointer<_GClosure>) {
            pointer.pointer = value._jextract_value
        }
    }
}
